/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.index;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperCube;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class TreeMBRVisualization
implements VisFactory {
    public static final String INDEX = "index";
    public static final String NAME = "Index MBRs";
    protected Parameterizer settings;

    public TreeMBRVisualization(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewSiblings(context, start, AbstractRStarTree.class, ScatterPlotProjector.class, (tree, p) -> {
            VisualizationTask task = new VisualizationTask(this, NAME, tree, p.getRelation()).level(1).visibility(false);
            context.addVis(tree, task);
            context.addVis(p, task);
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILL_ID = new OptionID("index.fill", "Partially transparent filling of index pages.");
        protected boolean fill = false;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Flag fillF = new Flag(FILL_ID);
            if (config.grab(fillF)) {
                this.fill = fillF.isTrue();
            }
        }

        @Override
        protected TreeMBRVisualization makeInstance() {
            return new TreeMBRVisualization(this);
        }
    }

    public class Instance<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry>
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        protected AbstractRStarTree<N, E, ?> tree;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.tree = (AbstractRStarTree)AbstractRStarTree.class.cast(task.getResult());
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            int projdim = BitsUtil.cardinality(this.proj.getVisibleDimensions2D());
            ColorLibrary colors = style.getColorSet("plot");
            if (this.tree != null) {
                SpatialEntry root = (SpatialEntry)this.tree.getRootEntry();
                for (int i = 0; i < this.tree.getHeight(); ++i) {
                    CSSClass cls = new CSSClass(this, TreeMBRVisualization.INDEX + i);
                    double relDepth = 1.0 - (double)i / (double)this.tree.getHeight();
                    if (TreeMBRVisualization.this.settings.fill) {
                        cls.setStatement("stroke", colors.getColor(i));
                        cls.setStatement("stroke-width", relDepth * style.getLineWidth("plot"));
                        cls.setStatement("fill", colors.getColor(i));
                        cls.setStatement("fill-opacity", 0.1 / (double)(projdim - 1));
                    } else {
                        cls.setStatement("stroke", colors.getColor(i));
                        cls.setStatement("stroke-width", relDepth * style.getLineWidth("plot"));
                        cls.setStatement("fill", "none");
                    }
                    cls.setStatement("stroke-linecap", "round");
                    cls.setStatement("stroke-linejoin", "round");
                    this.svgp.addCSSClassOrLogError(cls);
                }
                this.visualizeRTreeEntry(this.svgp, this.layer, this.proj, this.tree, root, 0);
            }
        }

        private void visualizeRTreeEntry(SVGPlot svgp, Element layer, Projection2D proj, AbstractRStarTree<? extends N, E, ?> rtree, E entry, int depth) {
            Element r;
            E mbr = entry;
            if (TreeMBRVisualization.this.settings.fill) {
                r = SVGHyperCube.drawFilled(svgp, TreeMBRVisualization.INDEX + depth, proj, mbr);
                layer.appendChild(r);
            } else {
                r = SVGHyperCube.drawFrame(svgp, proj, mbr);
                SVGUtil.setCSSClass(r, TreeMBRVisualization.INDEX + depth);
                layer.appendChild(r);
            }
            if (!(entry instanceof LeafEntry)) {
                AbstractRStarTreeNode node = (AbstractRStarTreeNode)rtree.getNode(entry);
                for (int i = 0; i < node.getNumEntries(); ++i) {
                    SpatialEntry child = (SpatialEntry)node.getEntry(i);
                    if (child instanceof LeafEntry) continue;
                    this.visualizeRTreeEntry(svgp, layer, proj, rtree, child, depth + 1);
                }
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            this.context.removeDataStoreListener(this);
        }
    }
}

