/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.index;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.ManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperSphere;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.index.TreeMBRVisualization;
import org.w3c.dom.Element;

public class TreeSphereVisualization
implements VisFactory {
    public static final String INDEX = "index";
    public static final String NAME = "Index Spheres";
    protected Parameterizer settings;

    public TreeSphereVisualization(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewSiblings(context, start, AbstractMTree.class, ScatterPlotProjector.class, (tree, p) -> {
            Relation rel = p.getRelation();
            if (!TreeSphereVisualization.canVisualize(rel, tree)) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, tree, rel).level(1).visibility(false);
            context.addVis(tree, task);
            context.addVis(p, task);
        });
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    public static double getLPNormP(AbstractMTree<?, ?, ?, ?> tree) {
        DistanceFunction<?> distanceFunction = tree.getDistanceFunction();
        if (LPNormDistanceFunction.class.isInstance(distanceFunction)) {
            return ((LPNormDistanceFunction)distanceFunction).getP();
        }
        return 0.0;
    }

    public static boolean canVisualize(Relation<?> rel, AbstractMTree<?, ?, ?, ?> tree) {
        if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
            return false;
        }
        return TreeSphereVisualization.getLPNormP(tree) > 0.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected boolean fill = false;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Flag fillF = new Flag(TreeMBRVisualization.Parameterizer.FILL_ID);
            if (config.grab(fillF)) {
                this.fill = fillF.isTrue();
            }
        }

        @Override
        protected TreeSphereVisualization makeInstance() {
            return new TreeSphereVisualization(this);
        }
    }

    public class Instance<N extends AbstractMTreeNode<?, N, E>, E extends MTreeEntry>
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        protected double p;
        protected Mode dist;
        protected AbstractMTree<?, N, E, ?> tree;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.dist = Mode.LPCROSS;
            this.tree = (AbstractMTree)AbstractMTree.class.cast(task.getResult());
            this.p = TreeSphereVisualization.getLPNormP(this.tree);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            int projdim = BitsUtil.cardinality(this.proj.getVisibleDimensions2D());
            ColorLibrary colors = style.getColorSet("plot");
            this.p = TreeSphereVisualization.getLPNormP(this.tree);
            if (this.tree != null) {
                this.dist = ManhattanDistanceFunction.class.isInstance(this.tree.getDistanceFunction()) ? Mode.MANHATTAN : (EuclideanDistanceFunction.class.isInstance(this.tree.getDistanceFunction()) ? Mode.EUCLIDEAN : Mode.LPCROSS);
                MTreeEntry root = (MTreeEntry)this.tree.getRootEntry();
                int mtheight = this.tree.getHeight();
                for (int i = 0; i < mtheight; ++i) {
                    CSSClass cls = new CSSClass(this, TreeSphereVisualization.INDEX + i);
                    double relDepth = 1.0 - (double)i / (double)mtheight;
                    if (TreeSphereVisualization.this.settings.fill) {
                        cls.setStatement("stroke", colors.getColor(i));
                        cls.setStatement("stroke-width", relDepth * style.getLineWidth("plot"));
                        cls.setStatement("fill", colors.getColor(i));
                        cls.setStatement("fill-opacity", 0.1 / (double)(projdim - 1));
                        cls.setStatement("stroke-linecap", "round");
                        cls.setStatement("stroke-linejoin", "round");
                    } else {
                        cls.setStatement("stroke", colors.getColor(i));
                        cls.setStatement("stroke-width", relDepth * style.getLineWidth("plot"));
                        cls.setStatement("fill", "none");
                        cls.setStatement("stroke-linecap", "round");
                        cls.setStatement("stroke-linejoin", "round");
                    }
                    this.svgp.addCSSClassOrLogError(cls);
                }
                this.visualizeMTreeEntry(this.svgp, this.layer, this.proj, this.tree, root, 0);
            }
        }

        private void visualizeMTreeEntry(SVGPlot svgp, Element layer, Projection2D proj, AbstractMTree<?, N, E, ?> mtree, E entry, int depth) {
            DBID roid = entry.getRoutingObjectID();
            if (roid != null) {
                NumberVector ro = (NumberVector)this.rel.get(roid);
                double rad = entry.getCoveringRadius();
                Element r = this.dist == Mode.MANHATTAN ? SVGHyperSphere.drawManhattan(svgp, proj, ro, rad) : (this.dist == Mode.EUCLIDEAN ? SVGHyperSphere.drawEuclidean(svgp, proj, ro, rad) : SVGHyperSphere.drawLp(svgp, proj, ro, rad, this.p));
                SVGUtil.setCSSClass(r, TreeSphereVisualization.INDEX + (depth - 1));
                layer.appendChild(r);
            }
            if (!(entry instanceof LeafEntry)) {
                AbstractMTreeNode node = (AbstractMTreeNode)mtree.getNode(entry);
                for (int i = 0; i < node.getNumEntries(); ++i) {
                    MTreeEntry child = (MTreeEntry)node.getEntry(i);
                    if (child instanceof LeafEntry) continue;
                    this.visualizeMTreeEntry(svgp, layer, proj, mtree, child, depth + 1);
                }
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            this.context.removeDataStoreListener(this);
        }
    }

    private static enum Mode {
        MANHATTAN,
        EUCLIDEAN,
        LPCROSS;

    }
}

