/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.outlier;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierLinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Lisa Reichert, Erich Schubert, Remigius Wojdanowski, Arthur Zimek", title="Visual Evaluation of Outlier Detection Models", booktitle="Proc. 15th Int. Conf. on Database Systems for Advanced Applications (DASFAA 2010)", url="https://doi.org/10.1007/978-3-642-12098-5_34", bibkey="DBLP:conf/dasfaa/AchtertKRSWZ10")
public class BubbleVisualization
implements VisFactory {
    public static final String BUBBLE = "bubble";
    public static final String NAME = "Outlier Bubbles";
    protected Parameterizer settings;

    public BubbleVisualization(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        if (this.settings.scaling != null && this.settings.scaling instanceof OutlierScaling) {
            OutlierResult outlierResult = (OutlierResult)task.getResult();
            ((OutlierScaling)this.settings.scaling).prepare(outlierResult);
        }
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewSiblings(context, start, OutlierResult.class, ScatterPlotProjector.class, (o, p) -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            boolean vis = true;
            if (o.getHierarchy().iterParents(o).filter(OutlierResult.class).valid()) {
                vis = false;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, o, rel).level(100).visibility(vis).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY);
            context.addVis(o, task);
            context.addVis(p, task);
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILL_ID = new OptionID("bubble.fill", "Half-transparent filling of bubbles.");
        public static final OptionID SCALING_ID = new OptionID("bubble.scaling", "Additional scaling function for bubbles.");
        protected boolean fill;
        protected ScalingFunction scaling;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter scalingP;
            super.makeOptions(config);
            Flag fillF = new Flag(FILL_ID);
            if (config.grab(fillF)) {
                this.fill = fillF.isTrue();
            }
            if (config.grab(scalingP = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, OutlierLinearScaling.class))) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
        }

        @Override
        protected BubbleVisualization makeInstance() {
            return new BubbleVisualization(this);
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        protected OutlierResult result;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.result = (OutlierResult)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            StylingPolicy stylepolicy = this.context.getStylingPolicy();
            double bubble_size = style.getSize("plot.bubble");
            if (stylepolicy instanceof ClassStylingPolicy) {
                ClassStylingPolicy colors = (ClassStylingPolicy)stylepolicy;
                this.setupCSS(this.svgp, colors);
                DBIDIter objId = this.sample.getSample().iter();
                while (objId.valid()) {
                    double[] v;
                    NumberVector vec;
                    double radius = this.getScaledForId(objId);
                    if (radius > 0.01 && !Double.isInfinite(radius) && (vec = (NumberVector)this.rel.get(objId)) != null && (v = this.proj.fastProjectDataToRenderSpace(vec))[0] == v[0] && v[1] == v[1]) {
                        Element circle = this.svgp.svgCircle(v[0], v[1], radius * bubble_size);
                        SVGUtil.addCSSClass(circle, BubbleVisualization.BUBBLE + colors.getStyleForDBID(objId));
                        this.layer.appendChild(circle);
                    }
                    objId.advance();
                }
            } else {
                DBIDIter objId = this.sample.getSample().iter();
                while (objId.valid()) {
                    double[] v;
                    NumberVector vec;
                    double radius = this.getScaledForId(objId);
                    if (radius > 0.01 && !Double.isInfinite(radius) && (vec = (NumberVector)this.rel.get(objId)) != null && (v = this.proj.fastProjectDataToRenderSpace(vec))[0] == v[0] && v[1] == v[1]) {
                        Element circle = this.svgp.svgCircle(v[0], v[1], radius * bubble_size);
                        int color = stylepolicy.getColorForDBID(objId);
                        StringBuilder cssstyle = new StringBuilder();
                        if (BubbleVisualization.this.settings.fill) {
                            cssstyle.append("fill").append(':').append(SVGUtil.colorToString(color));
                            cssstyle.append("fill-opacity").append(":0.5");
                        } else {
                            cssstyle.append("stroke").append(':').append(SVGUtil.colorToString(color));
                            cssstyle.append("fill").append(':').append("none");
                        }
                        SVGUtil.setAtt(circle, "style", cssstyle.toString());
                        this.layer.appendChild(circle);
                    }
                    objId.advance();
                }
            }
        }

        private void setupCSS(SVGPlot svgp, ClassStylingPolicy policy) {
            StyleLibrary style = this.context.getStyleLibrary();
            ColorLibrary colors = style.getColorSet("plot");
            for (int clusterID = policy.getMinStyle(); clusterID < policy.getMaxStyle(); ++clusterID) {
                CSSClass bubble = new CSSClass(svgp, BubbleVisualization.BUBBLE + clusterID);
                bubble.setStatement("stroke-width", style.getLineWidth("plot"));
                String color = colors.getColor(clusterID);
                if (BubbleVisualization.this.settings.fill) {
                    bubble.setStatement("fill", color);
                    bubble.setStatement("fill-opacity", 0.5);
                } else {
                    bubble.setStatement("stroke", color);
                    bubble.setStatement("fill", "none");
                }
                svgp.addCSSClassOrLogError(bubble);
            }
        }

        protected double getScaledForId(DBIDRef id) {
            double d = this.result.getScores().doubleValue(id);
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return 0.0;
            }
            if (BubbleVisualization.this.settings.scaling == null) {
                return this.result.getOutlierMeta().normalizeScore(d);
            }
            return BubbleVisualization.this.settings.scaling.getScaled(d);
        }
    }
}

