/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.outlier;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

@Title(value="COP: Correlation Outlier Probability")
@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Outlier Detection in Arbitrarily Oriented Subspaces", booktitle="Proc. IEEE Int. Conf. on Data Mining (ICDM 2012)", url="https://doi.org/10.1109/ICDM.2012.21", bibkey="DBLP:conf/icdm/KriegelKSZ12")
public class COPVectorVisualization
implements VisFactory {
    public static final String NAME = "Error Vectors";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewSiblings(context, start, OutlierResult.class, ScatterPlotProjector.class, (o, p) -> {
            Relation rel2 = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel2.getDataTypeInformation())) {
                return;
            }
            VisualizationTree.findNewResults(context, o).filter(Relation.class).forEach(rel -> {
                if (!rel.getShortName().equals("cop-errorvec")) {
                    return;
                }
                VisualizationTask task = new VisualizationTask(this, NAME, rel, rel2).level(100).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE);
                context.addVis(o, task);
                context.addVis(p, task);
            });
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String VEC = "copvec";
        protected Relation<double[]> result;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.result = (Relation)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.setupCSS(this.svgp);
            DBIDIter objId = this.sample.getSample().iter();
            while (objId.valid()) {
                double[] v;
                NumberVector vec;
                double[] ev;
                double[] evec = this.result.get(objId);
                if (evec != null && !(VMath.euclideanLength(ev = this.proj.fastProjectRelativeDataToRenderSpace(evec)) < 0.01) && (vec = (NumberVector)this.rel.get(objId)) != null && (v = this.proj.fastProjectDataToRenderSpace(vec))[0] == v[0] && v[1] == v[1]) {
                    Element arrow = this.svgp.svgLine(v[0], v[1], v[0] + ev[0], v[1] + ev[1]);
                    SVGUtil.addCSSClass(arrow, VEC);
                    this.layer.appendChild(arrow);
                }
                objId.advance();
            }
        }

        private void setupCSS(SVGPlot svgp) {
            StyleLibrary style = this.context.getStyleLibrary();
            CSSClass bubble = new CSSClass(svgp, VEC);
            bubble.setStatement("stroke-width", style.getLineWidth("plot") / 2.0);
            String color = "red";
            bubble.setStatement("stroke", color);
            bubble.setStatement("fill", "none");
            svgp.addCSSClassOrLogError(bubble);
        }
    }
}

