/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.ArcCosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.CosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperSphere;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import net.jafama.DoubleWrapper;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public class DistanceFunctionVisualization
implements VisFactory {
    public static final String NAME = "k Nearest Neighbor Visualization";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewSiblings(context, start, AbstractMaterializeKNNPreprocessor.class, ScatterPlotProjector.class, (kNN, p) -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, kNN, rel).level(99).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_SELECTION);
            context.addVis(kNN, task);
            context.addVis(p, task);
        });
    }

    public static double getLPNormP(AbstractMaterializeKNNPreprocessor<?> kNN) {
        DistanceFunction<?> distanceFunction = kNN.getDistanceQuery().getDistanceFunction();
        if (LPNormDistanceFunction.class.isInstance(distanceFunction)) {
            return ((LPNormDistanceFunction)distanceFunction).getP();
        }
        return Double.NaN;
    }

    public static boolean isAngularDistance(AbstractMaterializeKNNPreprocessor<?> kNN) {
        DistanceFunction<?> distanceFunction = kNN.getDistanceQuery().getDistanceFunction();
        return CosineDistanceFunction.class.isInstance(distanceFunction) || ArcCosineDistanceFunction.class.isInstance(distanceFunction);
    }

    public static Element drawCosine(SVGPlot svgp, Projection2D proj, NumberVector mid, double angle) {
        double[] pointOfOrigin = proj.fastProjectDataToRenderSpace(new double[proj.getInputDimensionality()]);
        double[] selPoint = proj.fastProjectDataToRenderSpace(mid);
        double[] pm = mid.toArray();
        double[] p1 = VMath.minusEquals(proj.fastProjectRenderToDataSpace(selPoint[0] + 10.0, selPoint[1]), pm);
        double[] p2 = VMath.minusEquals(proj.fastProjectRenderToDataSpace(selPoint[0], selPoint[1] + 10.0), pm);
        VMath.timesEquals(p1, 1.0 / VMath.euclideanLength(p1));
        VMath.timesEquals(p2, 1.0 / VMath.euclideanLength(p2));
        if (Math.abs(VMath.scalarProduct(p1, p2)) > 1.0E-10) {
            LoggingUtil.warning("Projection does not seem to be orthogonal?");
        }
        double l1 = VMath.scalarProduct(pm, p1);
        double l2 = VMath.scalarProduct(pm, p2);
        DoubleWrapper tmp = new DoubleWrapper();
        double sangle = FastMath.sinAndCos(angle, tmp);
        double cangle = tmp.value;
        double r11 = cangle * l1 - sangle * l2;
        double r12 = sangle * l1 + cangle * l2;
        double r21 = cangle * l1 + sangle * l2;
        double r22 = -sangle * l1 + cangle * l2;
        double[] r1 = VMath.plusTimesEquals(VMath.plusTimes(pm, p1, -l1 + r11), p2, -l2 + r12);
        double[] r2 = VMath.plusTimesEquals(VMath.plusTimes(pm, p1, -l1 + r21), p2, -l2 + r22);
        double[] range1 = proj.fastProjectDataToRenderSpace(r1);
        double[] range2 = proj.fastProjectDataToRenderSpace(r2);
        CanvasSize viewport = proj.estimateViewport();
        VMath.minusEquals(range1, pointOfOrigin);
        VMath.plusEquals(VMath.timesEquals(range1, viewport.continueToMargin(pointOfOrigin, range1)), pointOfOrigin);
        VMath.minusEquals(range2, pointOfOrigin);
        VMath.plusEquals(VMath.timesEquals(range2, viewport.continueToMargin(pointOfOrigin, range2)), pointOfOrigin);
        double[] start1 = VMath.minus(pointOfOrigin, range1);
        VMath.plusEquals(VMath.timesEquals(start1, viewport.continueToMargin(range1, start1)), range1);
        double[] start2 = VMath.minus(pointOfOrigin, range2);
        VMath.plusEquals(VMath.timesEquals(start2, viewport.continueToMargin(range2, start2)), range2);
        return new SVGPath().moveTo(start1).lineTo(range1).moveTo(start2).lineTo(range2).makeElement(svgp);
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String KNNMARKER = "kNNMarker";
        public static final String KNNDIST = "kNNDist";
        public static final String DISTANCEFUNCTION = "distancefunction";
        private AbstractMaterializeKNNPreprocessor<? extends NumberVector> result;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.result = (AbstractMaterializeKNNPreprocessor)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            block9: {
                this.setupCanvas();
                StyleLibrary style = this.context.getStyleLibrary();
                this.addCSSClasses(this.svgp);
                double p = DistanceFunctionVisualization.getLPNormP(this.result);
                boolean angular = DistanceFunctionVisualization.isAngularDistance(this.result);
                double size = style.getSize("plot.selection");
                DBIDSelection selContext = this.context.getSelection();
                if (selContext == null) break block9;
                DBIDs selection = selContext.getSelectedIds();
                DBIDIter i = selection.iter();
                while (i.valid()) {
                    block14: {
                        Element dist;
                        block11: {
                            DoubleDBIDListIter iter;
                            block13: {
                                block12: {
                                    block10: {
                                        KNNList knn = this.result.get(i);
                                        iter = knn.iter();
                                        while (iter.valid()) {
                                            try {
                                                double[] v = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(iter));
                                                if (v[0] == v[0] && v[1] == v[1]) {
                                                    Element dot = this.svgp.svgCircle(v[0], v[1], size);
                                                    SVGUtil.addCSSClass(dot, KNNMARKER);
                                                    this.layer.appendChild(dot);
                                                    Element lbl = this.svgp.svgText(v[0] + size, v[1] + size, Double.toString(iter.doubleValue()));
                                                    SVGUtil.addCSSClass(lbl, KNNDIST);
                                                    this.layer.appendChild(lbl);
                                                }
                                            }
                                            catch (ObjectNotFoundException v) {
                                                // empty catch block
                                            }
                                            iter.advance();
                                        }
                                        iter.seek(knn.size() - 1);
                                        if (p != 1.0) break block10;
                                        dist = SVGHyperSphere.drawManhattan(this.svgp, this.proj, (NumberVector)this.rel.get(i), iter.doubleValue());
                                        break block11;
                                    }
                                    if (p != 2.0) break block12;
                                    dist = SVGHyperSphere.drawEuclidean(this.svgp, this.proj, (NumberVector)this.rel.get(i), iter.doubleValue());
                                    break block11;
                                }
                                if (Double.isNaN(p)) break block13;
                                dist = SVGHyperSphere.drawLp(this.svgp, this.proj, (NumberVector)this.rel.get(i), iter.doubleValue(), p);
                                break block11;
                            }
                            if (!angular) break block14;
                            NumberVector refvec = (NumberVector)this.rel.get(i);
                            double maxangle = Math.acos(VectorUtil.cosAngle(refvec, (NumberVector)this.rel.get(iter)));
                            dist = DistanceFunctionVisualization.drawCosine(this.svgp, this.proj, refvec, maxangle);
                        }
                        SVGUtil.addCSSClass(dist, DISTANCEFUNCTION);
                        this.layer.appendChild(dist);
                    }
                    i.advance();
                }
            }
        }

        private void addCSSClasses(SVGPlot svgp) {
            CSSClass cls;
            StyleLibrary style = this.context.getStyleLibrary();
            if (!svgp.getCSSClassManager().contains(KNNMARKER)) {
                cls = new CSSClass(this, KNNMARKER);
                cls.setStatement("fill", "darkgreen");
                cls.setStatement("opacity", style.getOpacity("plot.selection"));
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(DISTANCEFUNCTION)) {
                cls = new CSSClass(this, DISTANCEFUNCTION);
                cls.setStatement("stroke", "red");
                cls.setStatement("stroke-width", style.getLineWidth("plot"));
                cls.setStatement("fill", "none");
                cls.setStatement("stroke-linecap", "round");
                cls.setStatement("stroke-linejoin", "round");
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(KNNDIST)) {
                cls = new CSSClass(this, KNNDIST);
                cls.setStatement("fill", "black");
                cls.setStatement("font-size", style.getTextSize("plot"));
                cls.setStatement("font-family", style.getFontFamily("plot"));
                svgp.addCSSClassOrLogError(cls);
            }
        }
    }
}

