/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.UpdatableDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class MoveObjectsToolVisualization
implements VisFactory {
    private static final String NAME = "Move Objects";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        Database db = ResultUtil.findDatabase(context.getHierarchy());
        if (!(db instanceof UpdatableDatabase)) {
            return;
        }
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p.getRelation(), rel).level(1000).tool(true).visibility(false).with(VisualizationTask.RenderFlag.NO_THUMBNAIL).with(VisualizationTask.RenderFlag.NO_EXPORT).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_SELECTION));
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DragableArea.DragListener {
        protected static final String CSS_ARROW = "moveArrow";
        private Element rtag;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g", CSS_ARROW);
            this.layer.appendChild(this.rtag);
            this.layer.appendChild(new DragableArea((SVGPlot)this.svgp, -60.0, -70.0, 130.0, 140.0, this).getElement());
        }

        private void updateDB(DBIDs dbids, double[] movingVector) {
            throw new AbortException("FIXME: INCOMPLETE TRANSITION");
        }

        private void deleteChildren(Element container) {
            while (container.hasChildNodes()) {
                container.removeChild(container.getLastChild());
            }
        }

        private void addCSSClasses(SVGPlot svgp) {
            if (!svgp.getCSSClassManager().contains(CSS_ARROW)) {
                CSSClass acls = new CSSClass(this, CSS_ARROW);
                StyleLibrary style = this.context.getStyleLibrary();
                acls.setStatement("stroke", style.getColor("plot.selection.active"));
                acls.setStatement("stroke-width", style.getLineWidth("plot.selection.active"));
                acls.setStatement("stroke-linecap", "round");
                svgp.addCSSClassOrLogError(acls);
            }
        }

        @Override
        public boolean startDrag(SVGPoint startPoint, Event evt) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            this.deleteChildren(this.rtag);
            this.rtag.appendChild(this.svgp.svgLine(startPoint.getX(), startPoint.getY(), dragPoint.getX(), dragPoint.getY()));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            double[] movingVector = new double[]{dragPoint.getX() - startPoint.getX(), dragPoint.getY() - startPoint.getY()};
            if (this.context.getSelection() != null) {
                this.updateDB(this.context.getSelection().getSelectedIds(), movingVector);
            }
            this.deleteChildren(this.rtag);
            return true;
        }
    }
}

