/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.geometry.FilteredConvexHull2D;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;

public class SelectionConvexHullVisualization
implements VisFactory {
    private static final String NAME = "Selection Hull";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(98).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SELECTION);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String SELECTEDHULL = "selectionConvexHull";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            DBIDSelection selContext = this.context.getSelection();
            if (selContext != null) {
                DBIDs selection = selContext.getSelectedIds();
                FilteredConvexHull2D hull = new FilteredConvexHull2D();
                DBIDIter iter = selection.iter();
                while (iter.valid()) {
                    try {
                        double[] v = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(iter));
                        if (v[0] == v[0] && v[1] == v[1]) {
                            hull.add(v);
                        }
                    }
                    catch (ObjectNotFoundException v) {
                        // empty catch block
                    }
                    iter.advance();
                }
                Polygon chres = hull.getHull();
                if (chres != null && chres.size() >= 3) {
                    SVGPath path = new SVGPath(chres);
                    this.layer.appendChild(path.makeElement(this.svgp, SELECTEDHULL));
                }
            }
        }

        private void addCSSClasses(SVGPlot svgp) {
            if (!svgp.getCSSClassManager().contains(SELECTEDHULL)) {
                StyleLibrary style = this.context.getStyleLibrary();
                CSSClass cls = new CSSClass(this, SELECTEDHULL);
                cls.setStatement("stroke", style.getColor("plot.selection"));
                cls.setStatement("stroke-width", style.getLineWidth("plot.selection"));
                cls.setStatement("fill", style.getColor("plot.selection"));
                cls.setStatement("opacity", ".25");
                cls.setStatement("stroke-linecap", "round");
                cls.setStatement("stroke-linejoin", "round");
                svgp.addCSSClassOrLogError(cls);
            }
        }
    }
}

