/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.RangeSelection;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperCube;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class SelectionCubeVisualization
implements VisFactory {
    private static final String NAME = "Selection Range";
    protected Parameterizer settings;

    public SelectionCubeVisualization(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(98).with(VisualizationTask.UpdateFlag.ON_SELECTION);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NOFILL_ID = new OptionID("selectionrange.nofill", "Use wireframe style for selection ranges.");
        protected boolean nofill;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Flag nofillF = new Flag(NOFILL_ID);
            if (config.grab(nofillF)) {
                this.nofill = nofillF.isTrue();
            }
        }

        @Override
        protected SelectionCubeVisualization makeInstance() {
            return new SelectionCubeVisualization(this);
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String MARKER = "selectionCubeMarker";
        public static final String CSS_CUBE = "selectionCube";
        public static final String CSS_CUBEFRAME = "selectionCubeFrame";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        private void addCSSClasses(SVGPlot svgp) {
            CSSClass cls;
            StyleLibrary style = this.context.getStyleLibrary();
            if (!svgp.getCSSClassManager().contains(CSS_CUBE)) {
                cls = new CSSClass(this, CSS_CUBE);
                cls.setStatement("stroke", style.getColor("plot.selection"));
                cls.setStatement("stroke-opacity", style.getOpacity("plot.selection"));
                cls.setStatement("stroke-width", style.getLineWidth("plot"));
                cls.setStatement("stroke-linecap", "round");
                cls.setStatement("stroke-linejoin", "round");
                if (SelectionCubeVisualization.this.settings.nofill) {
                    cls.setStatement("fill", "none");
                } else {
                    cls.setStatement("fill", style.getColor("plot.selection"));
                    cls.setStatement("fill-opacity", style.getOpacity("plot.selection"));
                }
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(CSS_CUBEFRAME)) {
                cls = new CSSClass(this, CSS_CUBEFRAME);
                cls.setStatement("stroke", style.getColor("plot.selection"));
                cls.setStatement("stroke-opacity", style.getOpacity("plot.selection"));
                cls.setStatement("stroke-width", style.getLineWidth("plot.selection"));
                svgp.addCSSClassOrLogError(cls);
            }
        }

        private void setSVGRect(SVGPlot svgp, Projection2D proj) {
            DBIDSelection selContext = this.context.getSelection();
            if (selContext instanceof RangeSelection) {
                ModifiableHyperBoundingBox ranges = ((RangeSelection)selContext).getRanges();
                if (SelectionCubeVisualization.this.settings.nofill) {
                    Element r = SVGHyperCube.drawFrame(svgp, proj, ranges);
                    SVGUtil.setCSSClass(r, CSS_CUBEFRAME);
                    this.layer.appendChild(r);
                } else {
                    Element r = SVGHyperCube.drawFilled(svgp, CSS_CUBE, proj, ranges);
                    this.layer.appendChild(r);
                }
            }
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            DBIDSelection selContext = this.context.getSelection();
            if (selContext instanceof RangeSelection) {
                this.setSVGRect(this.svgp, this.proj);
            }
        }
    }
}

