/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class SelectionDotVisualization
implements VisFactory {
    private static final String NAME = "Selection Markers";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(99).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SELECTION);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String MARKER = "selectionDotMarker";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            DBIDSelection selContext = this.context.getSelection();
            if (selContext == null) {
                return;
            }
            StyleLibrary style = this.context.getStyleLibrary();
            if (!this.svgp.getCSSClassManager().contains(MARKER)) {
                CSSClass cls = new CSSClass(this, MARKER);
                cls.setStatement("fill", style.getColor("plot.selection"));
                cls.setStatement("opacity", style.getOpacity("plot.selection"));
                this.svgp.addCSSClassOrLogError(cls);
            }
            double size = style.getSize("plot.selection");
            DBIDIter iter = selContext.getSelectedIds().iter();
            while (iter.valid()) {
                try {
                    double[] v = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(iter));
                    if (v[0] == v[0] && v[1] == v[1]) {
                        Element dot = this.svgp.svgCircle(v[0], v[1], size);
                        SVGUtil.addCSSClass(dot, MARKER);
                        this.layer.appendChild(dot);
                    }
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
                iter.advance();
            }
        }
    }
}

