/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.RangeSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class SelectionToolCubeVisualization
implements VisFactory {
    private static final Logging LOG = Logging.getLogger(SelectionToolCubeVisualization.class);
    private static final String NAME = "Range Selection";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(1000).tool(true).visibility(false).with(VisualizationTask.RenderFlag.NO_THUMBNAIL).with(VisualizationTask.RenderFlag.NO_EXPORT).with(VisualizationTask.UpdateFlag.ON_SELECTION);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DragableArea.DragListener {
        private static final String CSS_RANGEMARKER = "selectionRangeMarker";
        private int dim;
        private Element rtag;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.dim = RelationUtil.dimensionality(this.rel);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g", CSS_RANGEMARKER);
            this.layer.appendChild(this.rtag);
            this.layer.appendChild(new DragableArea((SVGPlot)this.svgp, -60.0, -70.0, 130.0, 140.0, this).getElement());
        }

        private void deleteChildren(Element container) {
            while (container.hasChildNodes()) {
                container.removeChild(container.getLastChild());
            }
        }

        private void updateSelectionRectKoordinates(double x1, double x2, double y1, double y2, ModifiableHyperBoundingBox ranges) {
            double[] nv1 = this.proj.fastProjectRenderToDataSpace(x1, y1);
            double[] nv2 = this.proj.fastProjectRenderToDataSpace(x2, y2);
            long[] actDim = this.proj.getVisibleDimensions2D();
            int d = BitsUtil.nextSetBit(actDim, 0);
            while (d >= 0) {
                ranges.setMin(d, Math.min(nv1[d], nv2[d]));
                ranges.setMax(d, Math.max(nv1[d], nv2[d]));
                d = BitsUtil.nextSetBit(actDim, d + 1);
            }
        }

        @Override
        public boolean startDrag(SVGPoint startPoint, Event evt) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            this.deleteChildren(this.rtag);
            double x = Math.min(startPoint.getX(), dragPoint.getX());
            double y = Math.min(startPoint.getY(), dragPoint.getY());
            double width = Math.abs(startPoint.getX() - dragPoint.getX());
            double height = Math.abs(startPoint.getY() - dragPoint.getY());
            this.rtag.appendChild(this.svgp.svgRect(x, y, width, height));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            this.deleteChildren(this.rtag);
            if (startPoint.getX() != dragPoint.getX() || startPoint.getY() != dragPoint.getY()) {
                this.updateSelection(startPoint, dragPoint);
            }
            return true;
        }

        private void updateSelection(SVGPoint p1, SVGPoint p2) {
            if (p1 == null || p2 == null) {
                LOG.warning("no rect selected: p1: " + p1 + " p2: " + p2);
                return;
            }
            DBIDSelection selContext = this.context.getSelection();
            HashSetModifiableDBIDs selection = selContext != null ? DBIDUtil.newHashSet(selContext.getSelectedIds()) : DBIDUtil.newHashSet();
            double x1 = Math.min(p1.getX(), p2.getX());
            double x2 = Math.max(p1.getX(), p2.getX());
            double y1 = Math.max(p1.getY(), p2.getY());
            double y2 = Math.min(p1.getY(), p2.getY());
            ModifiableHyperBoundingBox ranges = selContext instanceof RangeSelection ? ((RangeSelection)selContext).getRanges() : new ModifiableHyperBoundingBox(this.dim, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.updateSelectionRectKoordinates(x1, x2, y1, y2, ranges);
            selection.clear();
            DBIDIter iditer = this.rel.iterDBIDs();
            while (iditer.valid()) {
                block4: {
                    NumberVector dbTupel = (NumberVector)this.rel.get(iditer);
                    for (int i = 0; i < this.dim; ++i) {
                        double v;
                        double min = ranges.getMin(i);
                        double max = ranges.getMax(i);
                        if (!(max < Double.POSITIVE_INFINITY) && !(min > Double.NEGATIVE_INFINITY) || !((v = dbTupel.doubleValue(i)) < min) && !(v > max)) {
                            continue;
                        }
                        break block4;
                    }
                    selection.add(iditer);
                }
                iditer.advance();
            }
            this.context.setSelection(new RangeSelection(selection, ranges));
        }

        protected void addCSSClasses(SVGPlot svgp) {
            if (!svgp.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass rcls = new CSSClass(this, CSS_RANGEMARKER);
                StyleLibrary style = this.context.getStyleLibrary();
                rcls.setStatement("fill", style.getColor("plot.selection.active"));
                rcls.setStatement("opacity", style.getOpacity("plot.selection.active"));
                svgp.addCSSClassOrLogError(rcls);
            }
        }
    }
}

