/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class SelectionToolDotVisualization
implements VisFactory {
    private static final String NAME = "Object Selection";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(1000).tool(true).visibility(false).with(VisualizationTask.RenderFlag.NO_THUMBNAIL).with(VisualizationTask.RenderFlag.NO_EXPORT).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SELECTION);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DragableArea.DragListener {
        private static final String CSS_RANGEMARKER = "selectionRangeMarker";
        Element rtag;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g", CSS_RANGEMARKER);
            this.layer.appendChild(this.rtag);
            this.layer.appendChild(new DragableArea((SVGPlot)this.svgp, -60.0, -70.0, 130.0, 140.0, this).getElement());
        }

        private void deleteChildren(Element container) {
            while (container.hasChildNodes()) {
                container.removeChild(container.getLastChild());
            }
        }

        @Override
        public boolean startDrag(SVGPoint startPoint, Event evt) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            this.deleteChildren(this.rtag);
            double x = Math.min(startPoint.getX(), dragPoint.getX());
            double y = Math.min(startPoint.getY(), dragPoint.getY());
            double width = Math.abs(startPoint.getX() - dragPoint.getX());
            double height = Math.abs(startPoint.getY() - dragPoint.getY());
            this.rtag.appendChild(this.svgp.svgRect(x, y, width, height));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            Mode mode = this.getInputMode(evt);
            this.deleteChildren(this.rtag);
            if (startPoint.getX() != dragPoint.getX() || startPoint.getY() != dragPoint.getY()) {
                this.updateSelection(mode, this.proj, startPoint, dragPoint);
            }
            return true;
        }

        private Mode getInputMode(Event evt) {
            if (evt instanceof DOMMouseEvent) {
                DOMMouseEvent domme = (DOMMouseEvent)evt;
                return domme.getShiftKey() ? Mode.ADD : (domme.getCtrlKey() ? Mode.INVERT : Mode.REPLACE);
            }
            return Mode.REPLACE;
        }

        private void updateSelection(Mode mode, Projection2D proj, SVGPoint p1, SVGPoint p2) {
            DBIDSelection selContext = this.context.getSelection();
            HashSetModifiableDBIDs selection = selContext == null || mode == Mode.REPLACE ? DBIDUtil.newHashSet() : DBIDUtil.newHashSet(selContext.getSelectedIds());
            DBIDIter iditer = this.rel.iterDBIDs();
            while (iditer.valid()) {
                double[] vec = proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(iditer));
                if (vec[0] >= (double)Math.min(p1.getX(), p2.getX()) && vec[0] <= (double)Math.max(p1.getX(), p2.getX()) && vec[1] >= (double)Math.min(p1.getY(), p2.getY()) && vec[1] <= (double)Math.max(p1.getY(), p2.getY())) {
                    if (mode == Mode.INVERT) {
                        if (!selection.add(iditer)) {
                            selection.remove(iditer);
                        }
                    } else {
                        selection.add(iditer);
                    }
                }
                iditer.advance();
            }
            this.context.setSelection(new DBIDSelection(selection));
        }

        protected void addCSSClasses(SVGPlot svgp) {
            if (!svgp.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass rcls = new CSSClass(this, CSS_RANGEMARKER);
                StyleLibrary style = this.context.getStyleLibrary();
                rcls.setStatement("fill", style.getColor("plot.selection.active"));
                rcls.setStatement("opacity", style.getOpacity("plot.selection.active"));
                svgp.addCSSClassOrLogError(rcls);
            }
        }
    }

    private static enum Mode {
        REPLACE,
        ADD,
        INVERT;

    }
}

