/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.uncertain;

import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperCube;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class UncertainBoundingBoxVisualization
implements VisFactory {
    private static final String NAME = "Uncertain Bounding Boxes";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation r = p.getRelation();
            if (UncertainObject.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(r.getDataTypeInformation())) {
                context.addVis(p, new VisualizationTask(this, NAME, p, r).level(100).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
            }
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String CSS_CLASS = "uncertainbb";
        protected final Relation<? extends UncertainObject> rel;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
            this.rel = task.getRelation();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            double opac = 0.1;
            StyleLibrary style = this.context.getStyleLibrary();
            double lw = 0.25 * style.getLineWidth("plot");
            StylingPolicy spol = this.context.getStylingPolicy();
            ColorLibrary colors = style.getColorSet("plot");
            if (spol instanceof ClassStylingPolicy) {
                ClassStylingPolicy cspol = (ClassStylingPolicy)spol;
                for (int cnum = cspol.getMinStyle(); cnum < cspol.getMaxStyle(); ++cnum) {
                    String css = "uncertainbb_" + cnum;
                    String color = colors.getColor(cnum);
                    CSSClass cls = new CSSClass(this, css);
                    cls.setStatement("stroke-width", lw);
                    cls.setStatement("stroke-linecap", "round");
                    cls.setStatement("stroke", color);
                    cls.setStatement("fill", color);
                    cls.setStatement("fill-opacity", 0.1);
                    this.svgp.addCSSClassOrLogError(cls);
                    DBIDIter iter = cspol.iterateClass(cnum);
                    while (iter.valid()) {
                        if (this.sample.getSample().contains(iter)) {
                            try {
                                UncertainObject mbr = this.rel.get(iter);
                                Element r = SVGHyperCube.drawFrame(this.svgp, this.proj, mbr);
                                SVGUtil.addCSSClass(r, css);
                                this.layer.appendChild(r);
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                                // empty catch block
                            }
                        }
                        iter.advance();
                    }
                }
            } else {
                String STROKE = "stroke:";
                DBIDIter iter = this.sample.getSample().iter();
                while (iter.valid()) {
                    try {
                        UncertainObject mbr = this.rel.get(iter);
                        Element r = SVGHyperCube.drawFrame(this.svgp, this.proj, mbr);
                        SVGUtil.addCSSClass(r, CSS_CLASS);
                        int col = spol.getColorForDBID(iter);
                        SVGUtil.setAtt(r, "style", "stroke:" + SVGUtil.colorToString(col));
                        this.layer.appendChild(r);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        // empty catch block
                    }
                    iter.advance();
                }
            }
        }
    }
}

