/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.uncertain;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;

public class UncertainInstancesVisualization
implements VisFactory {
    private static final String NAME = "Uncertain Instance";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation r = p.getRelation();
            if (!UncertainObject.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(r.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p, r).level(100).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String CSS_CLASS = "uncertain-instances";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            StylingPolicy spol = this.context.getStylingPolicy();
            double size = style.getSize("plot.marker");
            MarkerLibrary ml = style.markers();
            if (!(spol instanceof ClusterStylingPolicy)) {
                return;
            }
            ClusterStylingPolicy cspol = (ClusterStylingPolicy)spol;
            Clustering<?> c = cspol.getClustering();
            Relation srel = null;
            boolean isChild = false;
            It<Relation> it = this.context.getHierarchy().iterAncestors(c).filter(Relation.class);
            while (it.valid()) {
                Relation r = it.get();
                if (r == this.rel) {
                    isChild = true;
                } else {
                    Relation vr;
                    int dim;
                    SimpleTypeInformation type = r.getDataTypeInformation();
                    if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(type) && (dim = RelationUtil.dimensionality(vr = r)) == RelationUtil.dimensionality(this.rel)) {
                        srel = vr;
                    }
                }
                if (isChild && srel != null) break;
                it.advance();
            }
            if (!isChild || srel == null) {
                return;
            }
            for (int cnum = cspol.getMinStyle(); cnum < cspol.getMaxStyle(); ++cnum) {
                DBIDIter iter = cspol.iterateClass(cnum);
                while (iter.valid()) {
                    if (this.sample.getSample().contains(iter)) {
                        try {
                            NumberVector vec = (NumberVector)srel.get(iter);
                            double[] v = this.proj.fastProjectDataToRenderSpace(vec);
                            if (v[0] == v[0] && v[1] == v[1]) {
                                ml.useMarker(this.svgp, this.layer, v[0], v[1], cnum, size);
                            }
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            // empty catch block
                        }
                    }
                    iter.advance();
                }
            }
        }
    }
}

