/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.Random;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public class UncertainSamplesVisualization
implements VisFactory {
    private static final String NAME = "Uncertain Samples";
    protected int samples = 10;

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> context.getHierarchy().iterAncestorsSelf(p.getRelation()).filter(Relation.class).forEach(r2 -> {
            if (UncertainObject.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(r2.getDataTypeInformation())) {
                context.addVis(p, new VisualizationTask(this, NAME, p, (Relation<?>)r2).level(100).visibility(false).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
            }
        }));
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String CSS_CLASS = "uncertain-sample";
        protected final Relation<? extends UncertainObject> rel;
        protected final RandomFactory random;
        private static final String FILL = "fill:";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.random = RandomFactory.DEFAULT;
            this.addListeners();
            this.rel = task.getRelation();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            StylingPolicy spol = this.context.getStylingPolicy();
            double size = style.getSize("plot.marker");
            double ssize = size / FastMath.sqrt(UncertainSamplesVisualization.this.samples);
            MarkerLibrary ml = style.markers();
            Random rand = this.random.getSingleThreadedRandom();
            if (spol instanceof ClassStylingPolicy) {
                ClassStylingPolicy cspol = (ClassStylingPolicy)spol;
                for (int cnum = cspol.getMinStyle(); cnum < cspol.getMaxStyle(); ++cnum) {
                    DBIDIter iter = cspol.iterateClass(cnum);
                    while (iter.valid()) {
                        if (this.sample.getSample().contains(iter)) {
                            try {
                                UncertainObject uo = this.rel.get(iter);
                                if (uo instanceof DiscreteUncertainObject) {
                                    this.drawDiscete((DiscreteUncertainObject)uo, ml, cnum, size);
                                } else {
                                    this.drawContinuous(uo, ml, cnum, ssize, rand);
                                }
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                                // empty catch block
                            }
                        }
                        iter.advance();
                    }
                }
            } else {
                DBIDIter iter = this.sample.getSample().iter();
                while (iter.valid()) {
                    try {
                        int col = spol.getColorForDBID(iter);
                        UncertainObject uo = this.rel.get(iter);
                        if (uo instanceof DiscreteUncertainObject) {
                            this.drawDiscreteDefault((DiscreteUncertainObject)uo, col, size);
                        } else {
                            this.drawContinuousDefault(uo, col, size, rand);
                        }
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        // empty catch block
                    }
                    iter.advance();
                }
            }
        }

        private void drawDiscete(DiscreteUncertainObject uo, MarkerLibrary ml, int cnum, double size) {
            int e = uo.getNumberSamples();
            double ssize = size * FastMath.sqrt(e);
            for (int i = 0; i < e; ++i) {
                double[] v;
                DoubleVector s = uo.getSample(i);
                if (s == null || (v = this.proj.fastProjectDataToRenderSpace(s))[0] != v[0] || v[1] != v[1]) continue;
                ml.useMarker(this.svgp, this.layer, v[0], v[1], cnum, uo.getWeight(i) * ssize);
            }
        }

        private void drawContinuous(UncertainObject uo, MarkerLibrary ml, int cnum, double size, Random rand) {
            for (int i = 0; i < UncertainSamplesVisualization.this.samples; ++i) {
                double[] v = this.proj.fastProjectDataToRenderSpace(uo.drawSample(rand));
                if (v[0] != v[0] || v[1] != v[1]) continue;
                ml.useMarker(this.svgp, this.layer, v[0], v[1], cnum, size);
            }
        }

        private void drawDiscreteDefault(DiscreteUncertainObject uo, int col, double size) {
            int e = uo.getNumberSamples();
            double ssize = size * FastMath.sqrt(e);
            for (int i = 0; i < e; ++i) {
                DoubleVector s = uo.getSample(i);
                if (s == null) continue;
                double[] v = this.proj.fastProjectDataToRenderSpace(s);
                Element dot = this.svgp.svgCircle(v[0], v[1], ssize * uo.getWeight(i));
                SVGUtil.addCSSClass(dot, CSS_CLASS);
                SVGUtil.setAtt(dot, "style", FILL + SVGUtil.colorToString(col));
                this.layer.appendChild(dot);
            }
        }

        private void drawContinuousDefault(UncertainObject uo, int col, double size, Random rand) {
            for (int i = 0; i < UncertainSamplesVisualization.this.samples; ++i) {
                double[] v = this.proj.fastProjectDataToRenderSpace(uo.drawSample(rand));
                Element dot = this.svgp.svgCircle(v[0], v[1], size);
                SVGUtil.addCSSClass(dot, CSS_CLASS);
                SVGUtil.setAtt(dot, "style", FILL + SVGUtil.colorToString(col));
                this.layer.appendChild(dot);
            }
        }
    }
}

