/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.thumbs;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThumbnailThread
extends Thread {
    private Queue<Task> queue = new ConcurrentLinkedQueue<Task>();
    private boolean shutdown = false;
    private static ThumbnailThread THREAD = null;

    public static synchronized Task queue(Listener callback) {
        Task task = new Task(callback);
        if (THREAD != null && THREAD.isAlive()) {
            ThumbnailThread.THREAD.queue.add(task);
            return task;
        }
        THREAD = new ThumbnailThread();
        ThumbnailThread.THREAD.queue.add(task);
        THREAD.start();
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unqueue(Task task) {
        if (THREAD != null) {
            ThumbnailThread thumbnailThread = THREAD;
            synchronized (thumbnailThread) {
                ThumbnailThread.THREAD.queue.remove(task);
            }
        }
    }

    private void generateThumbnail(Task ti) {
        ti.callback.doThumbnail();
    }

    @Override
    public void run() {
        while (!this.queue.isEmpty() && !this.shutdown) {
            this.generateThumbnail(this.queue.poll());
        }
    }

    public static interface Listener {
        public void doThumbnail();
    }

    public static class Task {
        Listener callback;

        public Task(Listener callback) {
            this.callback = callback;
        }
    }
}

