/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.thumbs;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailRegistryEntry;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.thumbs.ThumbnailThread;
import java.awt.image.BufferedImage;
import org.w3c.dom.Element;

public class ThumbnailVisualization
extends AbstractVisualization
implements ThumbnailThread.Listener,
DataStoreListener,
VisualizationListener {
    protected final VisFactory visFactory;
    protected int thumbid = -1;
    protected ThumbnailThread.Task pendingThumbnail = null;
    protected int tresolution;
    private BufferedImage thumb;
    private SVGPlot plot;
    private Projection proj;

    public ThumbnailVisualization(VisualizerContext context, VisFactory visFactory, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj, int thumbsize) {
        super(context, task, plot, width, height);
        this.visFactory = visFactory;
        this.plot = plot;
        this.proj = proj;
        this.tresolution = thumbsize;
        this.layer = plot.svgElement("g");
        this.thumbid = -1;
        this.thumb = null;
        this.addListeners();
    }

    @Override
    public void destroy() {
        if (this.pendingThumbnail != null) {
            ThumbnailThread.unqueue(this.pendingThumbnail);
        }
        super.destroy();
    }

    @Override
    public Element getLayer() {
        if (this.thumbid < 0) {
            this.svgp.requestRedraw(this.task, this);
        }
        return this.layer;
    }

    @Override
    public void fullRedraw() {
        if (!(this.getWidth() > 0.0) || !(this.getHeight() > 0.0)) {
            LoggingUtil.warning("Thumbnail of zero size requested: " + this.visFactory);
            return;
        }
        if (this.thumbid < 0) {
            this.layer.appendChild(SVGUtil.svgWaitIcon(this.plot.getDocument(), 0.0, 0.0, this.getWidth(), this.getHeight()));
            if (this.pendingThumbnail == null) {
                this.pendingThumbnail = ThumbnailThread.queue(this);
            }
            return;
        }
        Element i = this.plot.svgElement("image");
        SVGUtil.setAtt(i, "x", 0);
        SVGUtil.setAtt(i, "y", 0);
        SVGUtil.setAtt(i, "width", this.getWidth());
        SVGUtil.setAtt(i, "height", this.getHeight());
        i.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "thumb:" + this.thumbid);
        this.layer.appendChild(i);
    }

    @Override
    public synchronized void doThumbnail() {
        this.pendingThumbnail = null;
        try {
            VisualizationPlot plot = new VisualizationPlot();
            plot.getRoot().setAttribute("viewBox", "0 0 " + this.getWidth() + " " + this.getHeight());
            Visualization vis = this.visFactory.makeVisualization(this.context, this.task, plot, this.getWidth(), this.getHeight(), this.proj);
            plot.getRoot().appendChild(vis.getLayer());
            plot.updateStyleElement();
            int tw = (int)(this.getWidth() * (double)this.tresolution);
            int th = (int)(this.getHeight() * (double)this.tresolution);
            this.thumb = plot.makeAWTImage(tw, th);
            this.thumbid = ThumbnailRegistryEntry.registerImage(this.thumb);
            vis.destroy();
            this.svgp.requestRedraw(this.task, this);
        }
        catch (Exception e) {
            Logging logger = Logging.getLogger(this.task.getFactory().getClass());
            if (logger != null && logger.isDebugging()) {
                logger.exception("Thumbnail for " + this.task.getFactory() + " failed.", e);
            }
            LoggingUtil.warning("Thumbnail for " + this.task.getFactory() + " failed - enable debugging to see details.");
        }
    }

    private void refreshThumbnail() {
        this.thumbid = -1;
        this.thumb = null;
        this.svgp.requestRedraw(this.task, this);
    }

    @Override
    public void resultChanged(Result current) {
        if (this.task == current || this.task.getResult() == current) {
            this.refreshThumbnail();
            return;
        }
        if (this.task.has(VisualizationTask.UpdateFlag.ON_SELECTION) && current instanceof SelectionResult) {
            this.refreshThumbnail();
            return;
        }
        if (this.task.has(VisualizationTask.UpdateFlag.ON_SAMPLE) && current instanceof SamplingResult) {
            this.refreshThumbnail();
            return;
        }
    }

    @Override
    public void visualizationChanged(VisualizationItem item) {
        if (this.task == item || this.task.has(VisualizationTask.UpdateFlag.ON_STYLEPOLICY) && item instanceof StylingPolicy) {
            this.refreshThumbnail();
            return;
        }
    }
}

