/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.IntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuAction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AxisVisualization;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public class DendrogramVisualization
implements VisFactory {
    private static final String NAME = "Dendrogram";
    private DrawingStyle style = DrawingStyle.RECTANGULAR;
    private PositionStyle style2 = PositionStyle.HALF_POS;

    public DendrogramVisualization(DrawingStyle style, PositionStyle style2) {
        this.style = style;
        this.style2 = style2;
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(PointerHierarchyRepresentationResult.class).forEach(pi -> {
            VisualizationTask task = new VisualizationTask(this, NAME, pi, null).level(200).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY);
            context.addVis(context.getStylingPolicy(), task);
            context.addVis(pi, new SwitchStyleAction(task, context));
        });
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID STYLE_ID = new OptionID("dendrogram.style", "Drawing style for dendrograms.");
        public static final OptionID LAYOUT_ID = new OptionID("dendrogram.layout", "Positioning logic for dendrograms.");
        private DrawingStyle style = DrawingStyle.RECTANGULAR;
        private PositionStyle style2 = PositionStyle.HALF_POS;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<PositionStyle> style2P;
            super.makeOptions(config);
            EnumParameter<DrawingStyle> styleP = new EnumParameter<DrawingStyle>(STYLE_ID, DrawingStyle.class, DrawingStyle.RECTANGULAR);
            if (config.grab(styleP)) {
                this.style = (DrawingStyle)((Object)styleP.getValue());
            }
            if (config.grab(style2P = new EnumParameter<PositionStyle>(LAYOUT_ID, PositionStyle.class, PositionStyle.HALF_POS))) {
                this.style2 = (PositionStyle)((Object)style2P.getValue());
            }
        }

        @Override
        protected DendrogramVisualization makeInstance() {
            return new DendrogramVisualization(this.style, this.style2);
        }
    }

    private static class HalfWidthPositions
    implements Positions {
        final double[] xxy;
        final int l;
        final int l2;

        private HalfWidthPositions(int size) {
            this.l = size;
            this.l2 = size << 1;
            this.xxy = new double[size * 3];
        }

        @Override
        public void set(int off, double d, double height) {
            double d2 = 0.5 * d;
            this.xxy[off + this.l] = d2;
            this.xxy[off] = d2;
            this.xxy[off + this.l2] = height;
        }

        @Override
        public double getX(int o) {
            return this.xxy[o] + this.xxy[o + this.l];
        }

        @Override
        public double getY(int o) {
            return this.xxy[o + this.l2];
        }

        @Override
        public double combine(int o1, int o2, double y3) {
            double d = y3;
            this.xxy[o2 + this.l2] = d;
            this.xxy[o1 + this.l2] = d;
            this.xxy[o1] = this.xxy[o2] = Math.min(this.xxy[o1], this.xxy[o2]);
            double d2 = Math.max(this.xxy[o1 + this.l], this.xxy[o2 + this.l]);
            this.xxy[o2 + this.l] = d2;
            this.xxy[o1 + this.l] = d2;
            return this.xxy[o2] + d2;
        }
    }

    private static class HalfPosPositions
    implements Positions {
        final double[] xy;
        final int l;

        private HalfPosPositions(int size) {
            this.l = size;
            this.xy = new double[size << 1];
        }

        @Override
        public void set(int off, double d, double height) {
            this.xy[off] = d;
            this.xy[off + this.l] = height;
        }

        @Override
        public double getX(int o) {
            return this.xy[o];
        }

        @Override
        public double getY(int o) {
            return this.xy[o + this.l];
        }

        @Override
        public double combine(int o1, int o2, double y3) {
            double d = y3;
            this.xy[o2 + this.l] = d;
            this.xy[o1 + this.l] = d;
            this.xy[o1] = this.xy[o2] = 0.5 * (this.xy[o1] + this.xy[o2]);
            return this.xy[o2];
        }
    }

    private static interface Positions {
        public void set(int var1, double var2, double var4);

        public double getX(int var1);

        public double getY(int var1);

        public double combine(int var1, int var2, double var3);
    }

    public class Instance
    extends AbstractVisualization {
        private static final String KEY_CAPTION = "key-caption";
        private static final String KEY_HIERLINE = "key-hierarchy";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height) {
            super(context, task, plot, width, height);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.layer = this.svgp.svgElement("g");
            StyleLibrary style = this.context.getStyleLibrary();
            StylingPolicy spol = this.context.getStylingPolicy();
            PointerHierarchyRepresentationResult p = (PointerHierarchyRepresentationResult)this.task.getResult();
            boolean squared = p.isSquared();
            DBIDs ids = p.getDBIDs();
            DBIDDataStore par = p.getParentStore();
            DoubleDataStore pdi = p.getParentDistanceStore();
            IntegerDataStore pos = p.getPositions();
            DBIDVar pa = DBIDUtil.newVar();
            int size = ids.size();
            double linew = 10.0 / FastMath.log1p(size);
            double width = 100.0;
            double height = width / this.getWidth() * this.getHeight();
            double xscale = width / (double)size;
            double xoff = xscale * 0.5;
            double maxh = Double.MIN_NORMAL;
            DBIDIter it = ids.iter();
            while (it.valid()) {
                double v;
                if (!DBIDUtil.equal(it, par.assignVar(it, pa)) && (v = pdi.doubleValue(it)) != Double.POSITIVE_INFINITY) {
                    maxh = v > maxh ? v : maxh;
                }
                it.advance();
            }
            LinearScale yscale = new LinearScale(0.0, squared ? FastMath.sqrt(maxh) : maxh);
            Double2DoubleFunction proy = squared ? h -> height * (1.0 - yscale.getScaled(FastMath.sqrt(h))) : h -> height * (1.0 - yscale.getScaled(h));
            try {
                SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, yscale, 0.0, height, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, style);
                double lxoff = style.getTextSize("axis.label") * -3.5;
                Element label = this.svgp.svgText(lxoff, 0.5 * height, squared ? "sqrt(distance)" : "distance");
                CSSClass alcls = new CSSClass(AxisVisualization.class, "unmanaged");
                alcls.setStatement("font-size", SVGUtil.fmt(1.1 * style.getTextSize("axis.label")));
                alcls.setStatement("fill", style.getTextColor("axis.label"));
                alcls.setStatement("font-family", style.getFontFamily("axis.label"));
                SVGUtil.setAtt(label, "style", alcls.inlineCSS());
                SVGUtil.setAtt(label, "text-anchor", "middle");
                SVGUtil.setAtt(label, "transform", "rotate(-90," + lxoff + "," + 0.5 * height + ")");
                this.layer.appendChild(label);
            }
            catch (CSSClassManager.CSSNamingConflict e) {
                LoggingUtil.exception(e);
            }
            Positions coord = DendrogramVisualization.this.style2 == PositionStyle.HALF_POS ? new HalfPosPositions(size) : new HalfWidthPositions(size);
            DBIDIter it2 = ids.iter();
            while (it2.valid()) {
                int off = pos.intValue(it2);
                coord.set(off, (double)off * xscale + xoff, height);
                it2.advance();
            }
            ArrayModifiableDBIDs order = DBIDUtil.newArray(ids);
            order.sort(new DataStoreUtil.AscendingByDoubleDataStoreAndId(pdi));
            if (spol instanceof ClassStylingPolicy) {
                ClassStylingPolicy cspol = (ClassStylingPolicy)spol;
                this.setupCSS(this.svgp, cspol, linew);
                int mins = cspol.getMinStyle() - 1;
                int maxs = cspol.getMaxStyle();
                SVGPath[] paths = new SVGPath[maxs - mins + 1];
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = new SVGPath();
                }
                DBIDArrayMIter it3 = order.iter();
                while (it3.valid()) {
                    par.assignVar(it3, pa);
                    double h2 = pdi.doubleValue(it3);
                    int o1 = pos.intValue(it3);
                    int p1 = cspol.getStyleForDBID(it3);
                    double x1 = coord.getX(o1);
                    double y1 = coord.getY(o1);
                    if (DBIDUtil.equal(it3, pa)) {
                        double y = proy.applyAsDouble(h2);
                        if (Double.isFinite(y)) {
                            paths[p1 - mins + 1].moveTo(x1, y1).verticalLineTo(y);
                        }
                    } else {
                        int o2 = pos.intValue(pa);
                        int p2 = cspol.getStyleForDBID(pa);
                        double x2 = coord.getX(o2);
                        double y2 = coord.getY(o2);
                        double y3 = proy.applyAsDouble(h2);
                        double x3 = coord.combine(o1, o2, y3);
                        if (!(Double.isFinite(x1) && Double.isFinite(y1) && Double.isFinite(x2) && Double.isFinite(y2) && Double.isFinite(x3) && Double.isFinite(y3))) {
                            LoggingUtil.warning("Infinite or NaN values in dendrogram.");
                        } else {
                            switch (DendrogramVisualization.this.style) {
                                case RECTANGULAR: {
                                    if (p1 == p2) {
                                        paths[p1 - mins + 1].moveTo(x1, y1).verticalLineTo(y3).horizontalLineTo(x2).verticalLineTo(y2);
                                        break;
                                    }
                                    paths[y1 == height ? p1 - mins + 1 : 0].moveTo(x1, y1).verticalLineTo(y3);
                                    paths[y2 == height ? p2 - mins + 1 : 0].moveTo(x2, y2).verticalLineTo(y3);
                                    paths[0].moveTo(x1, y3).horizontalLineTo(x2);
                                    break;
                                }
                                case TRIANGULAR_MAX: {
                                    double miny = Math.min(y1, y2);
                                    if (p1 == p2) {
                                        paths[p1 - mins + 1].moveTo(x1, y1).verticalLineTo(miny).drawTo(x3, y3).drawTo(x2, miny).verticalLineTo(y2);
                                        break;
                                    }
                                    paths[y1 == height ? p1 - mins + 1 : 0].moveTo(x1, y1).verticalLineTo(miny).drawTo(x3, y3);
                                    paths[y2 == height ? p2 - mins + 1 : 0].moveTo(x2, y2).verticalLineTo(miny).drawTo(x3, y3);
                                    break;
                                }
                                case TRIANGULAR: {
                                    if (p1 == p2) {
                                        paths[p1 - mins + 1].moveTo(x1, y1).drawTo(x3, y3).drawTo(x2, y2);
                                        break;
                                    }
                                    paths[y1 == height ? p1 - mins + 1 : 0].moveTo(x1, y1).drawTo(x3, y3);
                                    paths[y2 == height ? p2 - mins + 1 : 0].moveTo(x2, y2).drawTo(x3, y3);
                                }
                            }
                        }
                    }
                    it3.advance();
                }
                for (int i = 0; i < paths.length; ++i) {
                    SVGPath path = paths[i];
                    if (!path.isStarted()) continue;
                    this.layer.appendChild(path.makeElement(this.svgp, i > 0 ? "key-hierarchy_" + (i + mins - 1) : KEY_HIERLINE));
                }
            } else {
                this.setupCSS(this.svgp, linew);
                SVGPath dendrogram = new SVGPath();
                DBIDArrayMIter it4 = order.iter();
                while (it4.valid()) {
                    double h3 = pdi.doubleValue(it4);
                    int o1 = pos.intValue(it4);
                    double x1 = coord.getX(o1);
                    double y1 = coord.getY(o1);
                    if (DBIDUtil.equal(it4, par.assignVar(it4, pa))) {
                        double y = proy.applyAsDouble(h3);
                        if (Double.isFinite(y)) {
                            dendrogram.moveTo(x1, y1).verticalLineTo(y);
                        }
                    } else {
                        int o2 = pos.intValue(pa);
                        double x2 = coord.getX(o2);
                        double y2 = coord.getY(o2);
                        double y3 = proy.applyAsDouble(h3);
                        double x3 = coord.combine(o1, o2, y3);
                        switch (DendrogramVisualization.this.style) {
                            case RECTANGULAR: {
                                dendrogram.moveTo(x1, y1).verticalLineTo(y3).horizontalLineTo(x2).verticalLineTo(y2);
                                break;
                            }
                            case TRIANGULAR_MAX: {
                                double miny = Math.min(y1, y2);
                                dendrogram.moveTo(x1, y1).verticalLineTo(miny).drawTo(x3, y3).drawTo(x2, miny).verticalLineTo(y2);
                                break;
                            }
                            case TRIANGULAR: {
                                dendrogram.moveTo(x1, y1).drawTo(x3, y3).drawTo(x2, y2);
                            }
                        }
                    }
                    it4.advance();
                }
                this.layer.appendChild(dendrogram.makeElement(this.svgp, KEY_HIERLINE));
            }
            double margin = style.getSize("margin");
            String transform = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), width, height, 2.0 * margin, margin, margin, margin);
            SVGUtil.setAtt(this.layer, "transform", transform);
        }

        protected void setupCSS(SVGPlot svgp, double linew) {
            StyleLibrary style = this.context.getStyleLibrary();
            double fontsize = style.getTextSize("key");
            String fontfamily = style.getFontFamily("key");
            String color = style.getColor("key");
            CSSClass keycaption = new CSSClass(svgp, KEY_CAPTION);
            keycaption.setStatement("font-size", fontsize);
            keycaption.setStatement("font-family", fontfamily);
            keycaption.setStatement("fill", color);
            keycaption.setStatement("font-weight", "bold");
            svgp.addCSSClassOrLogError(keycaption);
            CSSClass hierline = new CSSClass(svgp, KEY_HIERLINE);
            hierline.setStatement("stroke", color);
            hierline.setStatement("stroke-width", linew * style.getLineWidth("key.hierarchy") / 100.0);
            hierline.setStatement("stroke-linecap", "round");
            hierline.setStatement("fill", "none");
            svgp.addCSSClassOrLogError(hierline);
            svgp.updateStyleElement();
        }

        protected void setupCSS(SVGPlot svgp, ClassStylingPolicy cspol, double linew) {
            this.setupCSS(svgp, linew);
            StyleLibrary style = this.context.getStyleLibrary();
            ColorLibrary colors = style.getColorSet("plot");
            for (int i = cspol.getMinStyle(); i <= cspol.getMaxStyle(); ++i) {
                CSSClass hierline = new CSSClass(svgp, "key-hierarchy_" + i);
                hierline.setStatement("stroke", colors.getColor(i));
                hierline.setStatement("stroke-width", linew * style.getLineWidth("key.hierarchy") / 100.0);
                hierline.setStatement("stroke-linecap", "round");
                hierline.setStatement("fill", "none");
                svgp.addCSSClassOrLogError(hierline);
            }
            svgp.updateStyleElement();
        }
    }

    public class SwitchStyleAction
    implements VisualizationMenuAction {
        private VisualizationTask task;
        private VisualizerContext context;

        public SwitchStyleAction(VisualizationTask task, VisualizerContext context) {
            this.task = task;
            this.context = context;
        }

        @Override
        public String getMenuName() {
            return "Switch Dendrogram Style";
        }

        @Override
        public void activate() {
            switch (DendrogramVisualization.this.style) {
                case RECTANGULAR: {
                    DendrogramVisualization.this.style = DrawingStyle.TRIANGULAR_MAX;
                    break;
                }
                case TRIANGULAR_MAX: {
                    DendrogramVisualization.this.style = DrawingStyle.TRIANGULAR;
                    break;
                }
                case TRIANGULAR: {
                    DendrogramVisualization.this.style = DrawingStyle.RECTANGULAR;
                    DendrogramVisualization.this.style2 = DendrogramVisualization.this.style2 == PositionStyle.HALF_POS ? PositionStyle.HALF_WIDTH : PositionStyle.HALF_POS;
                }
            }
            this.context.visChanged(this.task);
        }
    }

    public static enum PositionStyle {
        HALF_POS,
        HALF_WIDTH;

    }

    public static enum DrawingStyle {
        RECTANGULAR,
        TRIANGULAR_MAX,
        TRIANGULAR;

    }
}

