/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGScoreBar;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.util.Iterator;
import org.w3c.dom.Element;

public class EvaluationVisualization
implements VisFactory {
    private static final String NAME = "Evaluation Bar Chart";
    private static final double BARLENGTH = 5.0;
    private static final double BARHEIGHT = 0.7;

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(EvaluationResult.class).forEach(sr -> {
            It<VisualizationTask> it2 = VisualizationTree.findVis(context, sr).filter(VisualizationTask.class);
            while (it2.valid()) {
                if (it2.get().getFactory() instanceof EvaluationVisualization) {
                    return;
                }
                it2.advance();
            }
            if (sr.visualizeSingleton()) {
                Class<?> c = sr.getClass();
                It<VisualizationTask> it3 = context.getVisHierarchy().iterChildren(context.getBaseResult()).filter(VisualizationTask.class);
                while (it3.valid()) {
                    VisualizationTask otask = it3.get();
                    if (otask.getFactory() instanceof EvaluationVisualization && otask.getResult() == c) {
                        return;
                    }
                    it3.advance();
                }
                context.addVis(context.getBaseResult(), new VisualizationTask(this, NAME, c, null).requestSize(0.5, (double)sr.numLines() * 0.05).level(200).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
                return;
            }
            context.addVis(sr, new VisualizationTask(this, NAME, sr, null).requestSize(0.5, (double)sr.numLines() * 0.05).level(200));
        });
    }

    private double addBarChart(SVGPlot svgp, Element parent, double ypos, String label, double value, double minValue, double maxValue, double baseValue, boolean reversed) {
        SVGScoreBar barchart = new SVGScoreBar();
        barchart.setFill(value, baseValue == baseValue ? baseValue : minValue, maxValue);
        barchart.setReversed(reversed);
        barchart.showValues(FormatUtil.NF4);
        barchart.addLabel(label);
        parent.appendChild(barchart.build(svgp, 0.0, ypos, 5.0, 0.7));
        return ypos += 1.0;
    }

    private double addHeader(SVGPlot svgp, Element parent, double ypos, String text) {
        Element object = svgp.svgText(0.0, (ypos += 0.5) + 0.35, text);
        object.setAttribute("style", "font-size: 0.6; font-weight: bold");
        parent.appendChild(object);
        return ypos += 1.0;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        Iterator<EvaluationResult.MeasurementGroup> spol;
        double ypos = -0.5;
        Element parent = plot.svgElement("g");
        Object o = task.getResult();
        EvaluationResult sr = null;
        if (o instanceof EvaluationResult) {
            sr = (EvaluationResult)o;
        } else if (o instanceof Class && EvaluationResult.class.isAssignableFrom((Class)o) && (spol = context.getStylingPolicy()) instanceof ClusterStylingPolicy) {
            ClusterStylingPolicy cpol = (ClusterStylingPolicy)((Object)spol);
            Class c = (Class)o;
            It it = VisualizationTree.findNewResults(context, cpol.getClustering()).filter(c);
            while (it.valid()) {
                if (context.getHierarchy().iterAncestors(it.get()).find(cpol.getClustering())) {
                    sr = (EvaluationResult)it.get();
                    break;
                }
                it.advance();
            }
        }
        if (sr == null) {
            return new StaticVisualizationInstance(context, task, plot, width, height, parent);
        }
        for (String header : sr.getHeaderLines()) {
            ypos = this.addHeader(plot, parent, ypos, header);
        }
        for (EvaluationResult.MeasurementGroup g : sr) {
            ypos = this.addHeader(plot, parent, ypos, g.getName());
            for (EvaluationResult.Measurement m : g) {
                ypos = this.addBarChart(plot, parent, ypos, m.getName(), m.getVal(), m.getMin(), m.getMax(), m.getExp(), m.lowerIsBetter());
            }
        }
        double cols = 10.0;
        StyleLibrary style = context.getStyleLibrary();
        double margin = style.getSize("margin");
        String transform = SVGUtil.makeMarginTransform(width, height, cols, ypos, margin / 100.0);
        SVGUtil.setAtt(parent, "transform", transform);
        return new StaticVisualizationInstance(context, task, plot, width, height, parent);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }
}

