/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;

public class HistogramVisualization
implements VisFactory {
    private static final String NAME = "Histogram";
    private static final String SERIESID = "series";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        HistogramResult curve = (HistogramResult)task.getResult();
        StyleLibrary style = context.getStyleLibrary();
        double sizex = 100.0;
        double sizey = 100.0 * height / width;
        double margin = style.getSize("margin");
        Element layer = SVGUtil.svgElement(plot.getDocument(), "g");
        String transform = SVGUtil.makeMarginTransform(width, height, 100.0, sizey, margin);
        SVGUtil.setAtt(layer, "transform", transform);
        int dim = -1;
        DoubleMinMax xminmax = new DoubleMinMax();
        DoubleMinMax yminmax = new DoubleMinMax();
        for (double[] point : curve) {
            xminmax.put(point[0]);
            dim = dim < point.length ? point.length : dim;
            for (int i = 1; i < point.length; ++i) {
                yminmax.put(point[i]);
            }
        }
        yminmax.put(0.0);
        --dim;
        int size = curve.size();
        double range = xminmax.getMax() - xminmax.getMin();
        double binwidth = range / (double)(size - 1);
        LinearScale xscale = new LinearScale(xminmax.getMin() - binwidth * 0.49999, xminmax.getMax() + binwidth * 0.49999);
        LinearScale yscale = new LinearScale(yminmax.getMin(), yminmax.getMax());
        SVGPath[] path = new SVGPath[dim];
        for (int i = 0; i < dim; ++i) {
            path[i] = new SVGPath(100.0 * xscale.getScaled(xminmax.getMin() - binwidth * 0.5), sizey);
        }
        for (double[] point : curve) {
            for (int d = 0; d < dim; ++d) {
                path[d].lineTo(100.0 * xscale.getScaled(point[0] - binwidth * 0.5), sizey * (1.0 - yscale.getScaled(point[d + 1])));
                path[d].lineTo(100.0 * xscale.getScaled(point[0] + binwidth * 0.5), sizey * (1.0 - yscale.getScaled(point[d + 1])));
            }
        }
        for (int i = 0; i < dim; ++i) {
            path[i].lineTo(100.0 * xscale.getScaled(xminmax.getMax() + binwidth * 0.5), sizey);
        }
        try {
            SVGSimpleLinearAxis.drawAxis(plot, layer, yscale, 0.0, sizey, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, style);
            SVGSimpleLinearAxis.drawAxis(plot, layer, xscale, 0.0, sizey, 100.0, sizey, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, style);
        }
        catch (CSSClassManager.CSSNamingConflict e) {
            LoggingUtil.exception(e);
        }
        ColorLibrary cl = style.getColorSet("plot");
        for (int d = 0; d < dim; ++d) {
            CSSClass csscls = new CSSClass(this, "series_" + d);
            csscls.setStatement("fill", "none");
            csscls.setStatement("stroke", cl.getColor(d));
            csscls.setStatement("stroke-width", style.getLineWidth("plot"));
            plot.addCSSClassOrLogError(csscls);
            layer.appendChild(path[d].makeElement(plot, csscls.getName()));
        }
        return new StaticVisualizationInstance(context, task, plot, width, height, layer);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(HistogramResult.class).forEach(histogram -> context.addVis(histogram, new VisualizationTask(this, NAME, histogram, null).requestSize(2.0, 1.0).level(200)));
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }
}

