/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleDoublePair;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public class KeyVisualization
implements VisFactory {
    private static final String NAME = "Cluster Key";

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        if (!VisualizationTree.findNewResults(context, start).filter(Clustering.class).valid()) {
            return;
        }
        It<VisualizationTask> i2 = VisualizationTree.findVis(context).filter(VisualizationTask.class);
        while (i2.valid()) {
            if (i2.get().getFactory() instanceof KeyVisualization) {
                return;
            }
            i2.advance();
        }
        context.addVis(context.getStylingPolicy(), new VisualizationTask(this, NAME, context.getStylingPolicy(), null).level(200).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
    }

    protected static <M extends Model> int[] findDepth(Clustering<M> c) {
        Hierarchy<Cluster<M>> hier = c.getClusterHierarchy();
        int[] size = new int[]{0, 0};
        It<Cluster<M>> iter = c.iterToplevelClusters();
        while (iter.valid()) {
            KeyVisualization.findDepth(hier, iter.get(), size);
            iter.advance();
        }
        return size;
    }

    private static <M extends Model> void findDepth(Hierarchy<Cluster<M>> hier, Cluster<M> cluster, int[] size) {
        if (hier.numChildren(cluster) > 0) {
            It<Cluster<M>> iter = hier.iterChildren(cluster);
            while (iter.valid()) {
                KeyVisualization.findDepth(hier, iter.get(), size);
                iter.advance();
            }
            size[0] = size[0] + 1;
        } else {
            size[1] = size[1] + 1;
        }
    }

    protected static int getPreferredColumns(double width, double height, int numc, double maxwidth) {
        double rows = Math.ceil(FastMath.pow((double)numc * maxwidth, height / (width + height)));
        return (int)Math.ceil((double)numc / (rows + 1.0));
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractVisualization {
        private static final String KEY_CAPTION = "key-caption";
        private static final String KEY_ENTRY = "key-entry";
        private static final String KEY_HIERLINE = "key-hierarchy";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height) {
            super(context, task, plot, width, height);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            double khe;
            double kwi;
            StyleLibrary style = this.context.getStyleLibrary();
            this.setupCSS(this.svgp);
            this.layer = this.svgp.svgElement("g");
            StylingPolicy pol = this.context.getStylingPolicy();
            if (!(pol instanceof ClusterStylingPolicy)) {
                Element label = this.svgp.svgText(0.1, 0.7, "No clustering selected.");
                SVGUtil.setCSSClass(label, KEY_CAPTION);
                this.layer.appendChild(label);
                double margin = style.getSize("margin");
                String transform = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), 10.0, 1.0, margin / 100.0);
                SVGUtil.setAtt(this.layer, "transform", transform);
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)pol).getClustering();
            MarkerLibrary ml = style.markers();
            List<Cluster<?>> allcs = clustering.getAllClusters();
            List<Cluster<?>> topcs = clustering.getToplevelClusters();
            Element label = this.svgp.svgText(0.1, 0.7, clustering.getLongName());
            SVGUtil.setCSSClass(label, KEY_CAPTION);
            this.layer.appendChild(label);
            if (allcs.size() == topcs.size()) {
                double maxwidth = 10.0;
                int numc = allcs.size();
                int cols = KeyVisualization.getPreferredColumns(this.getWidth(), this.getHeight(), numc, 10.0);
                int rows = (int)Math.ceil((double)numc / (double)cols);
                int i = 0;
                for (Cluster<?> c : allcs) {
                    int col = i / rows;
                    int row = i % rows;
                    ml.useMarker(this.svgp, this.layer, 0.3 + 10.0 * (double)col, (double)row + 1.5, i, 0.5);
                    Element label2 = this.svgp.svgText(0.7 + 10.0 * (double)col, (double)row + 1.7, c.getNameAutomatic());
                    SVGUtil.setCSSClass(label2, KEY_ENTRY);
                    this.layer.appendChild(label2);
                    ++i;
                }
                kwi = (double)cols * 10.0;
                khe = rows;
            } else {
                Object2IntOpenHashMap<Cluster<Model>> cnum = new Object2IntOpenHashMap<Cluster<Model>>(allcs.size());
                int i = 0;
                for (Cluster<?> c : allcs) {
                    cnum.put((Cluster<Model>)c, i);
                    ++i;
                }
                DoubleDoublePair size = new DoubleDoublePair(0.0, 1.0);
                DoubleDoublePair pos = new DoubleDoublePair(0.0, 1.0);
                Hierarchy<Cluster<Model>> hier = clustering.getClusterHierarchy();
                for (Cluster<Model> cluster : topcs) {
                    this.drawHierarchy(this.svgp, ml, size, pos, 0, cluster, cnum, hier);
                }
                kwi = size.first;
                khe = size.second;
            }
            double margin = style.getSize("margin");
            String transform = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), kwi, khe, margin / 100.0);
            SVGUtil.setAtt(this.layer, "transform", transform);
        }

        private double drawHierarchy(SVGPlot svgp, MarkerLibrary ml, DoubleDoublePair size, DoubleDoublePair pos, int depth, Cluster<Model> cluster, Object2IntOpenHashMap<Cluster<Model>> cnum, Hierarchy<Cluster<Model>> hier) {
            double posy;
            double maxwidth = 8.0;
            DoubleDoublePair subpos = new DoubleDoublePair(pos.first + 8.0, pos.second);
            int numc = hier.numChildren(cluster);
            if (numc > 0) {
                double[] mids = new double[numc];
                It<Cluster<Model>> iter = hier.iterChildren(cluster);
                int i = 0;
                while (iter.valid()) {
                    mids[i] = this.drawHierarchy(svgp, ml, size, subpos, depth, iter.get(), cnum, hier);
                    iter.advance();
                    ++i;
                }
                posy = (pos.second + subpos.second) * 0.5;
                for (i = 0; i < numc; ++i) {
                    Element line = svgp.svgLine(pos.first + 8.0 - 1.0, posy + 0.5, pos.first + 8.0, mids[i] + 0.5);
                    SVGUtil.setCSSClass(line, KEY_HIERLINE);
                    this.layer.appendChild(line);
                }
                pos.second = subpos.second;
            } else {
                posy = pos.second + 0.5;
                pos.second += 1.0;
            }
            ml.useMarker(svgp, this.layer, 0.3 + pos.first, posy + 0.5, cnum.getInt(cluster), 0.3);
            Element label = svgp.svgText(0.7 + pos.first, posy + 0.7, cluster.getNameAutomatic());
            SVGUtil.setCSSClass(label, KEY_ENTRY);
            this.layer.appendChild(label);
            size.first = Math.max(size.first, pos.first + 8.0);
            size.second = Math.max(size.second, pos.second);
            return posy;
        }

        protected void setupCSS(SVGPlot svgp) {
            StyleLibrary style = this.context.getStyleLibrary();
            double fontsize = style.getTextSize("key");
            String fontfamily = style.getFontFamily("key");
            String color = style.getColor("key");
            CSSClass keycaption = new CSSClass(svgp, KEY_CAPTION);
            keycaption.setStatement("font-size", fontsize);
            keycaption.setStatement("font-family", fontfamily);
            keycaption.setStatement("fill", color);
            keycaption.setStatement("font-weight", "bold");
            svgp.addCSSClassOrLogError(keycaption);
            CSSClass keyentry = new CSSClass(svgp, KEY_ENTRY);
            keyentry.setStatement("font-size", fontsize);
            keyentry.setStatement("font-family", fontfamily);
            keyentry.setStatement("fill", color);
            svgp.addCSSClassOrLogError(keyentry);
            CSSClass hierline = new CSSClass(svgp, KEY_HIERLINE);
            hierline.setStatement("stroke", color);
            hierline.setStatement("stroke-width", style.getLineWidth("key.hierarchy") / 100.0);
            svgp.addCSSClassOrLogError(hierline);
            svgp.updateStyleElement();
        }
    }
}

