/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;

public class LabelVisualization
implements VisFactory {
    private String label = "undefined";
    private boolean rotated = false;

    public LabelVisualization() {
    }

    public LabelVisualization(String label) {
        this(label, false);
    }

    public LabelVisualization(String label, boolean rotated) {
        this.label = label;
        this.rotated = rotated;
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        Element layer;
        CSSClass cls = new CSSClass(plot, "unmanaged");
        StyleLibrary style = context.getStyleLibrary();
        double fontsize = style.getTextSize("overview.labels") / 100.0;
        cls.setStatement("font-size", SVGUtil.fmt(fontsize));
        cls.setStatement("fill", style.getTextColor("overview.labels"));
        cls.setStatement("font-family", style.getFontFamily("overview.labels"));
        if (!this.rotated) {
            layer = plot.svgText(width * 0.5, height * 0.5 + 0.35 * fontsize, this.label);
            SVGUtil.setAtt(layer, "style", cls.inlineCSS());
            SVGUtil.setAtt(layer, "text-anchor", "middle");
        } else {
            layer = plot.svgText(height * -0.5, width * 0.5 + 0.35 * fontsize, this.label);
            SVGUtil.setAtt(layer, "style", cls.inlineCSS());
            SVGUtil.setAtt(layer, "text-anchor", "middle");
            SVGUtil.setAtt(layer, "transform", "rotate(-90)");
        }
        return new StaticVisualizationInstance(context, task, plot, width, height, layer);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }
}

