/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.result.PixmapResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.awt.image.RenderedImage;
import org.w3c.dom.Element;

public class PixmapVisualizer
implements VisFactory {
    private static final String NAME = "Pixmap Visualizer";

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(PixmapResult.class).forEach(pr -> {
            VisualizationTask task = new VisualizationTask(this, NAME, pr, null).requestSize((double)pr.getImage().getWidth() / (double)pr.getImage().getHeight(), 1.0).level(200);
            context.addVis(pr, task);
        });
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractVisualization {
        private PixmapResult result;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height) {
            super(context, task, plot, width, height);
            this.result = (PixmapResult)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            double scale = 100.0;
            double sizex = 100.0;
            double sizey = 100.0 * this.getHeight() / this.getWidth();
            double margin = 0.0;
            this.layer = SVGUtil.svgElement(this.svgp.getDocument(), "g");
            String transform = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), 100.0, sizey, 0.0);
            SVGUtil.setAtt(this.layer, "transform", transform);
            RenderedImage img = this.result.getImage();
            double iratio = img.getHeight() / img.getWidth();
            double tratio = this.getHeight() / this.getWidth();
            double zoom = iratio >= tratio ? Math.min(tratio / iratio, 1.0) : Math.max(iratio / tratio, 1.0);
            Element itag = this.svgp.svgElement("image");
            SVGUtil.setAtt(itag, "image-rendering", "optimizeSpeed");
            SVGUtil.setAtt(itag, "x", 0);
            SVGUtil.setAtt(itag, "y", 0);
            SVGUtil.setAtt(itag, "width", 100.0 * zoom * iratio);
            SVGUtil.setAtt(itag, "height", 100.0 * zoom);
            itag.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", this.result.getAsFile().toURI().toString());
            this.layer.appendChild(itag);
        }
    }
}

