/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.result.SettingsResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.util.Collection;
import org.w3c.dom.Element;

public class SettingsVisualization
implements VisFactory {
    private static final String NAME = "Settings";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        SettingsResult sr = (SettingsResult)task.getResult();
        Collection<TrackedParameter> settings = sr.getSettings();
        Element layer = plot.svgElement("g");
        int i = 0;
        Object last = null;
        for (TrackedParameter setting : settings) {
            String name;
            if (setting.getOwner() != last && setting.getOwner() != null) {
                try {
                    name = setting.getOwner() instanceof Class ? ((Class)setting.getOwner()).getName() : setting.getOwner().getClass().getName();
                    if (ClassParameter.class.isInstance(setting.getOwner())) {
                        name = ((Class)((ClassParameter)setting.getOwner()).getValue()).getName();
                    }
                }
                catch (NullPointerException e) {
                    name = "[null]";
                }
                Element object = plot.svgText(0.0, (double)i + 0.7, name);
                object.setAttribute("style", "font-size: 0.6; font-weight: bold");
                layer.appendChild(object);
                ++i;
                last = setting.getOwner();
            }
            name = setting.getParameter().getOptionID().getName();
            String value = "[unset]";
            try {
                if (setting.getParameter().isDefined()) {
                    value = setting.getParameter().getValueAsString();
                }
            }
            catch (NullPointerException e) {
                value = "[null]";
            }
            Element label = plot.svgText(0.0, (double)i + 0.7, name);
            label.setAttribute("style", "font-size: 0.6");
            layer.appendChild(label);
            Element vale = plot.svgText(7.5, (double)i + 0.7, value);
            vale.setAttribute("style", "font-size: 0.6");
            layer.appendChild(vale);
            ++i;
        }
        int cols = Math.max(30, (int)((double)i * height / width));
        int rows = i;
        double margin = context.getStyleLibrary().getSize("margin");
        String transform = SVGUtil.makeMarginTransform(width, height, cols, rows, margin / 100.0);
        SVGUtil.setAtt(layer, "transform", transform);
        return new StaticVisualizationInstance(context, task, plot, width, height, layer);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(SettingsResult.class).forEach(sr -> context.addVis(sr, new VisualizationTask(this, NAME, sr, null).level(200).visibility(false)));
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }
}

