/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.evaluation.similaritymatrix.ComputeSimilarityMatrixImage;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.awt.image.RenderedImage;
import org.w3c.dom.Element;

public class SimilarityMatrixVisualizer
implements VisFactory {
    private static final String NAME = "Similarity Matrix Visualizer";

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(ComputeSimilarityMatrixImage.SimilarityMatrix.class).forEach(pr -> context.addVis(pr, new VisualizationTask(this, NAME, pr, null).level(200)));
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractVisualization {
        private ComputeSimilarityMatrixImage.SimilarityMatrix result;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height) {
            super(context, task, plot, width, height);
            this.result = (ComputeSimilarityMatrixImage.SimilarityMatrix)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            StyleLibrary style = this.context.getStyleLibrary();
            double sizex = 100.0;
            double sizey = 100.0 * this.getHeight() / this.getWidth();
            double margin = style.getSize("margin");
            this.layer = SVGUtil.svgElement(this.svgp.getDocument(), "g");
            String transform = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), 100.0, sizey, margin);
            SVGUtil.setAtt(this.layer, "transform", transform);
            RenderedImage img = this.result.getImage();
            double iratio = img.getHeight() / img.getWidth();
            double tratio = this.getHeight() / this.getWidth();
            double zoom = iratio >= tratio ? Math.min(tratio / iratio, 1.0) : Math.max(iratio / tratio, 1.0);
            Element itag = this.svgp.svgElement("image");
            SVGUtil.setAtt(itag, "image-rendering", "optimizeSpeed");
            SVGUtil.setAtt(itag, "x", margin * 0.75);
            SVGUtil.setAtt(itag, "y", margin * 0.75);
            SVGUtil.setAtt(itag, "width", 100.0 * zoom * iratio);
            SVGUtil.setAtt(itag, "height", 100.0 * zoom);
            itag.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", this.result.getAsFile().toURI().toString());
            this.layer.appendChild(itag);
            int size = this.result.getIDs().size();
            double hlsize = 100.0 * zoom * iratio / (double)size;
            double vlsize = 100.0 * zoom / (double)size;
            int i = 0;
            Database database = ResultUtil.findDatabase(this.context.getHierarchy());
            Relation<String> lrep = DatabaseUtil.guessObjectLabelRepresentation(database);
            DBIDArrayIter id = this.result.getIDs().iter();
            while (id.valid()) {
                String label = lrep.get(id);
                if (label != null) {
                    double hlx = margin * 0.75 + hlsize * ((double)i + 0.8);
                    double hly = margin * 0.7;
                    Element lbl = this.svgp.svgText(hlx, hly, label);
                    SVGUtil.setAtt(lbl, "transform", "rotate(-90," + hlx + "," + hly + ")");
                    SVGUtil.setAtt(lbl, "style", "font-size: " + hlsize * 0.8);
                    this.layer.appendChild(lbl);
                    Element lbl2 = this.svgp.svgText(margin * 0.7, margin * 0.75 + vlsize * ((double)i + 0.8), label);
                    SVGUtil.setAtt(lbl2, "text-anchor", "end");
                    SVGUtil.setAtt(lbl2, "style", "font-size: " + vlsize * 0.8);
                    this.layer.appendChild(lbl2);
                }
                ++i;
                id.advance();
            }
        }
    }
}

