/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierPrecisionRecallCurve;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierROCCurve;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;

public class XYCurveVisualization
implements VisFactory {
    private static final String NAME = "XYCurve";
    private static final String SERIESID = "series";
    private static final String CSS_AXIS_LABEL = "xy-axis-label";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        Element auclbl;
        XYCurve curve = (XYCurve)task.getResult();
        this.setupCSS(context, plot);
        StyleLibrary style = context.getStyleLibrary();
        double sizex = 100.0;
        double sizey = 100.0 * height / width;
        double margin = style.getSize("margin");
        Element layer = SVGUtil.svgElement(plot.getDocument(), "g");
        String transform = SVGUtil.makeMarginTransform(width, height, 100.0, sizey, margin);
        SVGUtil.setAtt(layer, "transform", transform);
        LinearScale scalex = new LinearScale(curve.getMinx(), curve.getMaxx());
        LinearScale scaley = new LinearScale(curve.getMiny(), curve.getMaxy());
        SVGPath path = new SVGPath();
        XYCurve.Itr iterator = curve.iterator();
        while (iterator.valid()) {
            double x = scalex.getScaled(iterator.getX());
            double y = 1.0 - scaley.getScaled(iterator.getY());
            path.drawTo(100.0 * x, sizey * y);
            iterator.advance();
        }
        Element line = path.makeElement(plot, SERIESID);
        try {
            SVGSimpleLinearAxis.drawAxis(plot, layer, scaley, 0.0, sizey, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, style);
            SVGSimpleLinearAxis.drawAxis(plot, layer, scalex, 0.0, sizey, 100.0, sizey, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, style);
        }
        catch (CSSClassManager.CSSNamingConflict e) {
            LoggingUtil.exception(e);
        }
        Element labelx = plot.svgText(50.0, sizey + margin * 0.9, curve.getLabelx());
        SVGUtil.setCSSClass(labelx, CSS_AXIS_LABEL);
        layer.appendChild(labelx);
        Element labely = plot.svgText(margin * -0.8, sizey * 0.5, curve.getLabely());
        SVGUtil.setCSSClass(labely, CSS_AXIS_LABEL);
        SVGUtil.setAtt(labely, "transform", "rotate(-90," + FormatUtil.NF6.format(margin * -0.8) + "," + FormatUtil.NF6.format(sizey * 0.5) + ")");
        layer.appendChild(labely);
        if (curve instanceof OutlierROCCurve.ROCResult) {
            double rocauc = ((OutlierROCCurve.ROCResult)curve).getAUC();
            String lt = "ROC AUC: " + FormatUtil.NF.format(rocauc);
            if (rocauc <= 0.5) {
                auclbl = plot.svgText(50.0, sizey * 0.1, lt);
                SVGUtil.setCSSClass(auclbl, CSS_AXIS_LABEL);
                layer.appendChild(auclbl);
            } else {
                auclbl = plot.svgText(50.0, sizey * 0.95, lt);
                SVGUtil.setCSSClass(auclbl, CSS_AXIS_LABEL);
                layer.appendChild(auclbl);
            }
        }
        if (curve instanceof OutlierPrecisionRecallCurve.PRCurve) {
            double prauc = ((OutlierPrecisionRecallCurve.PRCurve)curve).getAUC();
            String lt = "PR AUC: " + FormatUtil.NF.format(prauc);
            if (prauc <= 0.5) {
                auclbl = plot.svgText(50.0, sizey * 0.1, lt);
                SVGUtil.setCSSClass(auclbl, CSS_AXIS_LABEL);
                layer.appendChild(auclbl);
            } else {
                auclbl = plot.svgText(50.0, sizey * 0.95, lt);
                SVGUtil.setCSSClass(auclbl, CSS_AXIS_LABEL);
                layer.appendChild(auclbl);
            }
        }
        layer.appendChild(line);
        return new StaticVisualizationInstance(context, task, plot, width, height, layer);
    }

    private void setupCSS(VisualizerContext context, SVGPlot svgp) {
        StyleLibrary style = context.getStyleLibrary();
        CSSClass csscls = new CSSClass(this, SERIESID);
        csscls.setStatement("fill", "none");
        style.lines().formatCSSClass(csscls, 0, style.getLineWidth("xycurve"), new Object[0]);
        svgp.addCSSClassOrLogError(csscls);
        CSSClass label = new CSSClass(this, CSS_AXIS_LABEL);
        label.setStatement("fill", style.getTextColor("xycurve"));
        label.setStatement("font-family", style.getFontFamily("xycurve"));
        label.setStatement("font-size", style.getTextSize("xycurve"));
        label.setStatement("text-anchor", "middle");
        svgp.addCSSClassOrLogError(label);
        svgp.updateStyleElement();
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(XYCurve.class).forEach(curve -> context.addVis(curve, new VisualizationTask(this, NAME, curve, null).level(200)));
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }
}

