/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.geometry.XYPlot;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;

public class XYPlotVisualization
implements VisFactory {
    private static final String NAME = "XYPlot";
    private static final String SERIESID = "series_";
    private static final String CSS_AXIS_LABEL = "xy-axis-label";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        XYPlot xyplot = (XYPlot)task.getResult();
        this.setupCSS(context, plot, xyplot);
        StyleLibrary style = context.getStyleLibrary();
        double sizex = 100.0;
        double sizey = 100.0 * height / width;
        double margin = style.getSize("margin");
        Element layer = SVGUtil.svgElement(plot.getDocument(), "g");
        String transform = SVGUtil.makeMarginTransform(width, height, 100.0, sizey, margin);
        SVGUtil.setAtt(layer, "transform", transform);
        LinearScale scalex = new LinearScale(xyplot.getMinx(), xyplot.getMaxx());
        LinearScale scaley = new LinearScale(xyplot.getMiny(), xyplot.getMaxy());
        for (XYPlot.Curve curve : xyplot) {
            SVGPath path = new SVGPath();
            XYPlot.Curve.Itr iterator = curve.iterator();
            while (iterator.valid()) {
                double x = scalex.getScaled(iterator.getX());
                double y = 1.0 - scaley.getScaled(iterator.getY());
                path.drawTo(100.0 * x, sizey * y);
                iterator.advance();
            }
            layer.appendChild(path.makeElement(plot, SERIESID + curve.getColor()));
        }
        try {
            SVGSimpleLinearAxis.drawAxis(plot, layer, scaley, 0.0, sizey, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, style);
            SVGSimpleLinearAxis.drawAxis(plot, layer, scalex, 0.0, sizey, 100.0, sizey, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, style);
        }
        catch (CSSClassManager.CSSNamingConflict e) {
            LoggingUtil.exception(e);
        }
        Element labelx = plot.svgText(50.0, sizey + margin * 0.9, xyplot.getLabelx());
        SVGUtil.setCSSClass(labelx, CSS_AXIS_LABEL);
        layer.appendChild(labelx);
        Element labely = plot.svgText(margin * -0.8, sizey * 0.5, xyplot.getLabely());
        SVGUtil.setCSSClass(labely, CSS_AXIS_LABEL);
        SVGUtil.setAtt(labely, "transform", "rotate(-90," + FormatUtil.NF6.format(margin * -0.8) + "," + FormatUtil.NF6.format(sizey * 0.5) + ")");
        layer.appendChild(labely);
        return new StaticVisualizationInstance(context, task, plot, width, height, layer);
    }

    private void setupCSS(VisualizerContext context, SVGPlot svgp, XYPlot plot) {
        StyleLibrary style = context.getStyleLibrary();
        for (XYPlot.Curve curve : plot) {
            CSSClass csscls = new CSSClass(this, SERIESID + curve.getColor());
            csscls.setStatement("fill", "none");
            style.lines().formatCSSClass(csscls, curve.getColor(), style.getLineWidth("xycurve"), new Object[0]);
            svgp.addCSSClassOrLogError(csscls);
        }
        CSSClass label = new CSSClass(this, CSS_AXIS_LABEL);
        label.setStatement("fill", style.getTextColor("xycurve"));
        label.setStatement("font-family", style.getFontFamily("xycurve"));
        label.setStatement("font-size", style.getTextSize("xycurve"));
        label.setStatement("text-anchor", "middle");
        svgp.addCSSClassOrLogError(label);
        svgp.updateStyleElement();
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(XYPlot.class).forEach(plot -> context.addVis(plot, new VisualizationTask(this, NAME, plot, null).level(200)));
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }
}

