/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.workflow;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.workflow.WorkflowStep;
import java.util.List;

public class AlgorithmStep
implements WorkflowStep {
    private static final Logging LOG = Logging.getLogger(AlgorithmStep.class);
    private List<? extends Algorithm> algorithms;
    private Result stepresult;

    public AlgorithmStep(List<? extends Algorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public Result runAlgorithms(Database database) {
        ResultHierarchy hier = database.getHierarchy();
        if (LOG.isStatistics()) {
            boolean first = true;
            It<Index> it = hier.iterDescendants(database).filter(Index.class);
            while (it.valid()) {
                if (first) {
                    LOG.statistics("Index statistics before running algorithms:");
                    first = false;
                }
                it.get().logStatistics();
                it.advance();
            }
        }
        this.stepresult = new BasicResult("Algorithm Step", "algorithm-step");
        for (Algorithm algorithm : this.algorithms) {
            Thread.currentThread().setName(algorithm.toString());
            Duration duration = LOG.isStatistics() ? LOG.newDuration(algorithm.getClass().getName() + ".runtime").begin() : null;
            Result res = algorithm.run(database);
            if (duration != null) {
                LOG.statistics(duration.end());
            }
            if (LOG.isStatistics()) {
                boolean first = true;
                It<Index> it = hier.iterDescendants(database).filter(Index.class);
                while (it.valid()) {
                    if (first) {
                        LOG.statistics("Index statistics after running algorithm " + algorithm.toString() + ":");
                        first = false;
                    }
                    it.get().logStatistics();
                    it.advance();
                }
            }
            if (res == null) continue;
            hier.add(database, res);
        }
        return this.stepresult;
    }

    public Result getResult() {
        return this.stepresult;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected boolean time = false;
        protected List<? extends Algorithm> algorithms;
        public static final OptionID TIME_ID = new OptionID("time", "Enable logging of runtime data. Do not combine with more verbose logging, since verbose logging can significantly impact performance.");
        public static final OptionID ALGORITHM_ID = AbstractAlgorithm.ALGORITHM_ID;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectListParameter ALGORITHM_PARAM;
            super.makeOptions(config);
            Flag timeF = new Flag(TIME_ID);
            if (config.grab(timeF)) {
                this.time = (Boolean)timeF.getValue();
            }
            if (config.grab(ALGORITHM_PARAM = new ObjectListParameter(ALGORITHM_ID, Algorithm.class))) {
                this.algorithms = ALGORITHM_PARAM.instantiateClasses(config);
            }
        }

        @Override
        protected AlgorithmStep makeInstance() {
            if (this.time) {
                LoggingConfiguration.setStatistics();
            }
            return new AlgorithmStep(this.algorithms);
        }
    }
}

