/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.workflow;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.evaluation.AutomaticEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.workflow.WorkflowStep;
import java.util.Arrays;
import java.util.List;

public class EvaluationStep
implements WorkflowStep {
    private List<? extends Evaluator> evaluators = null;
    private Result stepresult;

    public EvaluationStep(List<? extends Evaluator> evaluators) {
        this.evaluators = evaluators;
    }

    public void runEvaluators(ResultHierarchy hier, Database db) {
        this.stepresult = new BasicResult("Evaluation Step", "evaluation-step");
        if (this.evaluators != null) {
            new Evaluation(hier, this.evaluators).update(db);
        }
    }

    public Result getResult() {
        return this.stepresult;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private List<Evaluator> evaluators = null;
        public static final OptionID EVALUATOR_ID = new OptionID("evaluator", "Class to evaluate the results with.");

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            List<Class> def = Arrays.asList(AutomaticEvaluation.class);
            ObjectListParameter evaluatorP = new ObjectListParameter(EVALUATOR_ID, Evaluator.class);
            evaluatorP.setDefaultValue(def);
            if (config.grab(evaluatorP)) {
                this.evaluators = evaluatorP.instantiateClasses(config);
            }
        }

        @Override
        protected EvaluationStep makeInstance() {
            return new EvaluationStep(this.evaluators);
        }
    }

    private static class Evaluation
    implements ResultListener {
        private List<? extends Evaluator> evaluators;
        private ResultHierarchy hier;

        public Evaluation(ResultHierarchy hier, List<? extends Evaluator> evaluators) {
            this.hier = hier;
            this.evaluators = evaluators;
            hier.addResultListener(this);
        }

        public void update(Result r) {
            for (Evaluator evaluator : this.evaluators) {
                Thread.currentThread().setName(evaluator.toString());
                evaluator.processNewResult(this.hier, r);
            }
        }

        @Override
        public void resultAdded(Result child, Result parent) {
            this.update(child);
        }

        @Override
        public void resultChanged(Result current) {
        }

        @Override
        public void resultRemoved(Result child, Result parent) {
        }
    }
}

