/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.workflow;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import de.lmu.ifi.dbs.elki.workflow.WorkflowStep;
import java.util.logging.Level;

public class LoggingStep
implements WorkflowStep {
    private static final Logging LOG = Logging.getLogger(LoggingStep.class);

    public LoggingStep(int verbose, String[][] levels) {
        if (verbose <= 0) {
            LoggingConfiguration.setVerbose(Logging.Level.WARNING);
        } else if (verbose == 1) {
            LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
        } else {
            LoggingConfiguration.setVerbose(Logging.Level.VERYVERBOSE);
        }
        if (levels != null) {
            for (String[] pair : levels) {
                try {
                    if (pair.length == 1) {
                        try {
                            Level level = Logging.Level.parse(pair[0]);
                            LoggingConfiguration.setDefaultLevel(level);
                        }
                        catch (IllegalArgumentException e) {
                            LoggingConfiguration.setLevelFor(pair[0], Logging.Level.FINEST.getName());
                        }
                        continue;
                    }
                    if (pair.length == 2) {
                        LoggingConfiguration.setLevelFor(pair[0], pair[1]);
                        continue;
                    }
                    throw new AbortException("Invalid logging settings");
                }
                catch (IllegalArgumentException e) {
                    LOG.warning("Invalid logging statement for package " + pair[0] + ": " + e.getMessage());
                }
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected int verbose = 0;
        protected String[][] levels = null;

        @Override
        protected void makeOptions(Parameterization config) {
            StringParameter debugP;
            super.makeOptions(config);
            Flag verboseF = new Flag(AbstractApplication.Parameterizer.VERBOSE_ID);
            if (config.grab(verboseF) && verboseF.isTrue()) {
                ++this.verbose;
                Flag verbose2F = new Flag(AbstractApplication.Parameterizer.VERBOSE_ID);
                if (config.grab(verbose2F) && verbose2F.isTrue()) {
                    ++this.verbose;
                }
            }
            if (config.grab(debugP = (StringParameter)new StringParameter(AbstractApplication.Parameterizer.DEBUG_ID).setOptional(true))) {
                String[] opts = ((String)debugP.getValue()).split(",");
                this.levels = new String[opts.length][];
                int i = 0;
                for (String opt : opts) {
                    String[] chunks = opt.split("=");
                    if (chunks.length != 1 && chunks.length != 2) {
                        config.reportError(new WrongParameterValueException(debugP, (String)debugP.getValue(), "Invalid debug option."));
                        break;
                    }
                    this.levels[i] = chunks;
                    ++i;
                }
            }
        }

        @Override
        protected LoggingStep makeInstance() {
            return new LoggingStep(this.verbose, this.levels);
        }
    }
}

