/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.workflow;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultWriter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.workflow.WorkflowStep;
import java.util.ArrayList;
import java.util.List;

public class OutputStep
implements WorkflowStep {
    private List<? extends ResultHandler> resulthandlers = null;
    protected static ArrayList<Class<? extends ResultHandler>> defaultHandlers = null;

    public OutputStep(List<? extends ResultHandler> resulthandlers) {
        this.resulthandlers = resulthandlers;
    }

    public void runResultHandlers(ResultHierarchy hier, Database db) {
        for (ResultHandler resultHandler : this.resulthandlers) {
            Thread.currentThread().setName(resultHandler.toString());
            resultHandler.processNewResult(hier, db);
        }
    }

    public static void setDefaultHandlerWriter() {
        defaultHandlers = new ArrayList(1);
        defaultHandlers.add(ResultWriter.class);
    }

    public static void setDefaultHandlerVisualizer() {
        Class clz;
        defaultHandlers = new ArrayList(1);
        try {
            clz = Thread.currentThread().getContextClassLoader().loadClass("de.lmu.ifi.dbs.elki.result.AutomaticVisualization");
        }
        catch (ClassNotFoundException e) {
            clz = ResultWriter.class;
        }
        defaultHandlers.add(clz);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private List<? extends ResultHandler> resulthandlers = null;
        public static final OptionID RESULT_HANDLER_ID = new OptionID("resulthandler", "Result handler class.");
        public static final OptionID OUTPUT_ID = new OptionID("out", "Directory name (or name of an existing file) to write the obtained results in. If this parameter is omitted, per default the output will sequentially be given to STDOUT.");

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectListParameter resultHandlerParam = new ObjectListParameter(RESULT_HANDLER_ID, ResultHandler.class);
            if (defaultHandlers != null) {
                resultHandlerParam.setDefaultValue(defaultHandlers);
            }
            if (config.grab(resultHandlerParam)) {
                this.resulthandlers = resultHandlerParam.instantiateClasses(config);
            }
        }

        @Override
        protected OutputStep makeInstance() {
            return new OutputStep(this.resulthandlers);
        }
    }
}

