/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.util;

import com.jogamp.common.nio.Buffers;
import java.nio.ByteBuffer;
import javax.media.nativewindow.util.PixelFormat;
import javax.media.nativewindow.util.PixelRectangle;

public class PixelFormatUtil {
    public static PixelFormat getReversed(PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case LUMINANCE: {
                return PixelFormat.LUMINANCE;
            }
            case RGB888: {
                return PixelFormat.BGR888;
            }
            case BGR888: {
                return PixelFormat.RGB888;
            }
            case RGBA8888: {
                return PixelFormat.ABGR8888;
            }
            case ABGR8888: {
                return PixelFormat.RGBA8888;
            }
            case ARGB8888: {
                return PixelFormat.BGRA8888;
            }
            case BGRA8888: {
                return PixelFormat.ABGR8888;
            }
        }
        throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat));
    }

    public static int getValue32(PixelFormat pixelFormat, ByteBuffer byteBuffer, int n) {
        switch (pixelFormat) {
            case LUMINANCE: {
                byte by = byteBuffer.get(n++);
                return 0xFF000000 | (0xFF & by) << 16 | (0xFF & by) << 8 | 0xFF & by;
            }
            case RGB888: 
            case BGR888: {
                byte by = byteBuffer.get(n++);
                byte by2 = byteBuffer.get(n++);
                byte by3 = byteBuffer.get(n++);
                return 0xFF000000 | (0xFF & by3) << 16 | (0xFF & by2) << 8 | 0xFF & by;
            }
            case RGBA8888: 
            case ABGR8888: 
            case ARGB8888: 
            case BGRA8888: {
                byte by = byteBuffer.get(n++);
                byte by4 = byteBuffer.get(n++);
                byte by5 = byteBuffer.get(n++);
                byte by6 = byteBuffer.get(n++);
                return (0xFF & by6) << 24 | (0xFF & by5) << 16 | (0xFF & by4) << 8 | 0xFF & by;
            }
        }
        throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat));
    }

    public static int convertToInt32(PixelFormat pixelFormat, byte by, byte by2, byte by3, byte by4) {
        switch (pixelFormat) {
            case LUMINANCE: {
                byte by5 = (byte)(((0xFF & by) + (0xFF & by2) + (0xFF & by3)) / 3);
                return 0xFF000000 | (0xFF & by5) << 16 | (0xFF & by5) << 8 | 0xFF & by5;
            }
            case RGB888: {
                return 0xFF000000 | (0xFF & by3) << 16 | (0xFF & by2) << 8 | 0xFF & by;
            }
            case BGR888: {
                return 0xFF000000 | (0xFF & by) << 16 | (0xFF & by2) << 8 | 0xFF & by3;
            }
            case RGBA8888: {
                return (0xFF & by4) << 24 | (0xFF & by3) << 16 | (0xFF & by2) << 8 | 0xFF & by;
            }
            case ABGR8888: {
                return (0xFF & by) << 24 | (0xFF & by2) << 16 | (0xFF & by3) << 8 | 0xFF & by4;
            }
            case ARGB8888: {
                return (0xFF & by3) << 24 | (0xFF & by2) << 16 | (0xFF & by) << 8 | 0xFF & by4;
            }
            case BGRA8888: {
                return (0xFF & by4) << 24 | (0xFF & by) << 16 | (0xFF & by2) << 8 | 0xFF & by3;
            }
        }
        throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat));
    }

    public static int convertToInt32(PixelFormat pixelFormat, PixelFormat pixelFormat2, ByteBuffer byteBuffer, int n) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        switch (pixelFormat2) {
            case LUMINANCE: {
                by3 = by4 = byteBuffer.get(n++);
                by2 = by4;
                by = -1;
                break;
            }
            case RGB888: {
                by4 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by2 = byteBuffer.get(n++);
                by = -1;
                break;
            }
            case BGR888: {
                by2 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by4 = byteBuffer.get(n++);
                by = -1;
                break;
            }
            case RGBA8888: {
                by4 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by2 = byteBuffer.get(n++);
                by = byteBuffer.get(n++);
                break;
            }
            case ABGR8888: {
                by = byteBuffer.get(n++);
                by2 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by4 = byteBuffer.get(n++);
                break;
            }
            case ARGB8888: {
                by = byteBuffer.get(n++);
                by4 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by2 = byteBuffer.get(n++);
                break;
            }
            case BGRA8888: {
                by2 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by4 = byteBuffer.get(n++);
                by = byteBuffer.get(n++);
                break;
            }
            default: {
                throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat2));
            }
        }
        return PixelFormatUtil.convertToInt32(pixelFormat, by4, by3, by2, by);
    }

    public static int convertToInt32(PixelFormat pixelFormat, PixelFormat pixelFormat2, int n) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        switch (pixelFormat2) {
            case LUMINANCE: {
                by3 = by4 = (byte)n;
                by2 = by4;
                by = -1;
                break;
            }
            case RGB888: {
                by4 = (byte)n;
                by3 = (byte)(n >>> 8);
                by2 = (byte)(n >>> 16);
                by = -1;
                break;
            }
            case BGR888: {
                by2 = (byte)n;
                by3 = (byte)(n >>> 8);
                by4 = (byte)(n >>> 16);
                by = -1;
                break;
            }
            case RGBA8888: {
                by4 = (byte)n;
                by3 = (byte)(n >>> 8);
                by2 = (byte)(n >>> 16);
                by = (byte)(n >>> 24);
                break;
            }
            case ABGR8888: {
                by = (byte)n;
                by2 = (byte)(n >>> 8);
                by3 = (byte)(n >>> 16);
                by4 = (byte)(n >>> 24);
                break;
            }
            case ARGB8888: {
                by = (byte)n;
                by4 = (byte)(n >>> 8);
                by3 = (byte)(n >>> 16);
                by2 = (byte)(n >>> 24);
                break;
            }
            case BGRA8888: {
                by2 = (byte)n;
                by3 = (byte)(n >>> 8);
                by4 = (byte)(n >>> 16);
                by = (byte)(n >>> 24);
                break;
            }
            default: {
                throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat2));
            }
        }
        return PixelFormatUtil.convertToInt32(pixelFormat, by4, by3, by2, by);
    }

    public static PixelRectangle convert32(PixelRectangle pixelRectangle, final PixelFormat pixelFormat, int n, final boolean bl, boolean bl2) {
        int n2;
        int n3 = pixelRectangle.getSize().getWidth();
        int n4 = pixelRectangle.getSize().getHeight();
        final int n5 = pixelFormat.bytesPerPixel();
        if (0 != n) {
            n2 = n;
            if (n2 < n5 * n3) {
                throw new IllegalArgumentException("Invalid stride " + n2 + ", must be greater than bytesPerPixel " + n5 + " * width " + n3);
            }
        } else {
            n2 = n5 * n3;
        }
        int n6 = n2 * n4;
        final ByteBuffer byteBuffer = bl2 ? Buffers.newDirectByteBuffer(n6) : ByteBuffer.allocate(n6).order(pixelRectangle.getPixels().order());
        PixelSink32 pixelSink32 = new PixelSink32(){

            @Override
            public void store(int n, int n22, int n3) {
                int n4 = n2 * n22 + n * n5;
                byteBuffer.put(n4++, (byte)n3);
                if (3 <= n5) {
                    byteBuffer.put(n4++, (byte)(n3 >>> 8));
                    byteBuffer.put(n4++, (byte)(n3 >>> 16));
                    if (4 <= n5) {
                        byteBuffer.put(n4++, (byte)(n3 >>> 24));
                    }
                }
            }

            @Override
            public final PixelFormat getPixelformat() {
                return pixelFormat;
            }

            @Override
            public final int getStride() {
                return n2;
            }

            @Override
            public final boolean isGLOriented() {
                return bl;
            }
        };
        PixelFormatUtil.convert32(pixelSink32, pixelRectangle);
        return new PixelRectangle.GenericPixelRect(pixelFormat, pixelRectangle.getSize(), n2, bl, byteBuffer);
    }

    public static void convert32(PixelSink32 pixelSink32, PixelRectangle pixelRectangle) {
        PixelFormatUtil.convert32(pixelSink32, pixelRectangle.getPixels(), pixelRectangle.getPixelformat(), pixelRectangle.isGLOriented(), pixelRectangle.getSize().getWidth(), pixelRectangle.getSize().getHeight(), pixelRectangle.getStride());
    }

    public static void convert32(PixelSink32 pixelSink32, ByteBuffer byteBuffer, PixelFormat pixelFormat, boolean bl, int n, int n2, int n3) {
        boolean bl2;
        int n4 = pixelFormat.bytesPerPixel();
        if (0 != n3) {
            if (n3 < n4 * n) {
                throw new IllegalArgumentException("Invalid stride " + n3 + ", must be greater than bytesPerPixel " + n4 + " * width " + n);
            }
        } else {
            n3 = n4 * n;
        }
        PixelFormat pixelFormat2 = pixelSink32.getPixelformat();
        boolean bl3 = bl != pixelSink32.isGLOriented();
        boolean bl4 = bl2 = pixelFormat == pixelFormat2 && pixelFormat2.bytesPerPixel() == 4;
        if (bl2) {
            for (int i = 0; i < n2; ++i) {
                int n5 = bl3 ? (n2 - 1 - i) * n3 : i * n3;
                for (int j = 0; j < n; ++j) {
                    pixelSink32.store(j, i, PixelFormatUtil.getValue32(pixelFormat, byteBuffer, n5));
                    n5 += n4;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n6 = bl3 ? (n2 - 1 - i) * n3 : i * n3;
                for (int j = 0; j < n; ++j) {
                    pixelSink32.store(j, i, PixelFormatUtil.convertToInt32(pixelFormat2, pixelFormat, byteBuffer, n6));
                    n6 += n4;
                }
            }
        }
    }

    public static interface PixelSink32
    extends PixelSink {
        public void store(int var1, int var2, int var3);
    }

    public static interface PixelSink {
        public PixelFormat getPixelformat();

        public int getStride();

        public boolean isGLOriented();
    }
}

