/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl.awt;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.awt.AWTPrintLifecycle;
import com.jogamp.nativewindow.awt.AWTWindowClosingProtocol;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.util.GLDrawableUtil;
import com.jogamp.opengl.util.TileRenderer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import javax.media.opengl.GLSharedContextSetter;
import javax.media.opengl.Threading;
import javax.media.opengl.awt.AWTGLAutoDrawable;
import javax.swing.SwingUtilities;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.awt.AWTTilePainter;

public class GLCanvas
extends Canvas
implements AWTGLAutoDrawable,
WindowClosingProtocol,
OffscreenLayerOption,
AWTPrintLifecycle,
GLSharedContextSetter {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final GLDrawableHelper helper = new GLDrawableHelper();
    private AWTGraphicsConfiguration awtConfig;
    private volatile GLDrawableImpl drawable;
    private volatile JAWTWindow jawtWindow;
    private volatile GLContextImpl context;
    private volatile boolean sendReshape = false;
    private final GLCapabilitiesImmutable capsReqUser;
    private final GLCapabilitiesChooser chooser;
    private int additionalCtxCreationFlags = 0;
    private final GraphicsDevice device;
    private boolean shallUseOffscreenLayer = false;
    private volatile boolean isShowing;
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            GLCanvas.this.isShowing = GLCanvas.this.isShowing();
        }
    };
    private final AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.destroyImpl(true);
        }
    }, null);
    private final Runnable realizeOnEDTAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.setRealizedImpl(true);
        }
    };
    private final Runnable unrealizeOnEDTAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.setRealizedImpl(false);
        }
    };
    private volatile boolean printActive = false;
    private GLAnimatorControl printAnimator = null;
    private GLAutoDrawable printGLAD = null;
    private AWTTilePainter printAWTTiles = null;
    private final Runnable setupPrintOnEDT = new Runnable(){

        @Override
        public void run() {
            boolean bl;
            if (!GLCanvas.this.validateGLDrawable()) {
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Info: GLCanvas setupPrint - skipped GL render, drawable not valid yet");
                }
                GLCanvas.this.printActive = false;
                return;
            }
            if (!GLCanvas.this.isVisible()) {
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Info: GLCanvas setupPrint - skipped GL render, canvas not visible");
                }
                GLCanvas.this.printActive = false;
                return;
            }
            GLCanvas.this.sendReshape = false;
            GLCanvas.this.printAnimator = GLCanvas.this.helper.getAnimator();
            if (null != GLCanvas.this.printAnimator) {
                GLCanvas.this.printAnimator.remove(GLCanvas.this);
            }
            GLCanvas.this.printGLAD = GLCanvas.this;
            GLCapabilities gLCapabilities = (GLCapabilities)GLCanvas.this.getChosenGLCapabilities().cloneMutable();
            int n = GLCanvas.this.printAWTTiles.getNumSamples(gLCapabilities);
            GLDrawable gLDrawable = GLCanvas.this.printGLAD.getDelegatedDrawable();
            boolean bl2 = n != gLCapabilities.getNumSamples();
            boolean bl3 = ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth != -1 && ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth != gLDrawable.getWidth() || ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight != -1 && ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight != gLDrawable.getHeight();
            boolean bl4 = gLCapabilities.isOnscreen();
            boolean bl5 = bl = !gLCapabilities.getSampleBuffers() && (bl4 || bl2 || bl3);
            if (DEBUG) {
                System.err.println("AWT print.setup: reqNewGLAD " + bl + "[ onscreen " + bl4 + ", samples " + bl2 + ", size " + bl3 + "], " + ", drawableSize " + gLDrawable.getWidth() + "x" + gLDrawable.getHeight() + ", customTileSize " + ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth + "x" + ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight + ", scaleMat " + ((GLCanvas)GLCanvas.this).printAWTTiles.scaleMatX + " x " + ((GLCanvas)GLCanvas.this).printAWTTiles.scaleMatY + ", numSamples " + ((GLCanvas)GLCanvas.this).printAWTTiles.customNumSamples + " -> " + n + ", printAnimator " + GLCanvas.this.printAnimator);
            }
            if (bl) {
                gLCapabilities.setDoubleBuffered(false);
                gLCapabilities.setOnscreen(false);
                if (n != gLCapabilities.getNumSamples()) {
                    gLCapabilities.setSampleBuffers(0 < n);
                    gLCapabilities.setNumSamples(n);
                }
                GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
                GLCanvas.this.printGLAD = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth != -1 ? ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth : 1024, ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight != -1 ? ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight : 1024);
                GLDrawableUtil.swapGLContextAndAllGLEventListener(GLCanvas.this, GLCanvas.this.printGLAD);
                gLDrawable = GLCanvas.this.printGLAD.getDelegatedDrawable();
            }
            GLCanvas.this.printAWTTiles.setGLOrientation(GLCanvas.this.printGLAD.isGLOriented(), GLCanvas.this.printGLAD.isGLOriented());
            ((GLCanvas)GLCanvas.this).printAWTTiles.renderer.setTileSize(gLDrawable.getWidth(), gLDrawable.getHeight(), 0);
            ((GLCanvas)GLCanvas.this).printAWTTiles.renderer.attachAutoDrawable(GLCanvas.this.printGLAD);
            if (DEBUG) {
                System.err.println("AWT print.setup " + GLCanvas.this.printAWTTiles);
                System.err.println("AWT print.setup AA " + n + ", " + gLCapabilities);
                System.err.println("AWT print.setup printGLAD: " + GLCanvas.this.printGLAD.getWidth() + "x" + GLCanvas.this.printGLAD.getHeight() + ", " + GLCanvas.this.printGLAD);
                System.err.println("AWT print.setup printDraw: " + gLDrawable.getWidth() + "x" + gLDrawable.getHeight() + ", " + gLDrawable);
            }
        }
    };
    private final Runnable releasePrintOnEDT = new Runnable(){

        @Override
        public void run() {
            if (DEBUG) {
                System.err.println("AWT print.release " + GLCanvas.this.printAWTTiles);
            }
            GLCanvas.this.printAWTTiles.dispose();
            GLCanvas.this.printAWTTiles = null;
            if (GLCanvas.this.printGLAD != GLCanvas.this) {
                GLDrawableUtil.swapGLContextAndAllGLEventListener(GLCanvas.this.printGLAD, GLCanvas.this);
                GLCanvas.this.printGLAD.destroy();
            }
            GLCanvas.this.printGLAD = null;
            if (null != GLCanvas.this.printAnimator) {
                GLCanvas.this.printAnimator.add(GLCanvas.this);
                GLCanvas.this.printAnimator = null;
            }
            GLCanvas.this.sendReshape = true;
            GLCanvas.this.printActive = false;
            GLCanvas.this.display();
        }
    };
    private final Runnable destroyOnEDTAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                GLAnimatorControl gLAnimatorControl = GLCanvas.this.getAnimator();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Info: destroyOnEDTAction() - START, hasContext " + (null != GLCanvas.this.context) + ", hasDrawable " + (null != GLCanvas.this.drawable) + ", " + gLAnimatorControl);
                }
                boolean bl = null != gLAnimatorControl ? gLAnimatorControl.pause() : false;
                if (null != GLCanvas.this.context) {
                    if (GLCanvas.this.context.isCreated()) {
                        try {
                            GLCanvas.this.helper.disposeGL(GLCanvas.this, GLCanvas.this.context, true);
                            if (DEBUG) {
                                System.err.println(GLCanvas.getThreadName() + ": destroyOnEDTAction() - post ctx: " + GLCanvas.this.context);
                            }
                        }
                        catch (GLException gLException) {
                            gLException.printStackTrace();
                        }
                    }
                    GLCanvas.this.context = null;
                }
                if (null != GLCanvas.this.drawable) {
                    GLCanvas.this.drawable.setRealized(false);
                    if (DEBUG) {
                        System.err.println(GLCanvas.getThreadName() + ": destroyOnEDTAction() - post drawable: " + GLCanvas.this.drawable);
                    }
                    GLCanvas.this.drawable = null;
                }
                if (bl) {
                    gLAnimatorControl.resume();
                }
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": dispose() - END, animator " + gLAnimatorControl);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable disposeJAWTWindowAndAWTDeviceOnEDT = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.context = null;
            GLCanvas.this.drawable = null;
            if (null != GLCanvas.this.jawtWindow) {
                GLCanvas.this.jawtWindow.destroy();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": GLCanvas.disposeJAWTWindowAndAWTDeviceOnEDT(): post JAWTWindow: " + GLCanvas.this.jawtWindow);
                }
                GLCanvas.this.jawtWindow = null;
            }
            if (null != GLCanvas.this.awtConfig) {
                AbstractGraphicsConfiguration abstractGraphicsConfiguration = GLCanvas.this.awtConfig.getNativeGraphicsConfiguration();
                AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
                String string = DEBUG ? abstractGraphicsDevice.toString() : null;
                boolean bl = abstractGraphicsDevice.close();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": GLCanvas.disposeJAWTWindowAndAWTDeviceOnEDT(): post GraphicsDevice: " + string + ", result: " + bl);
                }
            }
            GLCanvas.this.awtConfig = null;
        }
    };
    private final Runnable initAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.helper.init(GLCanvas.this, !GLCanvas.this.sendReshape);
        }
    };
    private final Runnable displayAction = new Runnable(){

        @Override
        public void run() {
            if (GLCanvas.this.sendReshape) {
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Reshape: " + GLCanvas.this.getWidth() + "x" + GLCanvas.this.getHeight());
                }
                GLCanvas.this.helper.reshape(GLCanvas.this, 0, 0, GLCanvas.this.getWidth(), GLCanvas.this.getHeight());
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.helper.display(GLCanvas.this);
        }
    };
    private final Runnable displayOnEDTAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (null != GLCanvas.this.drawable && GLCanvas.this.drawable.isRealized()) {
                    GLCanvas.this.helper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable swapBuffersOnEDTAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (null != GLCanvas.this.drawable && GLCanvas.this.drawable.isRealized()) {
                    GLCanvas.this.drawable.swapBuffers();
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public GLCanvas() throws GLException {
        this((GLCapabilitiesImmutable)null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws GLException {
        this(gLCapabilitiesImmutable, null, null, null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLContext gLContext) throws GLException {
        this(gLCapabilitiesImmutable, null, gLContext, null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) throws GLException {
        this(gLCapabilitiesImmutable, gLCapabilitiesChooser, null, graphicsDevice);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext, GraphicsDevice graphicsDevice) throws GLException {
        GraphicsConfiguration graphicsConfiguration;
        gLCapabilitiesImmutable = null == gLCapabilitiesImmutable ? new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice())) : (GLCapabilitiesImmutable)gLCapabilitiesImmutable.cloneMutable();
        if (!gLCapabilitiesImmutable.isOnscreen()) {
            this.setShallUseOffscreenLayer(true);
        }
        if (null == graphicsDevice && null != (graphicsConfiguration = super.getGraphicsConfiguration())) {
            graphicsDevice = graphicsConfiguration.getDevice();
        }
        this.capsReqUser = gLCapabilitiesImmutable;
        this.chooser = gLCapabilitiesChooser;
        if (null != gLContext) {
            this.helper.setSharedContext(null, gLContext);
        }
        this.device = graphicsDevice;
        this.addHierarchyListener(this.hierarchyListener);
        this.isShowing = this.isShowing();
    }

    @Override
    public final void setSharedContext(GLContext gLContext) throws IllegalStateException {
        this.helper.setSharedContext(this.context, gLContext);
    }

    @Override
    public final void setSharedAutoDrawable(GLAutoDrawable gLAutoDrawable) throws IllegalStateException {
        this.helper.setSharedAutoDrawable(this, gLAutoDrawable);
    }

    @Override
    public final Object getUpstreamWidget() {
        return this;
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        JAWTWindow jAWTWindow = this.jawtWindow;
        if (null != jAWTWindow) {
            return jAWTWindow.isOffscreenLayerSurfaceEnabled();
        }
        return false;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (Beans.isDesignTime()) {
            return graphicsConfiguration;
        }
        GraphicsConfiguration graphicsConfiguration2 = this.awtConfig.getAWTGraphicsConfiguration();
        if (graphicsConfiguration != null && graphicsConfiguration2 != null && !graphicsConfiguration2.equals(graphicsConfiguration)) {
            if (!graphicsConfiguration2.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring())) {
                AWTGraphicsConfiguration aWTGraphicsConfiguration = this.chooseGraphicsConfiguration((GLCapabilitiesImmutable)this.awtConfig.getChosenCapabilities(), (GLCapabilitiesImmutable)this.awtConfig.getRequestedCapabilities(), this.chooser, graphicsConfiguration.getDevice());
                GraphicsConfiguration graphicsConfiguration3 = null != aWTGraphicsConfiguration ? aWTGraphicsConfiguration.getAWTGraphicsConfiguration() : null;
                boolean bl = aWTGraphicsConfiguration.getChosenCapabilities().equals(this.awtConfig.getChosenCapabilities());
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Info:");
                    System.err.println("Created Config (n): HAVE    GC " + graphicsConfiguration2);
                    System.err.println("Created Config (n): THIS    GC " + graphicsConfiguration);
                    System.err.println("Created Config (n): Choosen GC " + graphicsConfiguration3);
                    System.err.println("Created Config (n): HAVE    CF " + this.awtConfig);
                    System.err.println("Created Config (n): Choosen CF " + aWTGraphicsConfiguration);
                    System.err.println("Created Config (n): EQUALS CAPS " + bl);
                }
                if (graphicsConfiguration3 != null) {
                    graphicsConfiguration2 = graphicsConfiguration3;
                    if (!bl && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
                        this.destroyImpl(true);
                        this.awtConfig = aWTGraphicsConfiguration;
                        this.createJAWTDrawableAndContext();
                        this.validateGLDrawable();
                    } else {
                        this.awtConfig = aWTGraphicsConfiguration;
                    }
                }
            }
            return graphicsConfiguration2;
        }
        if (graphicsConfiguration == null) {
            return graphicsConfiguration2;
        }
        return graphicsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext createContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            if (this.drawable != null) {
                GLContext gLContext2 = this.drawable.createContext(gLContext);
                gLContext2.setContextCreationFlags(this.additionalCtxCreationFlags);
                GLContext gLContext3 = gLContext2;
                return gLContext3;
            }
            GLContext gLContext4 = null;
            return gLContext4;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setRealizedImpl(boolean bl) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            GLDrawableImpl gLDrawableImpl = this.drawable;
            if (null == gLDrawableImpl || bl == gLDrawableImpl.isRealized() || bl && (0 >= gLDrawableImpl.getWidth() || 0 >= gLDrawableImpl.getHeight())) {
                return;
            }
            gLDrawableImpl.setRealized(bl);
            if (bl && gLDrawableImpl.isRealized()) {
                this.sendReshape = true;
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final void setRealized(boolean bl) {
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), false, true, bl ? this.realizeOnEDTAction : this.unrealizeOnEDTAction);
    }

    @Override
    public boolean isRealized() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isRealized() : false;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(windowClosingMode);
    }

    @Override
    public void display() {
        if (!this.validateGLDrawable()) {
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Info: GLCanvas display - skipped GL render, drawable not valid yet");
            }
            return;
        }
        if (this.isShowing && !this.printActive) {
            Threading.invoke(true, this.displayOnEDTAction, this.getTreeLock());
        }
    }

    @Override
    public void destroy() {
        this.destroyImpl(false);
    }

    protected void destroyImpl(boolean bl) {
        Threading.invoke(true, this.destroyOnEDTAction, this.getTreeLock());
        if (bl) {
            AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.disposeJAWTWindowAndAWTDeviceOnEDT);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
        } else if (!this.helper.isAnimatorAnimatingOnOtherThread()) {
            this.display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            boolean bl = Beans.isDesignTime();
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Info: addNotify - start, bounds: " + this.getBounds() + ", isBeansDesignTime " + bl);
            }
            if (bl) {
                super.addNotify();
            } else {
                this.awtConfig = this.chooseGraphicsConfiguration(this.capsReqUser, this.capsReqUser, this.chooser, this.device);
                if (null == this.awtConfig) {
                    throw new GLException("Error: NULL AWTGraphicsConfiguration");
                }
                this.disableBackgroundErase();
                super.addNotify();
                this.disableBackgroundErase();
                this.createJAWTDrawableAndContext();
            }
            this.awtWindowClosingProtocol.addClosingListener();
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Info: addNotify - end: peer: " + this.getPeer());
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJAWTDrawableAndContext() {
        if (!Beans.isDesignTime()) {
            this.jawtWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow(this, this.awtConfig);
            this.jawtWindow.setShallUseOffscreenLayer(this.shallUseOffscreenLayer);
            this.jawtWindow.lockSurface();
            try {
                this.drawable = (GLDrawableImpl)GLDrawableFactory.getFactory(this.capsReqUser.getGLProfile()).createGLDrawable(this.jawtWindow);
                this.createContextImpl(this.drawable);
            }
            finally {
                this.jawtWindow.unlockSurface();
            }
        }
    }

    private boolean createContextImpl(GLDrawable gLDrawable) {
        GLContext[] gLContextArray = new GLContext[]{null};
        if (!this.helper.isSharedGLContextPending(gLContextArray)) {
            this.context = (GLContextImpl)gLDrawable.createContext(gLContextArray[0]);
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Context created: has shared " + (null != gLContextArray[0]));
            }
            return true;
        }
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Context !created: pending share");
        }
        return false;
    }

    private boolean validateGLDrawable() {
        if (Beans.isDesignTime() || !this.isDisplayable()) {
            return false;
        }
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl) {
            boolean bl = gLDrawableImpl.isRealized();
            if (!bl) {
                if (0 >= gLDrawableImpl.getWidth() || 0 >= gLDrawableImpl.getHeight()) {
                    return false;
                }
                this.setRealized(true);
                bl = gLDrawableImpl.isRealized();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Realized Drawable: isRealized " + bl + ", " + gLDrawableImpl.toString());
                }
            }
            if (bl && null == this.context) {
                bl = this.createContextImpl(gLDrawableImpl);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: removeNotify - start");
        }
        this.awtWindowClosingProtocol.removeClosingListener();
        if (Beans.isDesignTime()) {
            super.removeNotify();
        } else {
            try {
                this.destroyImpl(true);
            }
            finally {
                super.removeNotify();
            }
        }
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: removeNotify - end, peer: " + this.getPeer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Object object2;
            super.reshape(n, n2, n3, n4);
            if (DEBUG) {
                object2 = this.getNativeSurface();
                long l = null != object2 ? object2.getSurfaceHandle() : 0L;
                System.err.println("GLCanvas.sizeChanged: (" + GLCanvas.getThreadName() + "): " + n3 + "x" + n4 + " - surfaceHandle 0x" + Long.toHexString(l));
            }
            if (this.validateGLDrawable() && !this.printActive) {
                object2 = this.drawable;
                if (!((GLDrawableImpl)object2).getChosenGLCapabilities().isOnscreen()) {
                    RecursiveLock recursiveLock = this.lock;
                    recursiveLock.lock();
                    try {
                        GLDrawableImpl gLDrawableImpl = GLDrawableHelper.resizeOffscreenDrawable((GLDrawableImpl)object2, this.context, n3, n4);
                        if (object2 != gLDrawableImpl) {
                            this.drawable = gLDrawableImpl;
                        }
                    }
                    finally {
                        recursiveLock.unlock();
                    }
                }
                this.sendReshape = true;
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void setupPrint(double d, double d2, int n, int n2, int n3) {
        this.printActive = true;
        int n4 = this.isOpaque() ? 3 : 4;
        TileRenderer tileRenderer = new TileRenderer();
        this.printAWTTiles = new AWTTilePainter(tileRenderer, n4, d, d2, n, n2, n3, DEBUG);
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.setupPrintOnEDT);
    }

    @Override
    public void releasePrint() {
        if (!this.printActive || null == this.printGLAD) {
            throw new IllegalStateException("setupPrint() not called");
        }
        this.sendReshape = false;
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.releasePrintOnEDT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics graphics) {
        block12: {
            if (!this.printActive || null == this.printGLAD) {
                throw new IllegalStateException("setupPrint() not called");
            }
            if (DEBUG && !EventQueue.isDispatchThread()) {
                System.err.println(GLCanvas.getThreadName() + ": Warning: GLCanvas print - not called from AWT-EDT");
            }
            this.sendReshape = false;
            Graphics2D graphics2D = (Graphics2D)graphics;
            try {
                this.printAWTTiles.setupGraphics2DAndClipBounds(graphics2D, this.getWidth(), this.getHeight());
                TileRenderer tileRenderer = this.printAWTTiles.renderer;
                if (DEBUG) {
                    System.err.println("AWT print.0: " + tileRenderer);
                }
                if (tileRenderer.eot()) break block12;
                try {
                    do {
                        if (this.printGLAD != this) {
                            tileRenderer.display();
                            continue;
                        }
                        Threading.invoke(true, this.displayOnEDTAction, this.getTreeLock());
                    } while (!tileRenderer.eot());
                    if (DEBUG) {
                        System.err.println("AWT print.1: " + this.printAWTTiles);
                    }
                }
                finally {
                    tileRenderer.reset();
                    this.printAWTTiles.resetGraphics2D();
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println("Catched: Inversion failed of: " + graphics2D.getTransform());
                noninvertibleTransformException.printStackTrace();
            }
        }
        if (DEBUG) {
            System.err.println("AWT print.X: " + this.printAWTTiles);
        }
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.helper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public int getGLEventListenerCount() {
        return this.helper.getGLEventListenerCount();
    }

    @Override
    public GLEventListener getGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.helper.getGLEventListener(n);
    }

    @Override
    public boolean areAllGLEventListenerInitialized() {
        return this.helper.areAllGLEventListenerInitialized();
    }

    @Override
    public boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        return this.helper.getGLEventListenerInitState(gLEventListener);
    }

    @Override
    public void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        this.helper.setGLEventListenerInitState(gLEventListener, bl);
    }

    @Override
    public GLEventListener disposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        DisposeGLEventListenerAction disposeGLEventListenerAction = new DisposeGLEventListenerAction(gLEventListener, bl);
        Threading.invoke(true, disposeGLEventListenerAction, this.getTreeLock());
        return disposeGLEventListenerAction.listener;
    }

    @Override
    public GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        return this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public final Thread setExclusiveContextThread(Thread thread) throws GLException {
        return this.helper.setExclusiveContextThread(thread, this.context);
    }

    @Override
    public final Thread getExclusiveContextThread() {
        return this.helper.getExclusiveContextThread();
    }

    @Override
    public boolean invoke(boolean bl, GLRunnable gLRunnable) {
        return this.helper.invoke((GLAutoDrawable)this, bl, gLRunnable);
    }

    @Override
    public boolean invoke(boolean bl, List<GLRunnable> list) {
        return this.helper.invoke((GLAutoDrawable)this, bl, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext setContext(GLContext gLContext, boolean bl) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            GLContextImpl gLContextImpl = this.context;
            GLDrawableHelper.switchContext(this.drawable, gLContextImpl, bl, gLContext, this.additionalCtxCreationFlags);
            this.context = (GLContextImpl)gLContext;
            GLContextImpl gLContextImpl2 = gLContextImpl;
            return gLContextImpl2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GLDrawable getDelegatedDrawable() {
        return this.drawable;
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    @Override
    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        GLContextImpl gLContextImpl = this.context;
        return gLContextImpl == null ? null : ((GLContext)gLContextImpl).getGL();
    }

    @Override
    public GL setGL(GL gL) {
        GLContextImpl gLContextImpl = this.context;
        if (gLContextImpl != null) {
            ((GLContext)gLContextImpl).setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.helper.setAutoSwapBufferMode(bl);
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.helper.getAutoSwapBufferMode();
    }

    @Override
    public void swapBuffers() {
        Threading.invoke(true, this.swapBuffersOnEDTAction, this.getTreeLock());
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public GLProfile getGLProfile() {
        return this.capsReqUser.getGLProfile();
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (Beans.isDesignTime()) {
            return this.capsReqUser;
        }
        if (null == this.awtConfig) {
            throw new GLException("No AWTGraphicsConfiguration: " + this);
        }
        return (GLCapabilitiesImmutable)this.awtConfig.getChosenCapabilities();
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        if (null == this.awtConfig) {
            return this.capsReqUser;
        }
        return (GLCapabilitiesImmutable)this.awtConfig.getRequestedCapabilities();
    }

    @Override
    public boolean isGLOriented() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isGLOriented() : true;
    }

    @Override
    public NativeSurface getNativeSurface() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getNativeSurface() : null;
    }

    @Override
    public long getHandle() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getHandle() : 0L;
    }

    @Override
    public GLDrawableFactory getFactory() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getFactory() : null;
    }

    @Override
    public String toString() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        int n = null != gLDrawableImpl ? gLDrawableImpl.getWidth() : -1;
        int n2 = null != gLDrawableImpl ? gLDrawableImpl.getHeight() : -1;
        return "AWT-GLCanvas[Realized " + this.isRealized() + ",\n\t" + (null != gLDrawableImpl ? gLDrawableImpl.getClass().getName() : "null-drawable") + ",\n\tFactory   " + this.getFactory() + ",\n\thandle    0x" + Long.toHexString(this.getHandle()) + ",\n\tDrawable size " + n + "x" + n2 + ",\n\tAWT pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ",\n\tvisible " + this.isVisible() + ", displayable " + this.isDisplayable() + ", showing " + this.isShowing + ",\n\t" + this.awtConfig + "]";
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = GLCanvas.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", Canvas.class);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": GLCanvas: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": GLCanvas: TK disableBackgroundErase error: " + exception);
            }
        }
    }

    private AWTGraphicsConfiguration chooseGraphicsConfiguration(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final GLCapabilitiesImmutable gLCapabilitiesImmutable2, final GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        if (Beans.isDesignTime()) {
            return null;
        }
        final AbstractGraphicsScreen abstractGraphicsScreen = null != graphicsDevice ? AWTGraphicsScreen.createScreenDevice(graphicsDevice, 0) : AWTGraphicsScreen.createDefault();
        AWTGraphicsConfiguration aWTGraphicsConfiguration = null;
        if (EventQueue.isDispatchThread() || Thread.holdsLock(this.getTreeLock())) {
            aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, GLCapabilitiesImmutable.class).chooseGraphicsConfiguration(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, 0);
        } else {
            try {
                final ArrayList arrayList = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, GLCapabilitiesImmutable.class).chooseGraphicsConfiguration(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, 0);
                        arrayList.add(aWTGraphicsConfiguration);
                    }
                });
                aWTGraphicsConfiguration = arrayList.size() > 0 ? (AWTGraphicsConfiguration)arrayList.get(0) : null;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                throw new GLException(interruptedException);
            }
        }
        if (aWTGraphicsConfiguration == null) {
            throw new GLException("Error: Couldn't fetch AWTGraphicsConfiguration");
        }
        return aWTGraphicsConfiguration;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println(JoglVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, true).toString());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice()));
        final Frame frame = new Frame("JOGL AWT Test");
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        frame.add(gLCanvas);
        frame.setSize(128, 128);
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        gLCanvas.display();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class DisposeGLEventListenerAction
    implements Runnable {
        GLEventListener listener;
        private final boolean remove;

        private DisposeGLEventListenerAction(GLEventListener gLEventListener, boolean bl) {
            this.listener = gLEventListener;
            this.remove = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                this.listener = GLCanvas.this.helper.disposeGLEventListener(GLCanvas.this, GLCanvas.this.drawable, GLCanvas.this.context, this.listener, this.remove);
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }
}

