/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font;

import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontSet;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.GLException;

public class JavaFontLoader
implements FontSet {
    private static final IntObjectHashMap fontMap = new IntObjectHashMap();
    private static final FontSet fontLoader = new JavaFontLoader();
    static final String[] availableFontFileNames = new String[]{"LucidaBrightRegular.ttf", "LucidaBrightItalic.ttf", "LucidaBrightDemiBold.ttf", "LucidaBrightDemiItalic.ttf", "LucidaSansRegular.ttf", "LucidaSansDemiBold.ttf", "LucidaTypewriterRegular.ttf", "LucidaTypewriterBold.ttf"};
    final String javaFontPath;

    public static FontSet get() {
        return fontLoader;
    }

    private JavaFontLoader() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.home");
            }
        });
        this.javaFontPath = null != string ? string + "/lib/fonts/" : null;
    }

    static boolean is(int n, int n2) {
        return 0 != (n & n2);
    }

    @Override
    public Font getDefault() throws IOException {
        return this.get(0, 0);
    }

    @Override
    public Font get(int n, int n2) throws IOException {
        Font font = (Font)fontMap.get(n << 8 | n2);
        if (font != null) {
            return font;
        }
        if (JavaFontLoader.is(n2, 2)) {
            font = JavaFontLoader.is(n2, 4) ? this.abspath(availableFontFileNames[5], n, n2) : this.abspath(availableFontFileNames[4], n, n2);
            if (null != font) {
                fontMap.put(n << 8 | n2, font);
            }
            return font;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (JavaFontLoader.is(n2, 4)) {
                    if (JavaFontLoader.is(n2, 8)) {
                        font = this.abspath(availableFontFileNames[3], n, n2);
                        break;
                    }
                    font = this.abspath(availableFontFileNames[2], n, n2);
                    break;
                }
                if (JavaFontLoader.is(n2, 8)) {
                    font = this.abspath(availableFontFileNames[1], n, n2);
                    break;
                }
                font = this.abspath(availableFontFileNames[0], n, n2);
                break;
            }
            case 4: {
                font = JavaFontLoader.is(n2, 4) ? this.abspath(availableFontFileNames[7], n, n2) : this.abspath(availableFontFileNames[6], n, n2);
            }
        }
        return font;
    }

    Font abspath(String string, int n, int n2) throws IOException {
        if (null == this.javaFontPath) {
            throw new GLException("java font path undefined");
        }
        String string2 = "Problem loading font " + string + ", file " + this.javaFontPath + string;
        try {
            Font font = FontFactory.get(new File(this.javaFontPath + string));
            if (null != font) {
                fontMap.put(n << 8 | n2, font);
                return font;
            }
            throw new IOException(string2);
        }
        catch (IOException iOException) {
            throw new IOException(string2, iOException);
        }
    }
}

