/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import jogamp.graph.font.FontInt;
import jogamp.graph.font.typecast.TypecastGlyph;
import jogamp.graph.font.typecast.TypecastHMetrics;
import jogamp.graph.font.typecast.TypecastRenderer;
import jogamp.graph.font.typecast.ot.OTFont;
import jogamp.graph.font.typecast.ot.OTFontCollection;
import jogamp.graph.font.typecast.ot.OTGlyph;
import jogamp.graph.font.typecast.ot.table.CmapFormat;
import jogamp.graph.font.typecast.ot.table.CmapIndexEntry;
import jogamp.graph.font.typecast.ot.table.CmapTable;
import jogamp.graph.font.typecast.ot.table.HdmxTable;
import jogamp.graph.geom.plane.AffineTransform;
import jogamp.graph.geom.plane.Path2D;

class TypecastFont
implements FontInt {
    static final boolean DEBUG = false;
    final OTFontCollection fontset;
    final OTFont font;
    TypecastHMetrics metrics;
    final CmapFormat cmapFormat;
    int cmapentries;
    IntObjectHashMap char2Glyph;

    public TypecastFont(OTFontCollection oTFontCollection) {
        Object object;
        int n;
        this.fontset = oTFontCollection;
        this.font = oTFontCollection.getFont(0);
        CmapTable cmapTable = this.font.getCmapTable();
        CmapFormat[] cmapFormatArray = new CmapFormat[]{null, null, null, null};
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (n = 0; n < cmapTable.getNumTables(); ++n) {
            object = cmapTable.getCmapIndexEntry(n);
            int n5 = ((CmapIndexEntry)object).getPlatformId();
            CmapFormat cmapFormat = ((CmapIndexEntry)object).getFormat();
            if (cmapFormatArray[n5] != null && cmapFormatArray[n5].getLength() >= cmapFormat.getLength()) continue;
            cmapFormatArray[n5] = cmapFormat;
            if (cmapFormat.getLength() <= n3) continue;
            n3 = cmapFormat.getLength();
            n2 = n5;
            n4 = ((CmapIndexEntry)object).getEncodingId();
        }
        if (0 <= n2) {
            this.cmapFormat = cmapFormatArray[n2];
        } else {
            CmapFormat cmapFormat = null;
            if (null == cmapFormat) {
                n2 = 3;
                n4 = 1;
                cmapFormat = cmapTable.getCmapFormat((short)n2, (short)n4);
            }
            if (null == cmapFormat) {
                n2 = 3;
                n4 = 0;
                cmapFormat = cmapTable.getCmapFormat((short)n2, (short)n4);
            }
            if (null == cmapFormat) {
                throw new RuntimeException("Cannot find a suitable cmap table for font " + this.font);
            }
            this.cmapFormat = cmapFormat;
        }
        this.cmapentries = 0;
        for (n = 0; n < this.cmapFormat.getRangeCount(); ++n) {
            object = this.cmapFormat.getRange(n);
            this.cmapentries += ((CmapFormat.Range)object).getEndCode() - ((CmapFormat.Range)object).getStartCode() + 1;
        }
        this.char2Glyph = new IntObjectHashMap(this.cmapentries + this.cmapentries / 4);
    }

    @Override
    public StringBuilder getName(StringBuilder stringBuilder, int n) {
        return this.font.getName(n, stringBuilder);
    }

    @Override
    public String getName(int n) {
        return this.getName(null, n).toString();
    }

    @Override
    public StringBuilder getAllNames(StringBuilder stringBuilder, String string) {
        return this.font.getAllNames(stringBuilder, string);
    }

    @Override
    public StringBuilder getFullFamilyName(StringBuilder stringBuilder) {
        stringBuilder = this.getName(stringBuilder, 1).append("-");
        this.getName(stringBuilder, 2);
        return stringBuilder;
    }

    @Override
    public float getAdvanceWidth(int n, float f) {
        return (float)this.font.getHmtxTable().getAdvanceWidth(n) * this.metrics.getScale(f);
    }

    @Override
    public Font.Metrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = new TypecastHMetrics(this);
        }
        return this.metrics;
    }

    @Override
    public Font.Glyph getGlyph(char c) {
        TypecastGlyph typecastGlyph = (TypecastGlyph)this.char2Glyph.get(c);
        if (null == typecastGlyph) {
            OTGlyph oTGlyph;
            short s = (short)this.cmapFormat.mapCharCode(c);
            if (0 == s && '\u0000' != c) {
                switch (c) {
                    case ' ': {
                        s = 3;
                        break;
                    }
                    case '\n': {
                        s = 2;
                        break;
                    }
                    default: {
                        s = 0;
                    }
                }
            }
            if (null == (oTGlyph = this.font.getGlyph(s))) {
                oTGlyph = this.font.getGlyph(0);
            }
            if (null == oTGlyph) {
                throw new RuntimeException("Could not retrieve glyph for symbol: <" + c + "> " + c + " -> glyph id " + s);
            }
            Path2D path2D = TypecastRenderer.buildPath(oTGlyph);
            typecastGlyph = new TypecastGlyph(this, c, s, oTGlyph.getBBox(), oTGlyph.getAdvanceWidth(), path2D);
            HdmxTable hdmxTable = this.font.getHdmxTable();
            if (null != typecastGlyph && null != hdmxTable) {
                for (int i = 0; i < hdmxTable.getNumberOfRecords(); ++i) {
                    HdmxTable.DeviceRecord deviceRecord = hdmxTable.getRecord(i);
                    typecastGlyph.addAdvance(deviceRecord.getWidth(s), deviceRecord.getPixelSize());
                }
            }
            this.char2Glyph.put(c, typecastGlyph);
        }
        return typecastGlyph;
    }

    @Override
    public ArrayList<OutlineShape> getOutlineShapes(CharSequence charSequence, float f, Vertex.Factory<? extends Vertex> factory) {
        AffineTransform affineTransform = new AffineTransform(factory);
        return TypecastRenderer.getOutlineShapes(this, charSequence, f, affineTransform, factory);
    }

    @Override
    public float getStringWidth(CharSequence charSequence, float f) {
        float f2 = 0.0f;
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                f2 = 0.0f;
                continue;
            }
            Font.Glyph glyph = this.getGlyph(c);
            f2 += glyph.getAdvance(f, false);
        }
        return (int)(f2 + 0.5f);
    }

    @Override
    public float getStringHeight(CharSequence charSequence, float f) {
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == ' ') continue;
            Font.Glyph glyph = this.getGlyph(c);
            AABBox aABBox = glyph.getBBox(f);
            n = (int)Math.ceil(Math.max(aABBox.getHeight(), (float)n));
        }
        return n;
    }

    @Override
    public AABBox getStringBounds(CharSequence charSequence, float f) {
        if (charSequence == null) {
            return new AABBox();
        }
        Font.Metrics metrics = this.getMetrics();
        float f2 = metrics.getLineGap(f);
        float f3 = metrics.getAscent(f);
        float f4 = metrics.getDescent(f);
        float f5 = f2 - f4 + f3;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                f7 = Math.max(f8, f7);
                f8 = 0.0f;
                f6 -= f5;
                continue;
            }
            Font.Glyph glyph = this.getGlyph(c);
            f8 += glyph.getAdvance(f, true);
        }
        if (f8 > 0.0f) {
            f6 -= f5;
            f7 = Math.max(f8, f7);
        }
        return new AABBox(0.0f, 0.0f, 0.0f, f7, f6, 0.0f);
    }

    @Override
    public final int getNumGlyphs() {
        return this.font.getNumGlyphs();
    }

    @Override
    public boolean isPrintableChar(char c) {
        return FontFactory.isPrintableChar(c);
    }

    @Override
    public String toString() {
        return this.getFullFamilyName(null).toString();
    }
}

