/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.math.FloatUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.fixedfunc.GLMatrixFunc;

public class ProjectFloat {
    private final float[] matrix = new float[16];
    private final float[][] tempInvertMatrix = new float[4][4];
    private final float[] in = new float[4];
    private final float[] out = new float[4];
    private FloatBuffer matrixBuf;
    private final float[] forward = new float[3];
    private final float[] side = new float[3];
    private final float[] up = new float[3];

    public static final int getRequiredFloatBufferSize() {
        return 16;
    }

    public ProjectFloat() {
        this(true);
    }

    public ProjectFloat(boolean bl) {
        this(bl ? null : Buffers.newDirectByteBuffer(ProjectFloat.getRequiredFloatBufferSize() * 4), bl ? new float[ProjectFloat.getRequiredFloatBufferSize()] : null, 0);
    }

    public ProjectFloat(Buffer buffer, float[] fArray, int n) {
        this.matrixBuf = Buffers.slice2Float(buffer, fArray, n, 16);
    }

    public void destroy() {
        this.matrixBuf = null;
    }

    public boolean gluInvertMatrixf(float[] fArray, int n, float[] fArray2, int n2) {
        int n3;
        int n4;
        float[][] fArray3 = this.tempInvertMatrix;
        for (n4 = 0; n4 < 4; ++n4) {
            for (n3 = 0; n3 < 4; ++n3) {
                fArray3[n4][n3] = fArray[n4 * 4 + n3 + n];
            }
        }
        FloatUtil.makeIdentityf(fArray2, n2);
        for (n4 = 0; n4 < 4; ++n4) {
            float f;
            int n5;
            int n6 = n4;
            for (n3 = n4 + 1; n3 < 4; ++n3) {
                if (!(Math.abs(fArray3[n3][n4]) > Math.abs(fArray3[n4][n4]))) continue;
                n6 = n3;
            }
            if (n6 != n4) {
                for (n5 = 0; n5 < 4; ++n5) {
                    f = fArray3[n4][n5];
                    fArray3[n4][n5] = fArray3[n6][n5];
                    fArray3[n6][n5] = f;
                    f = fArray2[n4 * 4 + n5 + n2];
                    fArray2[n4 * 4 + n5 + n2] = fArray2[n6 * 4 + n5 + n2];
                    fArray2[n6 * 4 + n5 + n2] = f;
                }
            }
            if (fArray3[n4][n4] == 0.0f) {
                return false;
            }
            f = fArray3[n4][n4];
            for (n5 = 0; n5 < 4; ++n5) {
                float[] fArray4 = fArray3[n4];
                int n7 = n5;
                fArray4[n7] = fArray4[n7] / f;
                int n8 = n4 * 4 + n5 + n2;
                fArray2[n8] = fArray2[n8] / f;
            }
            for (n3 = 0; n3 < 4; ++n3) {
                if (n3 == n4) continue;
                f = fArray3[n3][n4];
                for (n5 = 0; n5 < 4; ++n5) {
                    float[] fArray5 = fArray3[n3];
                    int n9 = n5;
                    fArray5[n9] = fArray5[n9] - fArray3[n4][n5] * f;
                    int n10 = n3 * 4 + n5 + n2;
                    fArray2[n10] = fArray2[n10] - fArray2[n4 * 4 + n5 + n2] * f;
                }
            }
        }
        return true;
    }

    public boolean gluInvertMatrixf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        int n;
        int n2;
        int n3 = floatBuffer.position();
        int n4 = floatBuffer2.position();
        float[][] fArray = this.tempInvertMatrix;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                fArray[n2][n] = floatBuffer.get(n2 * 4 + n + n3);
            }
        }
        FloatUtil.makeIdentityf(floatBuffer2);
        for (n2 = 0; n2 < 4; ++n2) {
            int n5;
            float f;
            int n6;
            int n7 = n2;
            for (n = n2 + 1; n < 4; ++n) {
                if (!(Math.abs(fArray[n][n2]) > Math.abs(fArray[n2][n2]))) continue;
                n7 = n;
            }
            if (n7 != n2) {
                for (n6 = 0; n6 < 4; ++n6) {
                    f = fArray[n2][n6];
                    fArray[n2][n6] = fArray[n7][n6];
                    fArray[n7][n6] = f;
                    f = floatBuffer2.get(n2 * 4 + n6 + n4);
                    floatBuffer2.put(n2 * 4 + n6 + n4, floatBuffer2.get(n7 * 4 + n6 + n4));
                    floatBuffer2.put(n7 * 4 + n6 + n4, f);
                }
            }
            if (fArray[n2][n2] == 0.0f) {
                return false;
            }
            f = fArray[n2][n2];
            for (n6 = 0; n6 < 4; ++n6) {
                float[] fArray2 = fArray[n2];
                int n8 = n6;
                fArray2[n8] = fArray2[n8] / f;
                n5 = n2 * 4 + n6 + n4;
                floatBuffer2.put(n5, floatBuffer2.get(n5) / f);
            }
            for (n = 0; n < 4; ++n) {
                if (n == n2) continue;
                f = fArray[n][n2];
                for (n6 = 0; n6 < 4; ++n6) {
                    float[] fArray3 = fArray[n];
                    int n9 = n6;
                    fArray3[n9] = fArray3[n9] - fArray[n2][n6] * f;
                    n5 = n * 4 + n6 + n4;
                    floatBuffer2.put(n5, floatBuffer2.get(n5) - floatBuffer2.get(n2 * 4 + n6 + n4) * f);
                }
            }
        }
        return true;
    }

    public void gluOrtho2D(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4) {
        gLMatrixFunc.glOrthof(f, f2, f3, f4, -1.0f, 1.0f);
    }

    public void gluPerspective(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4) {
        float f5 = f / 2.0f * (float)Math.PI / 180.0f;
        float f6 = f4 - f3;
        float f7 = (float)Math.sin(f5);
        if (f6 == 0.0f || f7 == 0.0f || f2 == 0.0f) {
            return;
        }
        float f8 = (float)Math.cos(f5) / f7;
        FloatUtil.makeIdentityf(this.matrixBuf);
        int n = this.matrixBuf.position();
        this.matrixBuf.put(0 + n, f8 / f2);
        this.matrixBuf.put(5 + n, f8);
        this.matrixBuf.put(10 + n, -(f4 + f3) / f6);
        this.matrixBuf.put(11 + n, -1.0f);
        this.matrixBuf.put(14 + n, -2.0f * f3 * f4 / f6);
        this.matrixBuf.put(15 + n, 0.0f);
        gLMatrixFunc.glMultMatrixf(this.matrixBuf);
    }

    public void gluLookAt(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float[] fArray = this.forward;
        float[] fArray2 = this.side;
        float[] fArray3 = this.up;
        fArray[0] = f4 - f;
        fArray[1] = f5 - f2;
        fArray[2] = f6 - f3;
        fArray3[0] = f7;
        fArray3[1] = f8;
        fArray3[2] = f9;
        FloatUtil.normalize(fArray);
        FloatUtil.cross(fArray, fArray3, fArray2);
        FloatUtil.normalize(fArray2);
        FloatUtil.cross(fArray2, fArray, fArray3);
        FloatUtil.makeIdentityf(this.matrixBuf);
        int n = this.matrixBuf.position();
        this.matrixBuf.put(0 + n, fArray2[0]);
        this.matrixBuf.put(4 + n, fArray2[1]);
        this.matrixBuf.put(8 + n, fArray2[2]);
        this.matrixBuf.put(1 + n, fArray3[0]);
        this.matrixBuf.put(5 + n, fArray3[1]);
        this.matrixBuf.put(9 + n, fArray3[2]);
        this.matrixBuf.put(2 + n, -fArray[0]);
        this.matrixBuf.put(6 + n, -fArray[1]);
        this.matrixBuf.put(10 + n, -fArray[2]);
        gLMatrixFunc.glMultMatrixf(this.matrixBuf);
        gLMatrixFunc.glTranslatef(-f, -f2, -f3);
    }

    public boolean gluProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = 1.0f;
        FloatUtil.multMatrixVecf(fArray, n, fArray4, 0, fArray5, 0);
        FloatUtil.multMatrixVecf(fArray2, n2, fArray5, 0, fArray4, 0);
        if (fArray4[3] == 0.0f) {
            return false;
        }
        fArray4[3] = 1.0f / fArray4[3] * 0.5f;
        fArray4[0] = fArray4[0] * fArray4[3] + 0.5f;
        fArray4[1] = fArray4[1] * fArray4[3] + 0.5f;
        fArray4[2] = fArray4[2] * fArray4[3] + 0.5f;
        fArray3[0 + n4] = fArray4[0] * (float)nArray[2 + n3] + (float)nArray[0 + n3];
        fArray3[1 + n4] = fArray4[1] * (float)nArray[3 + n3] + (float)nArray[1 + n3];
        fArray3[2 + n4] = fArray4[2];
        return true;
    }

    public boolean gluProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int n, float[] fArray, int n2) {
        float[] fArray2 = this.in;
        float[] fArray3 = this.out;
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        fArray2[3] = 1.0f;
        FloatUtil.multMatrixVecf(floatBuffer, fArray2, fArray3);
        FloatUtil.multMatrixVecf(floatBuffer2, fArray3, fArray2);
        if (fArray2[3] == 0.0f) {
            return false;
        }
        fArray2[3] = 1.0f / fArray2[3] * 0.5f;
        fArray2[0] = fArray2[0] * fArray2[3] + 0.5f;
        fArray2[1] = fArray2[1] * fArray2[3] + 0.5f;
        fArray2[2] = fArray2[2] * fArray2[3] + 0.5f;
        fArray[0 + n2] = fArray2[0] * (float)nArray[2 + n] + (float)nArray[0 + n];
        fArray[1 + n2] = fArray2[1] * (float)nArray[3 + n] + (float)nArray[1 + n];
        fArray[2 + n2] = fArray2[2];
        return true;
    }

    public boolean gluProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        float[] fArray = this.in;
        float[] fArray2 = this.out;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = 1.0f;
        FloatUtil.multMatrixVecf(floatBuffer, fArray, fArray2);
        FloatUtil.multMatrixVecf(floatBuffer2, fArray2, fArray);
        if (fArray[3] == 0.0f) {
            return false;
        }
        fArray[3] = 1.0f / fArray[3] * 0.5f;
        fArray[0] = fArray[0] * fArray[3] + 0.5f;
        fArray[1] = fArray[1] * fArray[3] + 0.5f;
        fArray[2] = fArray[2] * fArray[3] + 0.5f;
        int n = intBuffer.position();
        int n2 = floatBuffer3.position();
        floatBuffer3.put(0 + n2, fArray[0] * (float)intBuffer.get(2 + n) + (float)intBuffer.get(0 + n));
        floatBuffer3.put(1 + n2, fArray[1] * (float)intBuffer.get(3 + n) + (float)intBuffer.get(1 + n));
        floatBuffer3.put(2 + n2, fArray[2]);
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        FloatUtil.multMatrixf(fArray2, n2, fArray, n, this.matrix, 0);
        if (!this.gluInvertMatrixf(this.matrix, 0, this.matrix, 0)) {
            return false;
        }
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = 1.0f;
        fArray4[0] = (fArray4[0] - (float)nArray[0 + n3]) / (float)nArray[2 + n3];
        fArray4[1] = (fArray4[1] - (float)nArray[1 + n3]) / (float)nArray[3 + n3];
        fArray4[0] = fArray4[0] * 2.0f - 1.0f;
        fArray4[1] = fArray4[1] * 2.0f - 1.0f;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVecf(this.matrix, fArray4, fArray5);
        if ((double)fArray5[3] == 0.0) {
            return false;
        }
        fArray5[3] = 1.0f / fArray5[3];
        fArray3[0 + n4] = fArray5[0] * fArray5[3];
        fArray3[1 + n4] = fArray5[1] * fArray5[3];
        fArray3[2 + n4] = fArray5[2] * fArray5[3];
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int n, float[] fArray, int n2) {
        float[] fArray2 = this.in;
        float[] fArray3 = this.out;
        FloatUtil.multMatrixf(floatBuffer2, floatBuffer, this.matrixBuf);
        if (!this.gluInvertMatrixf(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        fArray2[3] = 1.0f;
        fArray2[0] = (fArray2[0] - (float)nArray[0 + n]) / (float)nArray[2 + n];
        fArray2[1] = (fArray2[1] - (float)nArray[1 + n]) / (float)nArray[3 + n];
        fArray2[0] = fArray2[0] * 2.0f - 1.0f;
        fArray2[1] = fArray2[1] * 2.0f - 1.0f;
        fArray2[2] = fArray2[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVecf(this.matrixBuf, fArray2, fArray3);
        if ((double)fArray3[3] == 0.0) {
            return false;
        }
        fArray3[3] = 1.0f / fArray3[3];
        fArray[0 + n2] = fArray3[0] * fArray3[3];
        fArray[1 + n2] = fArray3[1] * fArray3[3];
        fArray[2 + n2] = fArray3[2] * fArray3[3];
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        float[] fArray = this.in;
        float[] fArray2 = this.out;
        FloatUtil.multMatrixf(floatBuffer2, floatBuffer, this.matrixBuf);
        if (!this.gluInvertMatrixf(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = 1.0f;
        int n = intBuffer.position();
        int n2 = floatBuffer3.position();
        fArray[0] = (fArray[0] - (float)intBuffer.get(0 + n)) / (float)intBuffer.get(2 + n);
        fArray[1] = (fArray[1] - (float)intBuffer.get(1 + n)) / (float)intBuffer.get(3 + n);
        fArray[0] = fArray[0] * 2.0f - 1.0f;
        fArray[1] = fArray[1] * 2.0f - 1.0f;
        fArray[2] = fArray[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVecf(this.matrixBuf, fArray, fArray2);
        if ((double)fArray2[3] == 0.0) {
            return false;
        }
        fArray2[3] = 1.0f / fArray2[3];
        floatBuffer3.put(0 + n2, fArray2[0] * fArray2[3]);
        floatBuffer3.put(1 + n2, fArray2[1] * fArray2[3]);
        floatBuffer3.put(2 + n2, fArray2[2] * fArray2[3]);
        return true;
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float f5, float f6, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        FloatUtil.multMatrixf(fArray2, n2, fArray, n, this.matrix, 0);
        if (!this.gluInvertMatrixf(this.matrix, 0, this.matrix, 0)) {
            return false;
        }
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = f4;
        fArray4[0] = (fArray4[0] - (float)nArray[0 + n3]) / (float)nArray[2 + n3];
        fArray4[1] = (fArray4[1] - (float)nArray[1 + n3]) / (float)nArray[3 + n3];
        fArray4[2] = (fArray4[2] - f5) / (f6 - f5);
        fArray4[0] = fArray4[0] * 2.0f - 1.0f;
        fArray4[1] = fArray4[1] * 2.0f - 1.0f;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVecf(this.matrix, fArray4, fArray5);
        if (fArray5[3] == 0.0f) {
            return false;
        }
        fArray3[0 + n4] = fArray5[0];
        fArray3[1 + n4] = fArray5[1];
        fArray3[2 + n4] = fArray5[2];
        fArray3[3 + n4] = fArray5[3];
        return true;
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, float f5, float f6, FloatBuffer floatBuffer3) {
        float[] fArray = this.in;
        float[] fArray2 = this.out;
        FloatUtil.multMatrixf(floatBuffer2, floatBuffer, this.matrixBuf);
        if (!this.gluInvertMatrixf(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f4;
        int n = intBuffer.position();
        fArray[0] = (fArray[0] - (float)intBuffer.get(0 + n)) / (float)intBuffer.get(2 + n);
        fArray[1] = (fArray[1] - (float)intBuffer.get(1 + n)) / (float)intBuffer.get(3 + n);
        fArray[2] = (fArray[2] - f5) / (f6 - f5);
        fArray[0] = fArray[0] * 2.0f - 1.0f;
        fArray[1] = fArray[1] * 2.0f - 1.0f;
        fArray[2] = fArray[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVecf(this.matrixBuf, fArray, fArray2);
        if (fArray2[3] == 0.0f) {
            return false;
        }
        int n2 = floatBuffer3.position();
        floatBuffer3.put(0 + n2, fArray2[0]);
        floatBuffer3.put(1 + n2, fArray2[1]);
        floatBuffer3.put(2 + n2, fArray2[2]);
        floatBuffer3.put(3 + n2, fArray2[3]);
        return true;
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, IntBuffer intBuffer) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        int n = intBuffer.position();
        gLMatrixFunc.glTranslatef(((float)intBuffer.get(2 + n) - 2.0f * (f - (float)intBuffer.get(0 + n))) / f3, ((float)intBuffer.get(3 + n) - 2.0f * (f2 - (float)intBuffer.get(1 + n))) / f4, 0.0f);
        gLMatrixFunc.glScalef((float)intBuffer.get(2) / f3, (float)intBuffer.get(3) / f4, 1.0f);
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, int[] nArray, int n) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        gLMatrixFunc.glTranslatef(((float)nArray[2 + n] - 2.0f * (f - (float)nArray[0 + n])) / f3, ((float)nArray[3 + n] - 2.0f * (f2 - (float)nArray[1 + n])) / f4, 0.0f);
        gLMatrixFunc.glScalef((float)nArray[2 + n] / f3, (float)nArray[3 + n] / f4, 1.0f);
    }
}

