/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.GLWorkerThread;
import jogamp.opengl.ToolkitThreadingPlugin;

public class ThreadingImpl {
    protected static final boolean DEBUG = Debug.debug("Threading");
    private static boolean singleThreaded;
    private static Mode mode;
    private static boolean hasAWT;
    private static boolean _isX11;
    private static final ToolkitThreadingPlugin threadingPlugin;

    private ThreadingImpl() {
    }

    public static boolean isX11() {
        return _isX11;
    }

    public static Mode getMode() {
        return mode;
    }

    public static final void disableSingleThreading() {
        singleThreaded = false;
        if (Debug.verbose()) {
            System.err.println("Application forced disabling of single-threading of javax.media.opengl implementation");
        }
    }

    public static final boolean isSingleThreaded() {
        return singleThreaded;
    }

    public static final boolean isOpenGLThread() throws GLException {
        if (null != threadingPlugin) {
            return threadingPlugin.isOpenGLThread();
        }
        switch (mode) {
            case ST_AWT: {
                throw new InternalError();
            }
            case ST_WORKER: {
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + (Object)((Object)mode));
    }

    public static final boolean isToolkitThread() throws GLException {
        if (null != threadingPlugin) {
            return threadingPlugin.isToolkitThread();
        }
        return false;
    }

    public static final void invokeOnOpenGLThread(boolean bl, Runnable runnable) throws GLException {
        if (null != threadingPlugin) {
            threadingPlugin.invokeOnOpenGLThread(bl, runnable);
            return;
        }
        switch (mode) {
            case ST_WORKER: {
                ThreadingImpl.invokeOnWorkerThread(bl, runnable);
                break;
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + (Object)((Object)mode));
            }
        }
    }

    public static final void invokeOnWorkerThread(boolean bl, Runnable runnable) throws GLException {
        GLWorkerThread.start();
        try {
            GLWorkerThread.invoke(bl, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            throw new GLException(interruptedException);
        }
    }

    static {
        threadingPlugin = AccessController.doPrivileged(new PrivilegedAction<ToolkitThreadingPlugin>(){

            @Override
            public ToolkitThreadingPlugin run() {
                Object object = Debug.getProperty("jogl.1thread", true);
                String string = null != object ? ((String)object).toLowerCase() : null;
                object = ThreadingImpl.class.getClassLoader();
                hasAWT = GLProfile.isAWTAvailable();
                _isX11 = NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType(false);
                singleThreaded = true;
                ThreadingImpl.mode = hasAWT ? Mode.ST_AWT : Mode.ST_WORKER;
                if (string != null) {
                    if (string.equals("true") || string.equals("auto")) {
                        singleThreaded = true;
                        ThreadingImpl.mode = hasAWT ? Mode.ST_AWT : Mode.ST_WORKER;
                    } else if (string.equals("worker")) {
                        singleThreaded = true;
                        ThreadingImpl.mode = Mode.ST_WORKER;
                    } else if (hasAWT && string.equals("awt")) {
                        singleThreaded = true;
                        ThreadingImpl.mode = Mode.ST_AWT;
                    } else if (string.equals("false")) {
                        singleThreaded = false;
                        ThreadingImpl.mode = Mode.MT;
                    } else {
                        throw new RuntimeException("Unsupported value for property jogl.1thread: " + string + ", should be [true/auto, worker, awt or false]");
                    }
                }
                ToolkitThreadingPlugin toolkitThreadingPlugin = null;
                if (hasAWT) {
                    JogampRuntimeException jogampRuntimeException = null;
                    try {
                        toolkitThreadingPlugin = (ToolkitThreadingPlugin)ReflectionUtil.createInstance("jogamp.opengl.awt.AWTThreadingPlugin", (ClassLoader)object);
                    }
                    catch (JogampRuntimeException jogampRuntimeException2) {
                        jogampRuntimeException = jogampRuntimeException2;
                    }
                    if (Mode.ST_AWT == mode && null == toolkitThreadingPlugin) {
                        throw new GLException("Mode is AWT, but class 'jogamp.opengl.awt.AWTThreadingPlugin' is not available", jogampRuntimeException);
                    }
                }
                if (DEBUG) {
                    System.err.println("Threading: jogl.1thread " + string + ", singleThreaded " + singleThreaded + ", hasAWT " + hasAWT + ", mode " + (Object)((Object)mode) + ", plugin " + toolkitThreadingPlugin);
                }
                return toolkitThreadingPlugin;
            }
        });
    }

    public static enum Mode {
        MT(0),
        ST_AWT(1),
        ST_WORKER(2);

        public final int id;

        private Mode(int n2) {
            this.id = n2;
        }
    }
}

