/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import java.nio.IntBuffer;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLWrappedSurface;

public abstract class EGLDrawable
extends GLDrawableImpl {
    protected EGLDrawable(EGLDrawableFactory eGLDrawableFactory, NativeSurface nativeSurface) throws GLException {
        super(eGLDrawableFactory, nativeSurface, false);
    }

    @Override
    public abstract GLContext createContext(GLContext var1);

    protected abstract long createSurface(EGLGraphicsConfiguration var1, int var2, int var3, long var4);

    private final long createEGLSurface() {
        int n;
        EGLWrappedSurface eGLWrappedSurface = (EGLWrappedSurface)this.surface;
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)eGLWrappedSurface.getGraphicsConfiguration();
        NativeSurface nativeSurface = eGLWrappedSurface.getUpstreamSurface();
        long l = this.createSurface(eGLGraphicsConfiguration, eGLWrappedSurface.getWidth(), eGLWrappedSurface.getHeight(), nativeSurface.getSurfaceHandle());
        if (0L == l) {
            NativeWindow nativeWindow;
            n = EGL.eglGetError();
            if (12299 == n && nativeSurface instanceof NativeWindow && (nativeWindow = (NativeWindow)nativeSurface).getWindowHandle() != nativeWindow.getSurfaceHandle()) {
                if (DEBUG) {
                    System.err.println(EGLDrawable.getThreadName() + ": Info: Creation of window surface w/ surface handle failed: " + eGLGraphicsConfiguration + ", error " + EGLDrawable.toHexString(n) + ", retry w/ windowHandle");
                }
                if (0L == (l = this.createSurface(eGLGraphicsConfiguration, eGLWrappedSurface.getWidth(), eGLWrappedSurface.getHeight(), nativeWindow.getWindowHandle()))) {
                    n = EGL.eglGetError();
                }
            }
        } else {
            n = 12288;
        }
        if (0L == l) {
            throw new GLException("Creation of window surface failed: " + eGLGraphicsConfiguration + ", " + this.surface + ", error " + EGLDrawable.toHexString(n));
        }
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": createEGLSurface handle " + EGLDrawable.toHexString(l));
        }
        return l;
    }

    @Override
    protected final void createHandle() {
        EGLWrappedSurface eGLWrappedSurface = (EGLWrappedSurface)this.surface;
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": createHandle of " + eGLWrappedSurface);
        }
        if (eGLWrappedSurface.containsUpstreamOptionBits(64)) {
            if (0L != eGLWrappedSurface.getSurfaceHandle()) {
                throw new InternalError("Set surface but claimed to be invalid: " + eGLWrappedSurface);
            }
            eGLWrappedSurface.setSurfaceHandle(this.createEGLSurface());
        } else if (0L == eGLWrappedSurface.getSurfaceHandle()) {
            throw new InternalError("Nil surface but claimed to be valid: " + eGLWrappedSurface);
        }
    }

    @Override
    protected void destroyHandle() {
        EGLWrappedSurface eGLWrappedSurface = (EGLWrappedSurface)this.surface;
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": destroyHandle of " + eGLWrappedSurface);
        }
        if (0L == eGLWrappedSurface.getSurfaceHandle()) {
            throw new InternalError("Nil surface but claimed to be valid: " + eGLWrappedSurface);
        }
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLWrappedSurface.getGraphicsConfiguration().getScreen().getDevice();
        if (eGLWrappedSurface.containsUpstreamOptionBits(64)) {
            EGL.eglDestroySurface(eGLGraphicsDevice.getHandle(), eGLWrappedSurface.getSurfaceHandle());
            eGLWrappedSurface.setSurfaceHandle(0L);
        }
    }

    protected static boolean isValidEGLSurface(long l, long l2) {
        if (0L == l2) {
            return false;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        boolean bl = EGL.eglQuerySurface(l, l2, 12328, intBuffer);
        if (!bl) {
            int n = EGL.eglGetError();
            if (DEBUG) {
                System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.isValidEGLSurface eglQuerySuface failed: error " + EGLDrawable.toHexString(n) + ", " + EGLDrawable.toHexString(l2));
            }
        }
        return bl;
    }

    @Override
    protected final void setRealizedImpl() {
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealized(" + this.realized + "): NOP - " + this.surface);
        }
    }

    @Override
    protected final void swapBuffersImpl(boolean bl) {
        EGLGraphicsDevice eGLGraphicsDevice;
        if (bl && !EGL.eglSwapBuffers((eGLGraphicsDevice = (EGLGraphicsDevice)this.surface.getGraphicsConfiguration().getScreen().getDevice()).getHandle(), this.surface.getSurfaceHandle())) {
            throw new GLException("Error swapping buffers, eglError " + EGLDrawable.toHexString(EGL.eglGetError()) + ", " + this);
        }
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper() {
        if (this.getGLProfile().usesNativeGLES3()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(3);
        }
        if (this.getGLProfile().usesNativeGLES2()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(2);
        }
        if (this.getGLProfile().usesNativeGLES1()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(1);
        }
        throw new GLException("Unsupported: " + this.getGLProfile());
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[realized " + this.isRealized() + ",\n\tfactory    " + this.getFactory() + ",\n\tsurface    " + this.getNativeSurface() + ",\n\teglSurface " + EGLDrawable.toHexString(this.surface.getSurfaceHandle()) + ",\n\teglConfig  " + this.surface.getGraphicsConfiguration() + ",\n\trequested  " + this.getRequestedGLCapabilities() + ",\n\tchosen     " + this.getChosenGLCapabilities() + "]";
    }
}

