/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.windows.DWM_BLURBEHIND;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.windows.MARGINS;
import jogamp.nativewindow.windows.PIXELFORMATDESCRIPTOR;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.windows.wgl.WGLExt;
import jogamp.opengl.windows.wgl.WGLGLCapabilities;
import jogamp.opengl.windows.wgl.WGLUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsWGLGraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;
    private final GLCapabilitiesChooser chooser;
    private boolean isDetermined = false;
    private boolean isExternal = false;

    WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable2);
        this.chooser = gLCapabilitiesChooser;
        this.isDetermined = false;
    }

    WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, WGLGLCapabilities wGLGLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        super(abstractGraphicsScreen, wGLGLCapabilities, gLCapabilitiesImmutable);
        this.setCapsPFD(wGLGLCapabilities);
        this.chooser = null;
    }

    static WindowsWGLGraphicsConfiguration createFromExternal(GLDrawableFactory gLDrawableFactory, long l, int n, GLProfile gLProfile, AbstractGraphicsScreen abstractGraphicsScreen, boolean bl) {
        AbstractGraphicsDevice abstractGraphicsDevice;
        WindowsWGLDrawableFactory windowsWGLDrawableFactory;
        WindowsWGLDrawableFactory.SharedResource sharedResource;
        if (gLDrawableFactory == null) {
            throw new GLException("Null factory");
        }
        if (l == 0L) {
            throw new GLException("Null HDC");
        }
        if (n <= 0) {
            throw new GLException("Invalid pixelformat id " + n);
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.getDefault(abstractGraphicsScreen.getDevice());
        }
        boolean bl2 = null != (sharedResource = (windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)gLDrawableFactory).getOrCreateSharedResourceImpl(abstractGraphicsDevice = abstractGraphicsScreen.getDevice())) && sharedResource.hasARBPixelFormat();
        WGLGLCapabilities wGLGLCapabilities = null;
        wGLGLCapabilities = bl2 ? WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, abstractGraphicsDevice, gLProfile, l, n, 15) : WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(abstractGraphicsDevice, gLProfile, l, n, 15);
        if (null == wGLGLCapabilities) {
            throw new GLException("Couldn't choose Capabilities by: HDC 0x" + Long.toHexString(l) + ", pfdID " + n + ", onscreen " + bl + ", hasARB " + bl2);
        }
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, wGLGLCapabilities, wGLGLCapabilities);
        windowsWGLGraphicsConfiguration.markExternal();
        return windowsWGLGraphicsConfiguration;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public final void updateGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, int[] nArray) {
        WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(this.chooser, gLDrawableFactory, nativeSurface, nArray);
    }

    public final void preselectGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, int[] nArray) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.getScreen().getDevice();
        WindowsWGLGraphicsConfigurationFactory.preselectGraphicsConfiguration(this.chooser, gLDrawableFactory, abstractGraphicsDevice, this, nArray);
    }

    final void setPixelFormat(long l, WGLGLCapabilities wGLGLCapabilities) {
        if (0L == l) {
            throw new GLException("Error: HDC is null");
        }
        if (!WGLUtil.SetPixelFormat(l, wGLGLCapabilities.getPFDID(), wGLGLCapabilities.getPFD())) {
            throw new GLException("Unable to set pixel format " + wGLGLCapabilities.getPFDID() + " of " + wGLGLCapabilities + " for device context " + WindowsWGLGraphicsConfiguration.toHexString(l) + ": error code " + GDI.GetLastError());
        }
        if (!wGLGLCapabilities.isBackgroundOpaque()) {
            long l2 = GDI.WindowFromDC(l);
            DWM_BLURBEHIND dWM_BLURBEHIND = DWM_BLURBEHIND.create();
            dWM_BLURBEHIND.setDwFlags(5);
            dWM_BLURBEHIND.setFEnable(1);
            boolean bl = GDI.DwmEnableBlurBehindWindow(l2, dWM_BLURBEHIND);
            if (bl) {
                MARGINS mARGINS = MARGINS.create();
                mARGINS.setCxLeftWidth(-1);
                mARGINS.setCxRightWidth(-1);
                mARGINS.setCyBottomHeight(-1);
                mARGINS.setCyTopHeight(-1);
                bl = GDI.DwmExtendFrameIntoClientArea(l2, mARGINS);
            }
            if (DEBUG) {
                boolean bl2 = GDIUtil.IsUndecorated(l2);
                boolean bl3 = GDIUtil.IsChild(l2);
                System.err.println("translucency enabled on wnd: 0x" + Long.toHexString(l2) + " - isUndecorated " + bl2 + ", isChild " + bl3 + ", ok: " + bl);
            }
        }
        if (DEBUG) {
            System.err.println("setPixelFormat: hdc " + WindowsWGLGraphicsConfiguration.toHexString(l) + ", " + wGLGLCapabilities);
        }
        this.setCapsPFD(wGLGLCapabilities);
    }

    final void setCapsPFD(WGLGLCapabilities wGLGLCapabilities) {
        this.setChosenCapabilities(wGLGLCapabilities);
        this.isDetermined = true;
        if (DEBUG) {
            System.err.println("*** setCapsPFD: " + wGLGLCapabilities);
        }
    }

    public final boolean isExternal() {
        return this.isExternal;
    }

    final void markExternal() {
        this.isExternal = true;
    }

    public final boolean isDetermined() {
        return this.isDetermined;
    }

    public final PIXELFORMATDESCRIPTOR getPixelFormat() {
        return this.isDetermined ? ((WGLGLCapabilities)this.capabilitiesChosen).getPFD() : null;
    }

    public final int getPixelFormatID() {
        return this.isDetermined ? ((WGLGLCapabilities)this.capabilitiesChosen).getPFDID() : 0;
    }

    public final boolean isChoosenByARB() {
        return this.isDetermined ? ((WGLGLCapabilities)this.capabilitiesChosen).isSetByARB() : false;
    }

    static int fillAttribsForGeneralWGLARBQuery(WindowsWGLDrawableFactory.SharedResource sharedResource, IntBuffer intBuffer) {
        int n = 0;
        intBuffer.put(n++, 8193);
        if (sharedResource.hasARBPBuffer()) {
            intBuffer.put(n++, 8237);
        }
        intBuffer.put(n++, 8194);
        intBuffer.put(n++, 8195);
        intBuffer.put(n++, 8208);
        intBuffer.put(n++, 8226);
        intBuffer.put(n++, 8227);
        intBuffer.put(n++, 8209);
        intBuffer.put(n++, 8210);
        intBuffer.put(n++, 8211);
        intBuffer.put(n++, 8213);
        intBuffer.put(n++, 8215);
        intBuffer.put(n++, 8217);
        intBuffer.put(n++, 8219);
        intBuffer.put(n++, 8222);
        intBuffer.put(n++, 8223);
        intBuffer.put(n++, 8224);
        intBuffer.put(n++, 8225);
        if (sharedResource.hasARBMultisample()) {
            intBuffer.put(n++, 8257);
            intBuffer.put(n++, 8258);
        }
        return n;
    }

    static boolean wglARBPFIDValid(WindowsWGLContext windowsWGLContext, long l, int n) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(1);
        intBuffer2.put(0, 8212);
        if (!windowsWGLContext.getWGLExt().wglGetPixelFormatAttribivARB(l, n, 0, 1, intBuffer2, intBuffer)) {
            return GDI.GetLastError() == 0;
        }
        return true;
    }

    static int wglARBPFDIDCount(WindowsWGLContext windowsWGLContext, long l) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(1);
        intBuffer2.put(0, 8192);
        WGLExt wGLExt = windowsWGLContext.getWGLExt();
        if (!wGLExt.wglGetPixelFormatAttribivARB(l, 1, 0, 1, intBuffer2, intBuffer)) {
            if (DEBUG) {
                System.err.println("GetPixelFormatAttribivARB: Failed - HDC 0x" + Long.toHexString(l) + ", value " + intBuffer.get(0) + ", LastError: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return 0;
        }
        int n = intBuffer.get(0);
        if (0 == n && DEBUG) {
            System.err.println("GetPixelFormatAttribivARB: No formats - HDC 0x" + Long.toHexString(l) + ", LastError: " + GDI.GetLastError());
            Thread.dumpStack();
        }
        return n;
    }

    static int[] wglAllARBPFDIDs(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1 + i;
        }
        return nArray;
    }

    static WGLGLCapabilities wglARBPFID2GLCapabilities(WindowsWGLDrawableFactory.SharedResource sharedResource, AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l, int n, int n2) {
        if (!sharedResource.hasARBPixelFormat()) {
            return null;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(512);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(512);
        int n3 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(sharedResource, intBuffer);
        if (!((WindowsWGLContext)sharedResource.getContext()).getWGLExt().wglGetPixelFormatAttribivARB(l, n, 0, n3, intBuffer, intBuffer2)) {
            throw new GLException("wglARBPFID2GLCapabilities: Error getting pixel format attributes for pixel format " + n + " of device context " + WindowsWGLGraphicsConfiguration.toHexString(l) + ", werr " + GDI.GetLastError());
        }
        return WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(abstractGraphicsDevice, gLProfile, l, n, intBuffer, n3, intBuffer2, n2);
    }

    static int[] wglChoosePixelFormatARB(WindowsWGLDrawableFactory.SharedResource sharedResource, AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, long l, IntBuffer intBuffer, int n, FloatBuffer floatBuffer) {
        int[] nArray;
        IntBuffer intBuffer2;
        IntBuffer intBuffer3;
        if (!WindowsWGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, intBuffer, sharedResource, n, null)) {
            if (DEBUG) {
                System.err.println("wglChoosePixelFormatARB: GLCapabilities2AttribList failed: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        WGLExt wGLExt = ((WindowsWGLContext)sharedResource.getContext()).getWGLExt();
        if (!wGLExt.wglChoosePixelFormatARB(l, intBuffer, floatBuffer, 256, intBuffer3 = Buffers.newDirectIntBuffer(256), intBuffer2 = Buffers.newDirectIntBuffer(1))) {
            if (DEBUG) {
                System.err.println("wglChoosePixelFormatARB: wglChoosePixelFormatARB failed: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int n2 = Math.min(intBuffer2.get(0), 256);
        if (0 < n2) {
            nArray = new int[n2];
            intBuffer3.get(nArray, 0, n2);
        } else {
            nArray = null;
        }
        if (DEBUG) {
            System.err.println("wglChoosePixelFormatARB: NumFormats (wglChoosePixelFormatARB) accelMode 0x" + Integer.toHexString(n) + ": " + n2);
            for (int i = 0; i < n2; ++i) {
                WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, abstractGraphicsDevice, gLCapabilitiesImmutable.getGLProfile(), l, nArray[i], 15);
                System.err.println("pixel format " + nArray[i] + " (index " + i + "): " + wGLGLCapabilities);
            }
        }
        return nArray;
    }

    static List<GLCapabilitiesImmutable> wglARBPFIDs2GLCapabilities(WindowsWGLDrawableFactory.SharedResource sharedResource, AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l, int[] nArray, int n, boolean bl) {
        if (!sharedResource.hasARBPixelFormat()) {
            return null;
        }
        int n2 = nArray.length;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(512);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(512);
        int n3 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(sharedResource, intBuffer);
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] >= 1 && ((WindowsWGLContext)sharedResource.getContext()).getWGLExt().wglGetPixelFormatAttribivARB(l, nArray[i], 0, n3, intBuffer, intBuffer2)) {
                WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(abstractGraphicsDevice, gLProfile, l, nArray[i], intBuffer, n3, intBuffer2, n);
                if (null != wGLGLCapabilities) {
                    arrayList.add(wGLGLCapabilities);
                    if (DEBUG) {
                        int n4 = arrayList.size() - 1;
                        System.err.println("wglARBPFIDs2GLCapabilities: bucket[" + i + " -> " + n4 + "]: " + wGLGLCapabilities);
                    }
                    if (!bl) continue;
                    break;
                }
                if (!DEBUG) continue;
                WGLGLCapabilities wGLGLCapabilities2 = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(abstractGraphicsDevice, gLProfile, l, nArray[i], intBuffer, n3, intBuffer2, 15);
                System.err.println("wglARBPFIDs2GLCapabilities: bucket[" + i + " -> skip]: pfdID " + nArray[i] + ", " + wGLGLCapabilities2 + ", winattr " + GLGraphicsConfigurationUtil.winAttributeBits2String(null, n).toString());
                continue;
            }
            if (!DEBUG) continue;
            if (1 > nArray[i]) {
                System.err.println("wglARBPFIDs2GLCapabilities: Invalid pfdID " + i + "/" + n2 + ": " + nArray[i]);
                continue;
            }
            System.err.println("wglARBPFIDs2GLCapabilities: Cannot get pixel format attributes for pixel format " + i + "/" + n2 + ": " + nArray[i] + ", hdc " + WindowsWGLGraphicsConfiguration.toHexString(l));
        }
        return arrayList;
    }

    static boolean GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable, IntBuffer intBuffer, WindowsWGLDrawableFactory.SharedResource sharedResource, int n, int[] nArray) throws GLException {
        int n2;
        boolean bl;
        if (!sharedResource.hasARBPixelFormat()) {
            return false;
        }
        int n3 = 0;
        intBuffer.put(n3++, 8208);
        intBuffer.put(n3++, 1);
        if (n > 0) {
            intBuffer.put(n3++, 8195);
            intBuffer.put(n3++, n);
        }
        boolean bl2 = bl = gLCapabilitiesImmutable.isPBuffer() && sharedResource.hasARBPBuffer();
        if (gLCapabilitiesImmutable.isOnscreen()) {
            n2 = 8193;
        } else if (gLCapabilitiesImmutable.isFBO()) {
            n2 = 8193;
        } else if (bl) {
            n2 = 8237;
        } else if (gLCapabilitiesImmutable.isBitmap()) {
            n2 = 8194;
        } else {
            throw new GLException("no surface type set in caps: " + gLCapabilitiesImmutable);
        }
        intBuffer.put(n3++, n2);
        intBuffer.put(n3++, 1);
        intBuffer.put(n3++, 8209);
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            intBuffer.put(n3++, 1);
        } else {
            intBuffer.put(n3++, 0);
        }
        intBuffer.put(n3++, 8210);
        if (gLCapabilitiesImmutable.getStereo()) {
            intBuffer.put(n3++, 1);
        } else {
            intBuffer.put(n3++, 0);
        }
        intBuffer.put(n3++, 8213);
        intBuffer.put(n3++, gLCapabilitiesImmutable.getRedBits());
        intBuffer.put(n3++, 8215);
        intBuffer.put(n3++, gLCapabilitiesImmutable.getGreenBits());
        intBuffer.put(n3++, 8217);
        intBuffer.put(n3++, gLCapabilitiesImmutable.getBlueBits());
        if (gLCapabilitiesImmutable.getAlphaBits() > 0) {
            intBuffer.put(n3++, 8219);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAlphaBits());
        }
        if (gLCapabilitiesImmutable.getStencilBits() > 0) {
            intBuffer.put(n3++, 8227);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getStencilBits());
        }
        intBuffer.put(n3++, 8226);
        intBuffer.put(n3++, gLCapabilitiesImmutable.getDepthBits());
        if (gLCapabilitiesImmutable.getAccumRedBits() > 0 || gLCapabilitiesImmutable.getAccumGreenBits() > 0 || gLCapabilitiesImmutable.getAccumBlueBits() > 0 || gLCapabilitiesImmutable.getAccumAlphaBits() > 0) {
            intBuffer.put(n3++, 8221);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits());
            intBuffer.put(n3++, 8222);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumRedBits());
            intBuffer.put(n3++, 8223);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumGreenBits());
            intBuffer.put(n3++, 8224);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumBlueBits());
            intBuffer.put(n3++, 8225);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumAlphaBits());
        }
        if (gLCapabilitiesImmutable.getSampleBuffers() && sharedResource.hasARBMultisample()) {
            intBuffer.put(n3++, 8257);
            intBuffer.put(n3++, 1);
            intBuffer.put(n3++, 8258);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getNumSamples());
        }
        intBuffer.put(n3++, 8211);
        intBuffer.put(n3++, 8235);
        intBuffer.put(n3++, 0);
        return true;
    }

    static int AttribList2DrawableTypeBits(IntBuffer intBuffer, int n, IntBuffer intBuffer2) {
        int n2 = 0;
        block5: for (int i = 0; i < n; ++i) {
            int n3 = intBuffer.get(i);
            switch (n3) {
                case 8193: {
                    if (intBuffer2.get(i) != 1) continue block5;
                    n2 |= 9;
                    continue block5;
                }
                case 8194: {
                    if (intBuffer2.get(i) != 1) continue block5;
                    n2 |= 2;
                    continue block5;
                }
                case 8237: {
                    if (intBuffer2.get(i) != 1) continue block5;
                    n2 |= 4;
                }
            }
        }
        return n2;
    }

    static WGLGLCapabilities AttribList2GLCapabilities(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l, int n, IntBuffer intBuffer, int n2, IntBuffer intBuffer2, int n3) {
        int n4 = WindowsWGLGraphicsConfiguration.AttribList2DrawableTypeBits(intBuffer, n2, intBuffer2);
        int n5 = n3 & n4;
        if (0 == n5) {
            return null;
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        if (WGLUtil.DescribePixelFormat(l, n, PIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0 && 0 == (n5 &= 0xFFFFFFF4)) {
            return null;
        }
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n, gLProfile);
        wGLGLCapabilities.setValuesByARB(intBuffer, n2, intBuffer2);
        return (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(abstractGraphicsDevice, n5, wGLGLCapabilities);
    }

    static int[] wglAllGDIPFIDs(long l) {
        int n = WGLUtil.DescribePixelFormat(l, 1, 0, null);
        if (n == 0) {
            throw new GLException("DescribePixelFormat: No formats - HDC 0x" + Long.toHexString(l) + ", LastError: " + GDI.GetLastError());
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1 + i;
        }
        return nArray;
    }

    static int PFD2DrawableTypeBits(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        int n = 0;
        int n2 = pIXELFORMATDESCRIPTOR.getDwFlags();
        if (0 != (4 & n2)) {
            n |= 9;
        }
        if (0 != (8 & n2)) {
            n |= 2;
        }
        return n;
    }

    static WGLGLCapabilities PFD2GLCapabilities(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l, int n, int n2) {
        byte by;
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor(l, n);
        if (null == pIXELFORMATDESCRIPTOR) {
            return null;
        }
        if ((pIXELFORMATDESCRIPTOR.getDwFlags() & 0x20) == 0) {
            return null;
        }
        int n3 = WindowsWGLGraphicsConfiguration.PFD2DrawableTypeBits(pIXELFORMATDESCRIPTOR);
        int n4 = n2 & n3;
        if (0 == n4) {
            if (DEBUG) {
                System.err.println("Drop [drawableType mismatch]: " + WGLGLCapabilities.PFD2String(pIXELFORMATDESCRIPTOR, n));
            }
            return null;
        }
        if (2 == n4 && ((by = pIXELFORMATDESCRIPTOR.getCColorBits()) != 24 || 0 < pIXELFORMATDESCRIPTOR.getCAlphaBits())) {
            if (DEBUG) {
                System.err.println("Drop [color bits excl BITMAP]: " + WGLGLCapabilities.PFD2String(pIXELFORMATDESCRIPTOR, n));
            }
            return null;
        }
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n, gLProfile);
        wGLGLCapabilities.setValuesByGDI();
        return (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(abstractGraphicsDevice, n4, wGLGLCapabilities);
    }

    static WGLGLCapabilities PFD2GLCapabilitiesNoCheck(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l, int n) {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor(l, n);
        return WindowsWGLGraphicsConfiguration.PFD2GLCapabilitiesNoCheck(abstractGraphicsDevice, gLProfile, pIXELFORMATDESCRIPTOR, n);
    }

    static WGLGLCapabilities PFD2GLCapabilitiesNoCheck(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n) {
        if (null == pIXELFORMATDESCRIPTOR) {
            return null;
        }
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n, gLProfile);
        wGLGLCapabilities.setValuesByGDI();
        return (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(abstractGraphicsDevice, WindowsWGLGraphicsConfiguration.PFD2DrawableTypeBits(pIXELFORMATDESCRIPTOR), wGLGLCapabilities);
    }

    static PIXELFORMATDESCRIPTOR GLCapabilities2PFD(GLCapabilitiesImmutable gLCapabilitiesImmutable, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        int n = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        if (n < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        int n2 = 4128;
        if (gLCapabilitiesImmutable.isOnscreen()) {
            n2 |= 4;
        } else if (gLCapabilitiesImmutable.isFBO()) {
            n2 |= 4;
        } else if (gLCapabilitiesImmutable.isPBuffer()) {
            n2 |= 8;
        } else if (gLCapabilitiesImmutable.isBitmap()) {
            n2 |= 8;
        } else {
            throw new GLException("no surface type set in caps: " + gLCapabilitiesImmutable);
        }
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            n2 = gLCapabilitiesImmutable.isBitmap() || gLCapabilitiesImmutable.isPBuffer() ? (n2 |= 0x40000000) : (n2 |= 1);
        }
        if (gLCapabilitiesImmutable.getStereo()) {
            n2 |= 2;
        }
        pIXELFORMATDESCRIPTOR.setDwFlags(n2);
        pIXELFORMATDESCRIPTOR.setIPixelType((byte)0);
        pIXELFORMATDESCRIPTOR.setCColorBits((byte)n);
        pIXELFORMATDESCRIPTOR.setCRedBits((byte)gLCapabilitiesImmutable.getRedBits());
        pIXELFORMATDESCRIPTOR.setCGreenBits((byte)gLCapabilitiesImmutable.getGreenBits());
        pIXELFORMATDESCRIPTOR.setCBlueBits((byte)gLCapabilitiesImmutable.getBlueBits());
        pIXELFORMATDESCRIPTOR.setCAlphaBits((byte)gLCapabilitiesImmutable.getAlphaBits());
        int n3 = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits();
        pIXELFORMATDESCRIPTOR.setCAccumBits((byte)n3);
        pIXELFORMATDESCRIPTOR.setCAccumRedBits((byte)gLCapabilitiesImmutable.getAccumRedBits());
        pIXELFORMATDESCRIPTOR.setCAccumGreenBits((byte)gLCapabilitiesImmutable.getAccumGreenBits());
        pIXELFORMATDESCRIPTOR.setCAccumBlueBits((byte)gLCapabilitiesImmutable.getAccumBlueBits());
        pIXELFORMATDESCRIPTOR.setCAccumAlphaBits((byte)gLCapabilitiesImmutable.getAccumAlphaBits());
        pIXELFORMATDESCRIPTOR.setCDepthBits((byte)gLCapabilitiesImmutable.getDepthBits());
        pIXELFORMATDESCRIPTOR.setCStencilBits((byte)gLCapabilitiesImmutable.getStencilBits());
        pIXELFORMATDESCRIPTOR.setILayerType((byte)0);
        return pIXELFORMATDESCRIPTOR;
    }

    static PIXELFORMATDESCRIPTOR createPixelFormatDescriptor(long l, int n) {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.create();
        pIXELFORMATDESCRIPTOR.setNSize((short)PIXELFORMATDESCRIPTOR.size());
        pIXELFORMATDESCRIPTOR.setNVersion((short)1);
        if (0L != l && 1 <= n && WGLUtil.DescribePixelFormat(l, n, PIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
            if (DEBUG) {
                System.err.println("Info: Non displayable pixel format " + n + " of device context: error code " + GDI.GetLastError());
            }
            return null;
        }
        return pIXELFORMATDESCRIPTOR;
    }

    static PIXELFORMATDESCRIPTOR createPixelFormatDescriptor() {
        return WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor(0L, 0);
    }

    @Override
    public String toString() {
        return "WindowsWGLGraphicsConfiguration[" + this.getScreen() + ", pfdID " + this.getPixelFormatID() + ", ARB-Choosen " + this.isChoosenByARB() + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

