/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.awt.geom.AffineTransform;
import java.util.List;
import org.apache.batik.anim.dom.AttributeInitializer;
import org.apache.batik.anim.dom.SVGLocatableSupport;
import org.apache.batik.anim.dom.SVGOMAnimatedBoolean;
import org.apache.batik.anim.dom.SVGOMAnimatedLength;
import org.apache.batik.anim.dom.SVGOMAnimatedPreserveAspectRatio;
import org.apache.batik.anim.dom.SVGOMAnimatedRect;
import org.apache.batik.anim.dom.SVGOMLength;
import org.apache.batik.anim.dom.SVGStylableElement;
import org.apache.batik.anim.dom.TraitInformation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractSVGMatrix;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMAngle;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.dom.svg.SVGOMRect;
import org.apache.batik.dom.svg.SVGOMTransform;
import org.apache.batik.dom.svg.SVGSVGContext;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.svg.SVGZoomAndPanSupport;
import org.apache.batik.dom.util.ListNodeList;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.util.DoublyIndexedTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGViewSpec;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGOMSVGElement
extends SVGStylableElement
implements SVGSVGElement {
    protected static DoublyIndexedTable xmlTraitInformation;
    protected static final AttributeInitializer attributeInitializer;
    protected SVGOMAnimatedLength x;
    protected SVGOMAnimatedLength y;
    protected SVGOMAnimatedLength width;
    protected SVGOMAnimatedLength height;
    protected SVGOMAnimatedBoolean externalResourcesRequired;
    protected SVGOMAnimatedPreserveAspectRatio preserveAspectRatio;
    protected SVGOMAnimatedRect viewBox;

    protected SVGOMSVGElement() {
    }

    public SVGOMSVGElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);
        this.initializeLiveAttributes();
    }

    @Override
    protected void initializeAllLiveAttributes() {
        super.initializeAllLiveAttributes();
        this.initializeLiveAttributes();
    }

    private void initializeLiveAttributes() {
        this.x = this.createLiveAnimatedLength(null, "x", "0", (short)2, false);
        this.y = this.createLiveAnimatedLength(null, "y", "0", (short)1, false);
        this.width = this.createLiveAnimatedLength(null, "width", "100%", (short)2, true);
        this.height = this.createLiveAnimatedLength(null, "height", "100%", (short)1, true);
        this.externalResourcesRequired = this.createLiveAnimatedBoolean(null, "externalResourcesRequired", false);
        this.preserveAspectRatio = this.createLiveAnimatedPreserveAspectRatio();
        this.viewBox = this.createLiveAnimatedRect(null, "viewBox", null);
    }

    @Override
    public String getLocalName() {
        return "svg";
    }

    @Override
    public SVGAnimatedLength getX() {
        return this.x;
    }

    @Override
    public SVGAnimatedLength getY() {
        return this.y;
    }

    @Override
    public SVGAnimatedLength getWidth() {
        return this.width;
    }

    @Override
    public SVGAnimatedLength getHeight() {
        return this.height;
    }

    @Override
    public String getContentScriptType() {
        return this.getAttributeNS(null, "contentScriptType");
    }

    @Override
    public void setContentScriptType(String type) {
        this.setAttributeNS(null, "contentScriptType", type);
    }

    @Override
    public String getContentStyleType() {
        return this.getAttributeNS(null, "contentStyleType");
    }

    @Override
    public void setContentStyleType(String type) {
        this.setAttributeNS(null, "contentStyleType", type);
    }

    @Override
    public SVGRect getViewport() {
        SVGContext ctx = this.getSVGContext();
        return new SVGOMRect(0.0f, 0.0f, ctx.getViewportWidth(), ctx.getViewportHeight());
    }

    @Override
    public float getPixelUnitToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    @Override
    public float getPixelUnitToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    @Override
    public float getScreenPixelToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    @Override
    public float getScreenPixelToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    @Override
    public boolean getUseCurrentView() {
        throw new UnsupportedOperationException("SVGSVGElement.getUseCurrentView is not implemented");
    }

    @Override
    public void setUseCurrentView(boolean useCurrentView) throws DOMException {
        throw new UnsupportedOperationException("SVGSVGElement.setUseCurrentView is not implemented");
    }

    @Override
    public SVGViewSpec getCurrentView() {
        throw new UnsupportedOperationException("SVGSVGElement.getCurrentView is not implemented");
    }

    @Override
    public float getCurrentScale() {
        AffineTransform scrnTrans = this.getSVGContext().getScreenTransform();
        if (scrnTrans != null) {
            return (float)Math.sqrt(scrnTrans.getDeterminant());
        }
        return 1.0f;
    }

    @Override
    public void setCurrentScale(float currentScale) throws DOMException {
        SVGContext context = this.getSVGContext();
        AffineTransform scrnTrans = context.getScreenTransform();
        float scale = 1.0f;
        if (scrnTrans != null) {
            scale = (float)Math.sqrt(scrnTrans.getDeterminant());
        }
        float delta = currentScale / scale;
        scrnTrans = new AffineTransform(scrnTrans.getScaleX() * (double)delta, scrnTrans.getShearY() * (double)delta, scrnTrans.getShearX() * (double)delta, scrnTrans.getScaleY() * (double)delta, scrnTrans.getTranslateX(), scrnTrans.getTranslateY());
        context.setScreenTransform(scrnTrans);
    }

    @Override
    public SVGPoint getCurrentTranslate() {
        return new SVGPoint(){

            protected AffineTransform getScreenTransform() {
                SVGContext context = SVGOMSVGElement.this.getSVGContext();
                return context.getScreenTransform();
            }

            @Override
            public float getX() {
                AffineTransform scrnTrans = this.getScreenTransform();
                return (float)scrnTrans.getTranslateX();
            }

            @Override
            public float getY() {
                AffineTransform scrnTrans = this.getScreenTransform();
                return (float)scrnTrans.getTranslateY();
            }

            @Override
            public void setX(float newX) {
                SVGContext context = SVGOMSVGElement.this.getSVGContext();
                AffineTransform scrnTrans = context.getScreenTransform();
                scrnTrans = new AffineTransform(scrnTrans.getScaleX(), scrnTrans.getShearY(), scrnTrans.getShearX(), scrnTrans.getScaleY(), (double)newX, scrnTrans.getTranslateY());
                context.setScreenTransform(scrnTrans);
            }

            @Override
            public void setY(float newY) {
                SVGContext context = SVGOMSVGElement.this.getSVGContext();
                AffineTransform scrnTrans = context.getScreenTransform();
                scrnTrans = new AffineTransform(scrnTrans.getScaleX(), scrnTrans.getShearY(), scrnTrans.getShearX(), scrnTrans.getScaleY(), scrnTrans.getTranslateX(), (double)newY);
                context.setScreenTransform(scrnTrans);
            }

            @Override
            public SVGPoint matrixTransform(SVGMatrix mat) {
                AffineTransform scrnTrans = this.getScreenTransform();
                float x = (float)scrnTrans.getTranslateX();
                float y = (float)scrnTrans.getTranslateY();
                float newX = mat.getA() * x + mat.getC() * y + mat.getE();
                float newY = mat.getB() * x + mat.getD() * y + mat.getF();
                return new SVGOMPoint(newX, newY);
            }
        };
    }

    @Override
    public int suspendRedraw(int max_wait_milliseconds) {
        if (max_wait_milliseconds > 60000) {
            max_wait_milliseconds = 60000;
        } else if (max_wait_milliseconds < 0) {
            max_wait_milliseconds = 0;
        }
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        return ctx.suspendRedraw(max_wait_milliseconds);
    }

    @Override
    public void unsuspendRedraw(int suspend_handle_id) throws DOMException {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        if (!ctx.unsuspendRedraw(suspend_handle_id)) {
            throw this.createDOMException((short)8, "invalid.suspend.handle", new Object[]{suspend_handle_id});
        }
    }

    @Override
    public void unsuspendRedrawAll() {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        ctx.unsuspendRedrawAll();
    }

    @Override
    public void forceRedraw() {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        ctx.forceRedraw();
    }

    @Override
    public void pauseAnimations() {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        ctx.pauseAnimations();
    }

    @Override
    public void unpauseAnimations() {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        ctx.unpauseAnimations();
    }

    @Override
    public boolean animationsPaused() {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        return ctx.animationsPaused();
    }

    @Override
    public float getCurrentTime() {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        return ctx.getCurrentTime();
    }

    @Override
    public void setCurrentTime(float seconds) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        ctx.setCurrentTime(seconds);
    }

    @Override
    public NodeList getIntersectionList(SVGRect rect, SVGElement referenceElement) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        List list = ctx.getIntersectionList(rect, referenceElement);
        return new ListNodeList(list);
    }

    @Override
    public NodeList getEnclosureList(SVGRect rect, SVGElement referenceElement) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        List list = ctx.getEnclosureList(rect, referenceElement);
        return new ListNodeList(list);
    }

    @Override
    public boolean checkIntersection(SVGElement element, SVGRect rect) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        return ctx.checkIntersection(element, rect);
    }

    @Override
    public boolean checkEnclosure(SVGElement element, SVGRect rect) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        return ctx.checkEnclosure(element, rect);
    }

    @Override
    public void deselectAll() {
        ((SVGSVGContext)this.getSVGContext()).deselectAll();
    }

    @Override
    public SVGNumber createSVGNumber() {
        return new SVGNumber(){
            protected float value;

            @Override
            public float getValue() {
                return this.value;
            }

            @Override
            public void setValue(float f) {
                this.value = f;
            }
        };
    }

    @Override
    public SVGLength createSVGLength() {
        return new SVGOMLength(this);
    }

    @Override
    public SVGAngle createSVGAngle() {
        return new SVGOMAngle();
    }

    @Override
    public SVGPoint createSVGPoint() {
        return new SVGOMPoint(0.0f, 0.0f);
    }

    @Override
    public SVGMatrix createSVGMatrix() {
        return new AbstractSVGMatrix(){
            protected AffineTransform at = new AffineTransform();

            @Override
            protected AffineTransform getAffineTransform() {
                return this.at;
            }
        };
    }

    @Override
    public SVGRect createSVGRect() {
        return new SVGOMRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public SVGTransform createSVGTransform() {
        SVGOMTransform ret = new SVGOMTransform();
        ret.setType((short)1);
        return ret;
    }

    @Override
    public SVGTransform createSVGTransformFromMatrix(SVGMatrix matrix) {
        SVGOMTransform tr = new SVGOMTransform();
        tr.setMatrix(matrix);
        return tr;
    }

    @Override
    public Element getElementById(String elementId) {
        return this.ownerDocument.getChildElementById(this, elementId);
    }

    @Override
    public SVGElement getNearestViewportElement() {
        return SVGLocatableSupport.getNearestViewportElement(this);
    }

    @Override
    public SVGElement getFarthestViewportElement() {
        return SVGLocatableSupport.getFarthestViewportElement(this);
    }

    @Override
    public SVGRect getBBox() {
        return SVGLocatableSupport.getBBox(this);
    }

    @Override
    public SVGMatrix getCTM() {
        return SVGLocatableSupport.getCTM(this);
    }

    @Override
    public SVGMatrix getScreenCTM() {
        return SVGLocatableSupport.getScreenCTM(this);
    }

    @Override
    public SVGMatrix getTransformToElement(SVGElement element) throws SVGException {
        return SVGLocatableSupport.getTransformToElement(this, element);
    }

    @Override
    public DocumentView getDocument() {
        return (DocumentView)((Object)this.getOwnerDocument());
    }

    @Override
    public CSSStyleDeclaration getComputedStyle(Element elt, String pseudoElt) {
        AbstractView av = ((DocumentView)((Object)this.getOwnerDocument())).getDefaultView();
        return ((ViewCSS)av).getComputedStyle(elt, pseudoElt);
    }

    @Override
    public Event createEvent(String eventType) throws DOMException {
        return ((DocumentEvent)((Object)this.getOwnerDocument())).createEvent(eventType);
    }

    @Override
    public boolean canDispatch(String namespaceURI, String type) throws DOMException {
        AbstractDocument doc = (AbstractDocument)this.getOwnerDocument();
        return doc.canDispatch(namespaceURI, type);
    }

    @Override
    public StyleSheetList getStyleSheets() {
        return ((DocumentStyle)((Object)this.getOwnerDocument())).getStyleSheets();
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        return ((DocumentCSS)((Object)this.getOwnerDocument())).getOverrideStyle(elt, pseudoElt);
    }

    @Override
    public String getXMLlang() {
        return XMLSupport.getXMLLang(this);
    }

    @Override
    public void setXMLlang(String lang) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
    }

    @Override
    public String getXMLspace() {
        return XMLSupport.getXMLSpace(this);
    }

    @Override
    public void setXMLspace(String space) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", space);
    }

    @Override
    public short getZoomAndPan() {
        return SVGZoomAndPanSupport.getZoomAndPan(this);
    }

    @Override
    public void setZoomAndPan(short val) {
        SVGZoomAndPanSupport.setZoomAndPan(this, val);
    }

    @Override
    public SVGAnimatedRect getViewBox() {
        return this.viewBox;
    }

    @Override
    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    @Override
    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return this.externalResourcesRequired;
    }

    @Override
    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures(this);
    }

    @Override
    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions(this);
    }

    @Override
    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage(this);
    }

    @Override
    public boolean hasExtension(String extension) {
        return SVGTestsSupport.hasExtension(this, extension);
    }

    @Override
    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    @Override
    protected Node newNode() {
        return new SVGOMSVGElement();
    }

    @Override
    protected DoublyIndexedTable getTraitInformationTable() {
        return xmlTraitInformation;
    }

    static {
        DoublyIndexedTable t = new DoublyIndexedTable(SVGStylableElement.xmlTraitInformation);
        t.put(null, "x", new TraitInformation(true, 3, 1));
        t.put(null, "y", new TraitInformation(true, 3, 2));
        t.put(null, "width", new TraitInformation(true, 3, 1));
        t.put(null, "height", new TraitInformation(true, 3, 2));
        t.put(null, "preserveAspectRatio", new TraitInformation(true, 32));
        t.put(null, "viewBox", new TraitInformation(true, 50));
        t.put(null, "externalResourcesRequired", new TraitInformation(true, 49));
        xmlTraitInformation = t;
        attributeInitializer = new AttributeInitializer(7);
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns", "http://www.w3.org/2000/svg");
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute(null, null, "preserveAspectRatio", "xMidYMid meet");
        attributeInitializer.addAttribute(null, null, "zoomAndPan", "magnify");
        attributeInitializer.addAttribute(null, null, "version", "1.0");
        attributeInitializer.addAttribute(null, null, "contentScriptType", "text/ecmascript");
        attributeInitializer.addAttribute(null, null, "contentStyleType", "text/css");
    }
}

