/*
 * Decompiled with CFR 0.152.
 */
package tutorial.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.CutDendrogramByNumberOfClusters;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.Arrays;

public class NaiveAgglomerativeHierarchicalClustering1<O>
extends AbstractDistanceBasedAlgorithm<O, Result> {
    private static final Logging LOG = Logging.getLogger(NaiveAgglomerativeHierarchicalClustering1.class);
    int numclusters;

    public NaiveAgglomerativeHierarchicalClustering1(DistanceFunction<? super O> distanceFunction, int numclusters) {
        super(distanceFunction);
        this.numclusters = numclusters;
    }

    public Result run(Database db, Relation<O> relation) {
        DistanceQuery<O> dq = db.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        int size = ids.size();
        LOG.verbose("Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        double[][] matrix = new double[size][size];
        DBIDArrayIter ix = ids.iter();
        DBIDArrayIter iy = ids.iter();
        int x = 0;
        while (ix.valid()) {
            iy.seek(0);
            for (int y = 0; y < x; ++y) {
                double dist;
                matrix[x][y] = dist = dq.distance((DBIDRef)ix, (DBIDRef)iy);
                matrix[y][x] = dist;
                iy.advance();
            }
            ++x;
            ix.advance();
        }
        double[] height = new double[size];
        Arrays.fill(height, Double.POSITIVE_INFINITY);
        ArrayModifiableDBIDs parent = DBIDUtil.newArray(ids);
        Int2ReferenceOpenHashMap<ModifiableDBIDs> clusters = new Int2ReferenceOpenHashMap<ModifiableDBIDs>();
        int stop = size - this.numclusters;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", stop, LOG) : null;
        for (int i = 0; i < stop; ++i) {
            double min = Double.POSITIVE_INFINITY;
            int minx = -1;
            int miny = -1;
            for (int x2 = 0; x2 < size; ++x2) {
                if (height[x2] < Double.POSITIVE_INFINITY) continue;
                for (int y = 0; y < x2; ++y) {
                    if (height[y] < Double.POSITIVE_INFINITY || !(matrix[x2][y] < min)) continue;
                    min = matrix[x2][y];
                    minx = x2;
                    miny = y;
                }
            }
            assert (minx >= 0 && miny >= 0);
            ix.seek(minx);
            iy.seek(miny);
            height[minx] = min;
            parent.set(minx, iy);
            ModifiableDBIDs cx = (ModifiableDBIDs)clusters.get(minx);
            ModifiableDBIDs cy = (ModifiableDBIDs)clusters.get(miny);
            if (cy == null) {
                cy = DBIDUtil.newHashSet();
                cy.add(iy);
            }
            if (cx == null) {
                cy.add(ix);
            } else {
                cy.addDBIDs(cx);
                clusters.remove(minx);
            }
            clusters.put(miny, cy);
            for (int j = 0; j < size; ++j) {
                matrix[j][miny] = Math.min(matrix[j][minx], matrix[j][miny]);
                matrix[miny][j] = Math.min(matrix[minx][j], matrix[miny][j]);
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        Clustering dendrogram = new Clustering("Hierarchical-Clustering", "hierarchical-clustering");
        for (int x3 = 0; x3 < size; ++x3) {
            if (!(height[x3] < Double.POSITIVE_INFINITY)) continue;
            DBIDs cids = (DBIDs)clusters.get(x3);
            if (cids == null) {
                ix.seek(x3);
                cids = DBIDUtil.deref(ix);
            }
            Cluster cluster = new Cluster("Cluster", cids);
            dendrogram.addToplevelCluster(cluster);
        }
        return dendrogram;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        int numclusters = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter numclustersP = (IntParameter)new IntParameter(CutDendrogramByNumberOfClusters.Parameterizer.MINCLUSTERS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(numclustersP)) {
                this.numclusters = numclustersP.intValue();
            }
        }

        @Override
        protected NaiveAgglomerativeHierarchicalClustering1<O> makeInstance() {
            return new NaiveAgglomerativeHierarchicalClustering1(this.distanceFunction, this.numclusters);
        }
    }
}

