/*
 * Decompiled with CFR 0.152.
 */
package tutorial.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.CutDendrogramByNumberOfClusters;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.Arrays;

@Reference(authors="R. M. Cormack", title="A Review of Classification", booktitle="Journal of the Royal Statistical Society. Series A, Vol. 134, No. 3", url="https://doi.org/10.2307/2344237", bibkey="doi:10.2307/2344237")
public class NaiveAgglomerativeHierarchicalClustering3<O>
extends AbstractDistanceBasedAlgorithm<O, Result> {
    private static final Logging LOG = Logging.getLogger(NaiveAgglomerativeHierarchicalClustering3.class);
    int numclusters;
    Linkage linkage = Linkage.WARD;

    public NaiveAgglomerativeHierarchicalClustering3(DistanceFunction<? super O> distanceFunction, int numclusters, Linkage linkage) {
        super(distanceFunction);
        this.numclusters = numclusters;
        this.linkage = linkage;
    }

    public Result run(Database db, Relation<O> relation) {
        DistanceQuery<O> dq = db.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        int size = ids.size();
        if (size > 65536) {
            throw new AbortException("This implementation does not scale to data sets larger than 65536 instances (~17 GB RAM), which results in an integer overflow.");
        }
        if (Linkage.SINGLE.equals((Object)this.linkage)) {
            LOG.verbose("Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        double[] scratch = new double[NaiveAgglomerativeHierarchicalClustering3.triangleSize(size)];
        DBIDArrayIter ix = ids.iter();
        DBIDArrayIter iy = ids.iter();
        int pos = 0;
        boolean square = Linkage.WARD.equals((Object)this.linkage) && !this.getDistanceFunction().isSquared();
        int x = 0;
        while (ix.valid()) {
            iy.seek(0);
            for (int y = 0; y < x; ++y) {
                scratch[pos] = dq.distance((DBIDRef)ix, (DBIDRef)iy);
                if (square) {
                    int n = pos;
                    scratch[n] = scratch[n] * scratch[pos];
                }
                ++pos;
                iy.advance();
            }
            ++x;
            ix.advance();
        }
        double[] height = new double[size];
        Arrays.fill(height, Double.POSITIVE_INFINITY);
        ArrayModifiableDBIDs parent = DBIDUtil.newArray(ids);
        Int2ReferenceOpenHashMap<ModifiableDBIDs> clusters = new Int2ReferenceOpenHashMap<ModifiableDBIDs>();
        int stop = size - this.numclusters;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", stop, LOG) : null;
        for (int i = 0; i < stop; ++i) {
            int j;
            double min = Double.POSITIVE_INFINITY;
            int minx = -1;
            int miny = -1;
            for (int x2 = 0; x2 < size; ++x2) {
                if (height[x2] < Double.POSITIVE_INFINITY) continue;
                int xbase = NaiveAgglomerativeHierarchicalClustering3.triangleSize(x2);
                for (int y = 0; y < x2; ++y) {
                    int idx;
                    if (height[y] < Double.POSITIVE_INFINITY || !(scratch[idx = xbase + y] < min)) continue;
                    min = scratch[idx];
                    minx = x2;
                    miny = y;
                }
            }
            assert (minx >= 0 && miny >= 0);
            ix.seek(minx);
            iy.seek(miny);
            height[minx] = min;
            parent.set(minx, iy);
            ModifiableDBIDs cx = (ModifiableDBIDs)clusters.get(minx);
            ModifiableDBIDs cy = (ModifiableDBIDs)clusters.get(miny);
            int sizex = 1;
            int sizey = 1;
            if (cy == null) {
                cy = DBIDUtil.newHashSet();
                cy.add(iy);
            } else {
                sizey = cy.size();
            }
            if (cx == null) {
                cy.add(ix);
            } else {
                sizex = cx.size();
                cy.addDBIDs(cx);
                clusters.remove(minx);
            }
            clusters.put(miny, cy);
            int xbase = NaiveAgglomerativeHierarchicalClustering3.triangleSize(minx);
            int ybase = NaiveAgglomerativeHierarchicalClustering3.triangleSize(miny);
            for (j = 0; j < miny; ++j) {
                if (height[j] < Double.POSITIVE_INFINITY) continue;
                DBIDs idsj = (DBIDs)clusters.get(j);
                int sizej = idsj == null ? 1 : idsj.size();
                scratch[ybase + j] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[ybase + j], sizej, min);
            }
            for (j = miny + 1; j < minx; ++j) {
                if (height[j] < Double.POSITIVE_INFINITY) continue;
                int jbase = NaiveAgglomerativeHierarchicalClustering3.triangleSize(j);
                DBIDs idsj = (DBIDs)clusters.get(j);
                int sizej = idsj == null ? 1 : idsj.size();
                scratch[jbase + miny] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[jbase + miny], sizej, min);
            }
            for (j = minx + 1; j < size; ++j) {
                if (height[j] < Double.POSITIVE_INFINITY) continue;
                DBIDs idsj = (DBIDs)clusters.get(j);
                int sizej = idsj == null ? 1 : idsj.size();
                int jbase = NaiveAgglomerativeHierarchicalClustering3.triangleSize(j);
                scratch[jbase + miny] = this.linkage.combine(sizex, scratch[jbase + minx], sizey, scratch[jbase + miny], sizej, min);
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        Clustering dendrogram = new Clustering("Hierarchical-Clustering", "hierarchical-clustering");
        for (int x3 = 0; x3 < size; ++x3) {
            if (!(height[x3] < Double.POSITIVE_INFINITY)) continue;
            DBIDs cids = (DBIDs)clusters.get(x3);
            if (cids == null) {
                ix.seek(x3);
                cids = DBIDUtil.deref(ix);
            }
            Cluster cluster = new Cluster("Cluster", cids);
            dendrogram.addToplevelCluster(cluster);
        }
        return dendrogram;
    }

    protected static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        private static final OptionID LINKAGE_ID = new OptionID("hierarchical.linkage", "Parameter to choose the linkage strategy.");
        int numclusters = 0;
        protected Linkage linkage = Linkage.SINGLE;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter linkageP;
            super.makeOptions(config);
            IntParameter numclustersP = (IntParameter)new IntParameter(CutDendrogramByNumberOfClusters.Parameterizer.MINCLUSTERS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(numclustersP)) {
                this.numclusters = numclustersP.intValue();
            }
            if (config.grab(linkageP = (EnumParameter)new EnumParameter<Linkage>(LINKAGE_ID, Linkage.class).setDefaultValue((Object)Linkage.WARD))) {
                this.linkage = (Linkage)((Object)linkageP.getValue());
            }
        }

        @Override
        protected NaiveAgglomerativeHierarchicalClustering3<O> makeInstance() {
            return new NaiveAgglomerativeHierarchicalClustering3(this.distanceFunction, this.numclusters, this.linkage);
        }
    }

    public static enum Linkage {
        SINGLE{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                return Math.min(dx, dy);
            }
        }
        ,
        COMPLETE{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                return Math.max(dx, dy);
            }
        }
        ,
        GROUP_AVERAGE{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                double wx = (double)sizex / (double)(sizex + sizey);
                double wy = (double)sizey / (double)(sizex + sizey);
                return wx * dx + wy * dy;
            }
        }
        ,
        WEIGHTED_AVERAGE{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                return 0.5 * (dx + dy);
            }
        }
        ,
        CENTROID{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                double wx = (double)sizex / (double)(sizex + sizey);
                double wy = (double)sizey / (double)(sizex + sizey);
                double beta = (double)(sizex * sizey) / (double)((sizex + sizey) * (sizex + sizey));
                return wx * dx + wy * dy - beta * dxy;
            }
        }
        ,
        MEDIAN{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                return 0.5 * (dx + dy) - 0.25 * dxy;
            }
        }
        ,
        WARD{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                double wx = (double)(sizex + sizej) / (double)(sizex + sizey + sizej);
                double wy = (double)(sizey + sizej) / (double)(sizex + sizey + sizej);
                double beta = (double)sizej / (double)(sizex + sizey + sizej);
                return wx * dx + wy * dy - beta * dxy;
            }
        };


        public abstract double combine(int var1, double var2, int var4, double var5, int var7, double var8);
    }
}

