/*
 * Decompiled with CFR 0.152.
 */
package tutorial.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;

@Reference(authors="R. M. Cormack", title="A Review of Classification", booktitle="Journal of the Royal Statistical Society. Series A, Vol. 134, No. 3", url="https://doi.org/10.2307/2344237", bibkey="doi:10.2307/2344237")
public class NaiveAgglomerativeHierarchicalClustering4<O>
extends AbstractDistanceBasedAlgorithm<O, PointerHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(NaiveAgglomerativeHierarchicalClustering4.class);
    Linkage linkage = Linkage.WARD;

    public NaiveAgglomerativeHierarchicalClustering4(DistanceFunction<? super O> distanceFunction, Linkage linkage) {
        super(distanceFunction);
        this.linkage = linkage;
    }

    public PointerHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        DistanceQuery<O> dq = db.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        int size = ids.size();
        if (size > 65536) {
            throw new AbortException("This implementation does not scale to data sets larger than 65536 instances (~17 GB RAM), which results in an integer overflow.");
        }
        if (Linkage.SINGLE.equals((Object)this.linkage)) {
            LOG.verbose("Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        double[] scratch = new double[NaiveAgglomerativeHierarchicalClustering4.triangleSize(size)];
        DBIDArrayIter ix = ids.iter();
        DBIDArrayIter iy = ids.iter();
        DBIDArrayIter ij = ids.iter();
        int pos = 0;
        boolean square = Linkage.WARD.equals((Object)this.linkage) && !this.getDistanceFunction().isSquared();
        int x = 0;
        while (ix.valid()) {
            iy.seek(0);
            for (int y = 0; y < x; ++y) {
                scratch[pos] = dq.distance((DBIDRef)ix, (DBIDRef)iy);
                if (square) {
                    int n = pos;
                    scratch[n] = scratch[n] * scratch[pos];
                }
                ++pos;
                iy.advance();
            }
            ++x;
            ix.advance();
        }
        WritableDBIDDataStore parent = DataStoreUtil.makeDBIDStorage(ids, 6);
        WritableDoubleDataStore height = DataStoreUtil.makeDoubleStorage(ids, 6);
        WritableIntegerDataStore csize = DataStoreUtil.makeIntegerStorage(ids, 3);
        DBIDArrayIter it = ids.iter();
        while (it.valid()) {
            parent.put((DBIDRef)it, it);
            height.put((DBIDRef)it, Double.POSITIVE_INFINITY);
            csize.put((DBIDRef)it, 1);
            it.advance();
        }
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", size - 1, LOG) : null;
        for (int i = 1; i < size; ++i) {
            int sizej;
            int jbase;
            double min = Double.POSITIVE_INFINITY;
            int minx = -1;
            int miny = -1;
            ix.seek(0);
            while (ix.valid()) {
                if (!(height.doubleValue(ix) < Double.POSITIVE_INFINITY)) {
                    int xbase = NaiveAgglomerativeHierarchicalClustering4.triangleSize(ix.getOffset());
                    iy.seek(0);
                    while (iy.getOffset() < ix.getOffset()) {
                        int idx;
                        if (!(height.doubleValue(iy) < Double.POSITIVE_INFINITY) && scratch[idx = xbase + iy.getOffset()] <= min) {
                            min = scratch[idx];
                            minx = ix.getOffset();
                            miny = iy.getOffset();
                        }
                        iy.advance();
                    }
                }
                ix.advance();
            }
            assert (minx >= 0 && miny >= 0);
            ix.seek(minx);
            iy.seek(miny);
            int sizex = csize.intValue(ix);
            int sizey = csize.intValue(iy);
            height.put((DBIDRef)ix, min);
            parent.put((DBIDRef)ix, iy);
            csize.put((DBIDRef)iy, sizex + sizey);
            int xbase = NaiveAgglomerativeHierarchicalClustering4.triangleSize(minx);
            int ybase = NaiveAgglomerativeHierarchicalClustering4.triangleSize(miny);
            ij.seek(0);
            while (ij.getOffset() < miny) {
                if (!(height.doubleValue(ij) < Double.POSITIVE_INFINITY)) {
                    int sizej2 = csize.intValue(ij);
                    scratch[ybase + ij.getOffset()] = this.linkage.combine(sizex, scratch[xbase + ij.getOffset()], sizey, scratch[ybase + ij.getOffset()], sizej2, min);
                }
                ij.advance();
            }
            ij.seek(miny + 1);
            while (ij.getOffset() < minx) {
                if (!(height.doubleValue(ij) < Double.POSITIVE_INFINITY)) {
                    jbase = NaiveAgglomerativeHierarchicalClustering4.triangleSize(ij.getOffset());
                    sizej = csize.intValue(ij);
                    scratch[jbase + miny] = this.linkage.combine(sizex, scratch[xbase + ij.getOffset()], sizey, scratch[jbase + miny], sizej, min);
                }
                ij.advance();
            }
            ij.seek(minx + 1);
            while (ij.valid()) {
                if (!(height.doubleValue(ij) < Double.POSITIVE_INFINITY)) {
                    jbase = NaiveAgglomerativeHierarchicalClustering4.triangleSize(ij.getOffset());
                    sizej = csize.intValue(ij);
                    scratch[jbase + miny] = this.linkage.combine(sizex, scratch[jbase + minx], sizey, scratch[jbase + miny], sizej, min);
                }
                ij.advance();
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        return new PointerHierarchyRepresentationResult(ids, parent, height, dq.getDistanceFunction().isSquared());
    }

    protected static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        private static final OptionID LINKAGE_ID = new OptionID("hierarchical.linkage", "Parameter to choose the linkage strategy.");
        protected Linkage linkage = Linkage.SINGLE;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            EnumParameter linkageP = (EnumParameter)new EnumParameter<Linkage>(LINKAGE_ID, Linkage.class).setDefaultValue((Object)Linkage.WARD);
            if (config.grab(linkageP)) {
                this.linkage = (Linkage)((Object)linkageP.getValue());
            }
        }

        @Override
        protected NaiveAgglomerativeHierarchicalClustering4<O> makeInstance() {
            return new NaiveAgglomerativeHierarchicalClustering4(this.distanceFunction, this.linkage);
        }
    }

    public static enum Linkage {
        SINGLE{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                return Math.min(dx, dy);
            }
        }
        ,
        COMPLETE{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                return Math.max(dx, dy);
            }
        }
        ,
        GROUP_AVERAGE{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                double wx = (double)sizex / (double)(sizex + sizey);
                double wy = (double)sizey / (double)(sizex + sizey);
                return wx * dx + wy * dy;
            }
        }
        ,
        WEIGHTED_AVERAGE{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                return 0.5 * (dx + dy);
            }
        }
        ,
        CENTROID{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                double wx = (double)sizex / (double)(sizex + sizey);
                double wy = (double)sizey / (double)(sizex + sizey);
                double beta = (double)(sizex * sizey) / (double)((sizex + sizey) * (sizex + sizey));
                return wx * dx + wy * dy - beta * dxy;
            }
        }
        ,
        MEDIAN{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                return 0.5 * (dx + dy) - 0.25 * dxy;
            }
        }
        ,
        WARD{

            @Override
            public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
                double wx = (double)(sizex + sizej) / (double)(sizex + sizey + sizej);
                double wy = (double)(sizey + sizej) / (double)(sizex + sizey + sizej);
                double beta = (double)sizej / (double)(sizex + sizey + sizej);
                return wx * dx + wy * dy - beta * dxy;
            }
        };


        public abstract double combine(int var1, double var2, int var4, double var5, int var7, double var8);
    }
}

