/*
 * Decompiled with CFR 0.152.
 */
package tutorial.clustering;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansPlusPlusInitialMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class SameSizeKMeansAlgorithm<V extends NumberVector>
extends AbstractKMeans<V, MeanModel> {
    private static final Logging LOG = Logging.getLogger(SameSizeKMeansAlgorithm.class);

    public SameSizeKMeansAlgorithm(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer) {
        super(distanceFunction, k, maxiter, initializer);
    }

    @Override
    public Clustering<MeanModel> run(Database database, Relation<V> relation) {
        DBIDs ids = relation.getDBIDs();
        double[][] means = this.initializer.chooseInitialMeans(database, (Relation<? extends NumberVector>)relation, this.k, (NumberVectorDistanceFunction<?>)this.getDistanceFunction());
        ArrayList<ModifiableDBIDs> clusters = new ArrayList<ModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            clusters.add(DBIDUtil.newHashSet(relation.size() / this.k + 2));
        }
        WritableDataStore<Meta> metas = this.initializeMeta(relation, means);
        ArrayModifiableDBIDs tids = this.initialAssignment(clusters, metas, ids);
        means = SameSizeKMeansAlgorithm.means(clusters, means, relation);
        means = this.refineResult(relation, means, clusters, metas, tids);
        Clustering<MeanModel> result = new Clustering<MeanModel>("k-Means Samesize Clustering", "kmeans-samesize-clustering");
        for (int i = 0; i < clusters.size(); ++i) {
            result.addToplevelCluster(new Cluster<MeanModel>((DBIDs)clusters.get(i), new MeanModel(means[i])));
        }
        return result;
    }

    protected WritableDataStore<Meta> initializeMeta(Relation<V> relation, double[][] means) {
        DistanceFunction df = this.getDistanceFunction();
        WritableDataStore<Meta> metas = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, Meta.class);
        DBIDIter id = relation.iterDBIDs();
        while (id.valid()) {
            Meta c = new Meta(this.k);
            NumberVector fv = (NumberVector)relation.get(id);
            for (int i = 0; i < this.k; ++i) {
                double d = c.dists[i] = df.distance(fv, DoubleVector.wrap(means[i]));
                if (i <= 0) continue;
                if (d < c.dists[c.primary]) {
                    c.primary = i;
                    continue;
                }
                if (!(d > c.dists[c.secondary])) continue;
                c.secondary = i;
            }
            metas.put(id, c);
            id.advance();
        }
        return metas;
    }

    protected ArrayModifiableDBIDs initialAssignment(List<ModifiableDBIDs> clusters, final WritableDataStore<Meta> metas, DBIDs ids) {
        ArrayModifiableDBIDs tids = DBIDUtil.newArray(ids);
        int maxsize = (tids.size() + this.k - 1) / this.k;
        Comparator<DBIDRef> comp = new Comparator<DBIDRef>(){

            @Override
            public int compare(DBIDRef o1, DBIDRef o2) {
                Meta c1 = (Meta)metas.get(o1);
                Meta c2 = (Meta)metas.get(o2);
                return -Double.compare(c1.priority(), c2.priority());
            }
        };
        DBIDArrayMIter id = tids.iter();
        int start = 0;
        block0: while (start < tids.size()) {
            tids.sort(start, tids.size(), (Comparator<? super DBIDRef>)comp);
            id.seek(start);
            while (id.valid()) {
                Meta c = (Meta)metas.get(id);
                ModifiableDBIDs cluster = clusters.get(c.primary);
                assert (cluster.size() <= maxsize);
                cluster.add(id);
                ++start;
                if (cluster.size() == maxsize) {
                    int full = c.primary;
                    id.advance();
                    while (id.valid()) {
                        Meta ca = (Meta)metas.get(id);
                        if (ca.primary == full) {
                            for (int i = 0; i < this.k; ++i) {
                                if (i == full || clusters.get(i).size() >= maxsize || ca.primary != full && !(ca.dists[i] < ca.dists[ca.primary])) continue;
                                ca.primary = i;
                            }
                            metas.put(id, ca);
                        }
                        id.advance();
                    }
                    continue block0;
                }
                id.advance();
            }
        }
        return tids;
    }

    protected void updateDistances(Relation<V> relation, double[][] means, WritableDataStore<Meta> metas, NumberVectorDistanceFunction<? super V> df) {
        DBIDIter id = relation.iterDBIDs();
        while (id.valid()) {
            Meta c = (Meta)metas.get(id);
            NumberVector fv = (NumberVector)relation.get(id);
            c.secondary = -1;
            for (int i = 0; i < this.k; ++i) {
                c.dists[i] = df.distance(fv, DoubleVector.wrap(means[i]));
                if (c.primary == i || c.secondary >= 0 && !(c.dists[i] < c.dists[c.secondary])) continue;
                c.secondary = i;
            }
            metas.put(id, c);
            id.advance();
        }
    }

    protected double[][] refineResult(Relation<V> relation, double[][] means, List<ModifiableDBIDs> clusters, final WritableDataStore<Meta> metas, ArrayModifiableDBIDs tids) {
        DistanceFunction df = this.getDistanceFunction();
        int minsize = tids.size() / this.k;
        int maxsize = (tids.size() + this.k - 1) / this.k;
        Comparator<DBIDRef> comp = new Comparator<DBIDRef>(){

            @Override
            public int compare(DBIDRef o1, DBIDRef o2) {
                Meta c1 = (Meta)metas.get(o1);
                Meta c2 = (Meta)metas.get(o2);
                return Double.compare(c1.priority(), c2.priority());
            }
        };
        int[] preferences = MathUtil.sequence(0, this.k);
        PreferenceComparator pcomp = new PreferenceComparator();
        ArrayModifiableDBIDs[] transfers = new ArrayModifiableDBIDs[this.k];
        for (int i = 0; i < this.k; ++i) {
            transfers[i] = DBIDUtil.newArray();
        }
        DBIDArrayMIter id = tids.iter();
        for (int iter = 0; this.maxiter <= 0 || iter < this.maxiter; ++iter) {
            this.updateDistances(relation, means, metas, (NumberVectorDistanceFunction<? super V>)df);
            tids.sort((Comparator<? super DBIDRef>)comp);
            int active = 0;
            id.seek(0);
            while (id.valid()) {
                Meta c = (Meta)metas.get(id);
                IntegerArrayQuickSort.sort(preferences, pcomp.select(c));
                ModifiableDBIDs source = clusters.get(c.primary);
                assert (source.contains(id));
                block3: for (int i : preferences) {
                    if (i == c.primary) continue;
                    ModifiableDBIDs dest = clusters.get(i);
                    double gain = c.gain(i);
                    DBIDArrayMIter other = transfers[i].iter();
                    while (other.valid()) {
                        Meta c2 = (Meta)metas.get(other);
                        if (gain + c2.gain(c.primary) > 0.0) {
                            this.transfer(metas, c2, dest, source, other, c.primary);
                            this.transfer(metas, c, source, dest, id, i);
                            active += 2;
                            other.remove();
                            source = dest;
                            continue block3;
                        }
                        other.advance();
                    }
                    if (!(gain > 0.0) || dest.size() >= maxsize || source.size() <= minsize) continue;
                    this.transfer(metas, c, source, dest, id, i);
                    ++active;
                    source = dest;
                }
                if (c.primary != preferences[0] && c.dists[c.primary] > c.dists[preferences[0]]) {
                    transfers[c.primary].add(id);
                }
                id.advance();
            }
            int pending = 0;
            for (int i = 0; i < this.k; ++i) {
                pending += transfers[i].size();
                transfers[i].clear();
            }
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Iteration #" + iter + ": performed " + active + " transfers skipped " + pending);
            }
            if (active <= 0) break;
            means = SameSizeKMeansAlgorithm.means(clusters, means, relation);
        }
        return means;
    }

    protected void transfer(WritableDataStore<Meta> metas, Meta meta, ModifiableDBIDs src, ModifiableDBIDs dst, DBIDRef id, int dstnum) {
        src.remove(id);
        dst.add(id);
        meta.primary = dstnum;
        metas.put(id, meta);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected int k;
        protected int maxiter = -1;
        protected KMeansInitialization initializer;
        protected NumberVectorDistanceFunction<? super V> distanceFunction;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter maxiterP;
            ObjectParameter initialP;
            IntParameter kP;
            super.makeOptions(config);
            ObjectParameter distanceFunctionP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)NumberVectorDistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distanceFunction = (NumberVectorDistanceFunction)distanceFunctionP.instantiateClass(config);
                if (!(this.distanceFunction instanceof EuclideanDistanceFunction) && !(this.distanceFunction instanceof SquaredEuclideanDistanceFunction)) {
                    LOG.warning("k-means optimizes the sum of squares - it should be used with squared euclidean distance and may stop converging otherwise!");
                }
            }
            if (config.grab(kP = (IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT))) {
                this.k = (Integer)kP.getValue();
            }
            if (config.grab(initialP = new ObjectParameter(KMeans.INIT_ID, (Class<?>)KMeansInitialization.class, KMeansPlusPlusInitialMeans.class))) {
                this.initializer = (KMeansInitialization)initialP.instantiateClass(config);
            }
            if (config.grab(maxiterP = (IntParameter)new IntParameter(KMeans.MAXITER_ID, -1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_MINUSONE_INT))) {
                this.maxiter = maxiterP.intValue();
            }
        }

        @Override
        protected SameSizeKMeansAlgorithm<V> makeInstance() {
            return new SameSizeKMeansAlgorithm<V>(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }

    public class PreferenceComparator
    implements IntComparator {
        Meta c = null;

        @Override
        public int compare(int o1, int o2) {
            return Double.compare(this.c.dists[o1], this.c.dists[o2]);
        }

        public IntComparator select(Meta c) {
            this.c = c;
            return this;
        }
    }

    private class Meta {
        double[] dists;
        int primary;
        int secondary;

        protected Meta(int k) {
            this.dists = new double[k];
            Arrays.fill(this.dists, Double.POSITIVE_INFINITY);
            this.primary = 0;
            this.secondary = 0;
        }

        protected double priority() {
            return this.dists[this.secondary] - this.dists[this.primary];
        }

        protected double gain(int i) {
            return this.dists[this.primary] - this.dists[i];
        }
    }
}

