/*
 * Decompiled with CFR 0.152.
 */
package tutorial.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

public class MultiLPNorm
extends AbstractNumberVectorDistanceFunction {
    double[] ps;
    double pinv;

    public MultiLPNorm(double[] ps) {
        double sum = 0.0;
        for (int dim = 0; dim < ps.length; ++dim) {
            assert (ps[dim] >= 0.0) : "Negative exponents are not allowed.";
            sum += ps[dim];
        }
        assert (sum > 0.0) : "At least one exponent should be different from 0!";
        this.ps = ps;
        this.pinv = (double)ps.length / sum;
    }

    @Override
    public double distance(NumberVector o1, NumberVector o2) {
        assert (o1.getDimensionality() == this.ps.length) : "Inappropriate dimensionality!";
        assert (o2.getDimensionality() == this.ps.length) : "Inappropriate dimensionality!";
        double sum = 0.0;
        for (int dim = 0; dim < this.ps.length; ++dim) {
            if (!(this.ps[dim] > 0.0)) continue;
            double delta = Math.abs(o1.doubleValue(dim) - o2.doubleValue(dim));
            sum += Math.pow(delta, this.ps[dim]);
        }
        return Math.pow(sum, this.pinv);
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, this.ps.length, this.ps.length);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EXPONENTS_ID = new OptionID("multinorm.ps", "The exponents to use for this distance function");
        double[] ps;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleListParameter ps_param = new DoubleListParameter(EXPONENTS_ID);
            if (config.grab(ps_param)) {
                this.ps = (double[])((double[])ps_param.getValue()).clone();
            }
        }

        @Override
        protected MultiLPNorm makeInstance() {
            return new MultiLPNorm(this.ps);
        }
    }
}

