/*
 * Decompiled with CFR 0.152.
 */
package tutorial.javaapi;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.StaticArrayDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.ArrayAdapterDatabaseConnection;
import de.lmu.ifi.dbs.elki.distance.distancefunction.geo.LatLngDistanceFunction;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar.RStarTreeFactory;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk.SortTileRecursiveBulkSplit;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.math.geodesy.WGS84SpheroidEarthModel;
import de.lmu.ifi.dbs.elki.persistent.AbstractPageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.ELKIBuilder;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;
import java.util.Random;

public class GeoIndexing {
    public static void main(String[] args) {
        LoggingConfiguration.setStatistics();
        Random rand = new Random(0L);
        double[][] data = new double[100000][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = GeoIndexing.randomLatitudeLongitude(rand);
        }
        ArrayAdapterDatabaseConnection dbc = new ArrayAdapterDatabaseConnection(data);
        RStarTreeFactory indexfactory = (RStarTreeFactory)new ELKIBuilder<RStarTreeFactory>(RStarTreeFactory.class).with(AbstractPageFileFactory.Parameterizer.PAGE_SIZE_ID, (Object)512).with(RStarTreeFactory.Parameterizer.BULK_SPLIT_ID, SortTileRecursiveBulkSplit.class).build();
        StaticArrayDatabase db = new StaticArrayDatabase(dbc, Arrays.asList(indexfactory));
        db.initialize();
        Relation rel = db.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        DBIDRange ids = (DBIDRange)rel.getDBIDs();
        It<Index> it = db.getHierarchy().iterDescendants(db).filter(Index.class);
        while (it.valid()) {
            it.get().logStatistics();
            it.advance();
        }
        LatLngDistanceFunction df = new LatLngDistanceFunction(WGS84SpheroidEarthModel.STATIC);
        KNNQuery<NumberVector> knnq = QueryUtil.getKNNQuery(rel, df, new Object[0]);
        DoubleVector newYork = DoubleVector.wrap(new double[]{40.73061, -73.935242});
        KNNList knns = knnq.getKNNForObject(newYork, 10);
        System.out.println("Close to New York:");
        DoubleDBIDListIter it2 = knns.iter();
        while (it2.valid()) {
            double km = it2.doubleValue() / 1000.0;
            System.out.println(rel.get(it2) + " distance: " + km + " km row: " + ids.getOffset(it2));
            it2.advance();
        }
        DoubleVector tuvalu = DoubleVector.wrap(new double[]{-7.4784205, 178.679924});
        knns = knnq.getKNNForObject(tuvalu, 10);
        System.out.println("Close to Tuvalu:");
        Iter it3 = knns.iter();
        while (it3.valid()) {
            double km = it3.doubleValue() / 1000.0;
            System.out.println(rel.get((DBIDRef)((Object)it3)) + " distance: " + km + " km row: " + ids.getOffset((DBIDRef)((Object)it3)));
            it3.advance();
        }
        it3 = db.getHierarchy().iterDescendants(db).filter(Index.class);
        while (it3.valid()) {
            ((Index)it3.get()).logStatistics();
            it3.advance();
        }
    }

    private static double[] randomLatitudeLongitude(Random r) {
        double lat = Math.pow(1.0 - r.nextDouble() * 2.0, 2.0) / 2.0 * 180.0;
        double lng = (0.5 - r.nextDouble()) * 360.0;
        return new double[]{lat, lng};
    }
}

