/*
 * Decompiled with CFR 0.152.
 */
package tutorial.javaapi;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansLloyd;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.RandomUniformGeneratedInitialMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.StaticArrayDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.ArrayAdapterDatabaseConnection;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

public class PassingDataToELKI {
    public static void main(String[] args) {
        LoggingConfiguration.setStatistics();
        double[][] data = new double[1000][2];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = Math.random();
            }
        }
        ArrayAdapterDatabaseConnection dbc = new ArrayAdapterDatabaseConnection(data);
        StaticArrayDatabase db = new StaticArrayDatabase(dbc, null);
        db.initialize();
        Relation rel = db.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        DBIDRange ids = (DBIDRange)rel.getDBIDs();
        SquaredEuclideanDistanceFunction dist = SquaredEuclideanDistanceFunction.STATIC;
        RandomUniformGeneratedInitialMeans init = new RandomUniformGeneratedInitialMeans(RandomFactory.DEFAULT);
        KMeansLloyd<NumberVector> km = new KMeansLloyd<NumberVector>(dist, 3, 0, init);
        Clustering c = (Clustering)km.run(db);
        int i = 0;
        for (Cluster clu : c.getAllClusters()) {
            System.out.println("#" + i + ": " + clu.getNameAutomatic());
            System.out.println("Size: " + clu.size());
            System.out.println("Center: " + ((double[])((KMeansModel)clu.getModel()).getPrototype()).toString());
            System.out.print("Objects: ");
            DBIDIter it = clu.getIDs().iter();
            while (it.valid()) {
                int offset = ids.getOffset(it);
                System.out.print(" " + offset);
                it.advance();
            }
            System.out.println();
            ++i;
        }
    }
}

