/*
 * Decompiled with CFR 0.152.
 */
package tutorial.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class DistanceStddevOutlier<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(DistanceStddevOutlier.class);
    protected int k;

    public DistanceStddevOutlier(DistanceFunction<? super O> distanceFunction, int k) {
        super(distanceFunction);
        this.k = k;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        KNNQuery<O> knnq = QueryUtil.getKNNQuery(relation, this.getDistanceFunction(), this.k);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(iter, this.k);
            MeanVariance mv = new MeanVariance();
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(iter, neighbor)) {
                    mv.put(neighbor.doubleValue());
                }
                neighbor.advance();
            }
            scores.putDouble(iter, mv.getSampleStddev());
            iter.advance();
        }
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        MaterializedDoubleRelation rel = new MaterializedDoubleRelation(relation.getDBIDs(), "stddev-outlier", scores);
        return new OutlierResult(meta, rel);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("stddevout.k", "Number of neighbors to get for stddev based outlier detection.");
        int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kParam = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(kParam)) {
                this.k = (Integer)kParam.getValue();
            }
        }

        @Override
        protected DistanceStddevOutlier<O> makeInstance() {
            return new DistanceStddevOutlier(this.distanceFunction, this.k);
        }
    }
}

