/*
 * Decompiled with CFR 0.152.
 */
package tutorial.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="V. Hautam\u00e4ki, I. K\u00e4rkk\u00e4inen, P. Fr\u00e4nti", title="Outlier detection using k-nearest neighbour graph", booktitle="Proc. 17th Int. Conf. Pattern Recognition (ICPR 2004)", url="https://doi.org/10.1109/ICPR.2004.1334558", bibkey="DBLP:conf/icpr/HautamakiKF04")
public class ODIN<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ODIN.class);
    int k;

    public ODIN(DistanceFunction<? super O> distanceFunction, int k) {
        super(distanceFunction);
        this.k = k;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> dq = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnq = database.getKNNQuery(dq, this.k);
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(ids, 30, 0.0);
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(iter, this.k);
            DoubleDBIDListIter nei = neighbors.iter();
            while (nei.valid()) {
                if (!DBIDUtil.equal(iter, nei)) {
                    scores.put((DBIDRef)nei, scores.doubleValue(nei) + 1.0);
                }
                nei.advance();
            }
            iter.advance();
        }
        double min = Double.POSITIVE_INFINITY;
        double max = 0.0;
        DBIDIter iter2 = ids.iter();
        while (iter2.valid()) {
            min = Math.min(min, scores.doubleValue(iter2));
            max = Math.max(max, scores.doubleValue(iter2));
            iter2.advance();
        }
        InvertedOutlierScoreMeta meta = new InvertedOutlierScoreMeta(min, max, 0.0, ids.size() - 1, this.k);
        MaterializedDoubleRelation rel = new MaterializedDoubleRelation("ODIN In-Degree", "odin", scores, ids);
        return new OutlierResult(meta, rel);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("odin.k", "Number of neighbors to use for kNN graph.");
        int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter param = new IntParameter(K_ID);
            param.addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(param)) {
                this.k = param.intValue();
            }
        }

        @Override
        protected ODIN<O> makeInstance() {
            return new ODIN(this.distanceFunction, this.k);
        }
    }
}

