#!/bin/bash
for filename in ../datasets/*.csv; do
	echo "Starting benchmarks for $filename"	
	echo "Running DBSCAN"
  	for ((i=0; i<15; i++)); do
	  java -jar ..\/lib\/elki-bundle-0.7.5.jar KDDCLIApplication \
	    -dbc.in $filename \
	    -time \
	    -algorithm clustering.DBSCAN \
	    -dbscan.epsilon 0.1 \
	    -dbscan.minpts 2 \
	    -evaluator NoAutomaticEvaluation \
	    -resulthandler DiscardResultHandler
	done	
	echo "Running OPTICS"
	for ((i=0; i<15; i++)); do
	  java -jar ..\/lib\/elki-bundle-0.7.5.jar KDDCLIApplication \
	    -dbc.in $filename \
	    -time \
	    -algorithm clustering.optics.OPTICSHeap \
	    -optics.epsilon 1.0 \
	    -optics.minpts 2 \
	    -evaluator NoAutomaticEvaluation \
	    -resulthandler DiscardResultHandler
	done	
	echo "Done benchmarking $filename"
done

