raw <- system('grep "runtime\\|Starting\\|Running"  ELKI_out.txt', intern = TRUE)

timings <- data.frame(dataset = character(0), alg = character(0), timing = numeric(0))

for(l in raw) {
  if(startsWith(l, "Starting")) {
    ds <- gsub(".*/([^/]+)\\.csv", "\\1", l)
  }
  
  if(startsWith(l, "Running")) {
    alg <- gsub("Running (.*)", "\\1", l)
  }
  
  if(endsWith(l, "ms")) {
    tm <- as.numeric(gsub(".* (\\d+) ms", "\\1", l))
    
    timings <- rbind(timings, data.frame(dataset = ds, alg = alg, timing = tm))
  }
  
}  

agg <- aggregate(timing ~ ., timings, FUN = mean)

df <- data.frame(dbscan = agg[agg$alg == "DBSCAN",]$timing,
                  optics = agg[agg$alg == "OPTICS",]$timing)
rownames(df) <- agg[agg$alg == "DBSCAN",]$dataset

write.csv(df, file = "timings.csv")
